/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm24.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm24.j9.IAlgorithm;
import com.ibm.j9ddr.vm24.j9.ROMHelp;
import com.ibm.j9ddr.vm24.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm24.pointer.U32Pointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9EnclosingObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9LineNumberPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SourceDebugExtensionPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VariableInfoPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VariableInfoValuesPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ConstantPoolHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm24.structure.J9Consts;
import com.ibm.j9ddr.vm24.structure.J9LineNumber;
import com.ibm.j9ddr.vm24.structure.J9Method;
import com.ibm.j9ddr.vm24.structure.J9MethodDebugInfo;
import com.ibm.j9ddr.vm24.structure.J9VariableInfo;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.LinkedList;

public class OptInfo {
    private static IOptInfoImpl impl;
    private static final AlgorithmPicker<IOptInfoImpl> picker;

    private static IOptInfoImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    public static int getLineNumberForROMClass(J9MethodPointer method, UDATA relativePC) throws CorruptDataException {
        return OptInfo.getImpl().getLineNumberForROMClass(method, relativePC);
    }

    public static J9MethodDebugInfoPointer getMethodDebugInfoForROMClass(J9MethodPointer method) throws CorruptDataException {
        J9ConstantPoolPointer cp = J9ConstantPoolHelper.J9_CP_FROM_METHOD(method);
        J9MethodPointer ramMethods = cp.ramClass().ramMethods();
        long offset = (method.getAddress() - ramMethods.getAddress()) / J9Method.SIZEOF;
        U32Pointer methodDebugInfoArray = OptInfo.getMethodDebugInfoArrayForROMClass(cp.ramClass().romClass());
        if (methodDebugInfoArray.isNull()) {
            return J9MethodDebugInfoPointer.NULL;
        }
        SelfRelativePointer srp = SelfRelativePointer.cast(methodDebugInfoArray.add(offset));
        return J9MethodDebugInfoPointer.cast(srp.get());
    }

    public static U32Pointer getMethodDebugInfoArrayForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        SelfRelativePointer srpPtr = OptInfo.getSRPPtr(romClass.optionalInfo(), romClass.optionalFlags(), J9Consts.J9_ROMCLASS_OPTINFO_METHOD_INFO);
        if (!srpPtr.isNull()) {
            return U32Pointer.cast(srpPtr.get());
        }
        return U32Pointer.NULL;
    }

    public static J9LineNumberPointer getLineNumberTableForROMClass(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        if (!methodInfo.lineNumberCount().eq(0L)) {
            return J9LineNumberPointer.cast(methodInfo.add(1L));
        }
        return J9LineNumberPointer.NULL;
    }

    private static SelfRelativePointer getSRPPtr(U32Pointer ptr, U32 flags, long option) {
        if (!flags.anyBitsIn(option) || ptr.isNull()) {
            return SelfRelativePointer.NULL;
        }
        return SelfRelativePointer.cast(ptr.add(OptInfo.countBits(OptInfo.COUNT_MASK(flags, option)) - 1));
    }

    public static int countBits(U32 word) {
        int count = 0;
        for (long x = word.longValue(); x != 0L; x >>= 1) {
            if ((x & 1L) == 0L) continue;
            ++count;
        }
        return count;
    }

    public static J9VariableInfoPointer getVariableTableForROMClass(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        if (!methodInfo.varInfoCount().eq(0L)) {
            return J9VariableInfoPointer.cast(U8Pointer.cast(methodInfo).addOffset(J9MethodDebugInfo.SIZEOF).addOffset(methodInfo.lineNumberCount().mult((int)J9LineNumber.SIZEOF)));
        }
        return J9VariableInfoPointer.NULL;
    }

    public static UDATA variableInfoSize(UDATA modifiers) {
        UDATA size = new UDATA(J9VariableInfo.SIZEOF);
        if (modifiers.allBitsIn(J9Consts.J9_ROMCLASS_OPTINFO_VARIABLE_TABLE_HAS_GENERIC)) {
            size = size.add(4L);
        }
        return size;
    }

    public static J9VariableInfoValuesPointer variableInfoStartDo(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        if (methodInfo.varInfoCount().eq(0L)) {
            return J9VariableInfoValuesPointer.NULL;
        }
        return J9VariableInfoValuesPointer.cast(OptInfo.getVariableTableForROMClass(methodInfo));
    }

    public static J9VariableInfoValuesPointer variableInfoNextDo(J9VariableInfoValuesPointer current) throws CorruptDataException {
        return J9VariableInfoValuesPointer.cast(U8Pointer.cast(current).addOffset(OptInfo.variableInfoSize(new UDATA(current.visibilityLength()))));
    }

    public static U32 COUNT_MASK(U32 value, long mask) {
        return value.bitAnd((mask << 1) - 1L);
    }

    public static String getSourceFileNameForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        return OptInfo.getOption(romClass, J9Consts.J9_ROMCLASS_OPTINFO_SOURCE_FILE_NAME);
    }

    public static String getSimpleNameForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        return OptInfo.getOption(romClass, J9Consts.J9_ROMCLASS_OPTINFO_SIMPLE_NAME);
    }

    public static String getGenericSignatureForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        return OptInfo.getOption(romClass, J9Consts.J9_ROMCLASS_OPTINFO_GENERIC_SIGNATURE);
    }

    public static J9EnclosingObjectPointer getEnclosingMethodForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        VoidPointer structure = OptInfo.getStructure(romClass, J9Consts.J9_ROMCLASS_OPTINFO_ENCLOSING_METHOD);
        if (!structure.isNull()) {
            return J9EnclosingObjectPointer.cast(structure);
        }
        return J9EnclosingObjectPointer.NULL;
    }

    private static String getOption(J9ROMClassPointer romClass, long option) throws CorruptDataException {
        VoidPointer structure = OptInfo.getStructure(romClass, option);
        if (structure != VoidPointer.NULL) {
            J9UTF8Pointer ptr = J9UTF8Pointer.cast(structure);
            return J9UTF8Helper.stringValue(ptr);
        }
        return null;
    }

    private static VoidPointer getStructure(J9ROMClassPointer romClass, long option) throws CorruptDataException {
        SelfRelativePointer ptr = OptInfo.getSRPPtr(romClass.optionalInfo(), romClass.optionalFlags(), option);
        if (!ptr.isNull()) {
            return VoidPointer.cast(ptr.get());
        }
        return VoidPointer.NULL;
    }

    public static J9SourceDebugExtensionPointer getSourceDebugExtensionForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        SelfRelativePointer srpPtr = OptInfo.getSRPPtr(romClass.optionalInfo(), romClass.optionalFlags(), J9Consts.J9_ROMCLASS_OPTINFO_SOURCE_DEBUG_EXTENSION);
        if (!srpPtr.isNull()) {
            return J9SourceDebugExtensionPointer.cast(srpPtr.get());
        }
        return J9SourceDebugExtensionPointer.NULL;
    }

    static {
        picker = new AlgorithmPicker<IOptInfoImpl>("OPT_INFO_VERSION"){

            @Override
            protected Iterable<? extends IOptInfoImpl> allAlgorithms() {
                LinkedList<OptInfo_24_V0> list = new LinkedList<OptInfo_24_V0>();
                list.add(new OptInfo_24_V0());
                return list;
            }
        };
    }

    private static interface IOptInfoImpl
    extends IAlgorithm {
        public int getLineNumberForROMClass(J9MethodPointer var1, UDATA var2) throws CorruptDataException;
    }

    private static class OptInfo_24_V0
    extends BaseAlgorithm
    implements IOptInfoImpl {
        protected OptInfo_24_V0() {
            super(40, 0);
        }

        @Override
        public int getLineNumberForROMClass(J9MethodPointer method, UDATA relativePC) throws CorruptDataException {
            J9MethodDebugInfoPointer methodInfo;
            UDATA bytecodeSize = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(method));
            int number = -1;
            if ((relativePC.lt(bytecodeSize) || bytecodeSize.eq(0L)) && (methodInfo = OptInfo.getMethodDebugInfoForROMClass(method)).notNull()) {
                J9LineNumberPointer currentLineNumber = OptInfo.getLineNumberTableForROMClass(methodInfo);
                J9LineNumberPointer lastLineNumber = J9LineNumberPointer.NULL;
                for (long i = 0L; i < methodInfo.lineNumberCount().longValue() && !relativePC.lt(currentLineNumber.location()); ++i) {
                    lastLineNumber = currentLineNumber;
                    currentLineNumber = currentLineNumber.add(1L);
                }
                if (lastLineNumber.notNull()) {
                    number = lastLineNumber.lineNumber().intValue();
                }
            }
            return number;
        }
    }
}

