/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.AbstractCoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.macho.DylibCommand;
import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import com.ibm.j9ddr.corereaders.macho.OSXProcessAddressSpace;
import com.ibm.j9ddr.corereaders.macho.SegmentCommand64;
import com.ibm.j9ddr.corereaders.macho.ThreadCommand;
import com.ibm.j9ddr.corereaders.memory.DumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.UnbackedMemorySource;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.Register;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class MachoDumpReader
extends AbstractCoreReader
implements ILibraryDependentCore {
    private static final int MACHO_64 = -17958193;
    private static final int MACHO_64_REV = -805638658;
    public static final int MH_OBJECT = 1;
    public static final int MH_EXECUTE = 2;
    public static final int MH_FVMLIB = 3;
    public static final int MH_CORE = 4;
    public static final int MH_PRELOAD = 5;
    public static final int MH_DYLIB = 6;
    public static final int MH_DYLINKER = 7;
    public static final int MH_BUNDLE = 8;
    public static final int MH_DYLIB_STUB = 9;
    public static final int MH_DSYM = 10;
    public static final int MH_KEXT_BUNDLE = 11;
    private static final int MH_NOUNDEFS = 1;
    private static final int MH_INCRLINK = 2;
    private static final int MH_DYLDLINK = 4;
    private static final int MH_BINDATLOAD = 8;
    private static final int MH_PREBOUND = 16;
    private static final int MH_SPLIT_SEGS = 32;
    private static final int MH_LAZY_INIT = 64;
    private static final int MH_TWOLEVEL = 128;
    private static final int MH_FORCE_FLAT = 256;
    private static final int MH_NOMULTIDEFS = 512;
    private static final int MH_NOFIXPREBINDING = 1024;
    private static final int MH_PREBINDABLE = 2048;
    private static final int MH_ALLMODSBOUND = 4096;
    private static final int MH_SUBSECTIONS_VIA_SYMBOLS = 8192;
    private static final int MH_CANONICAL = 16384;
    private static final int MH_WEAK_DEFINES = 32768;
    private static final int MH_BINDS_TO_WEAK = 65536;
    private static final int MH_ALLOW_STACK_EXECUTION = 131072;
    private static final int MH_ROOT_SAFE = 262144;
    private static final int MH_SETUID_SAFE = 524288;
    private static final int MH_NO_REEXPORTED_DYLIBS = 0x100000;
    private static final int MH_PIE = 0x200000;
    private static final int MH_DEAD_STRIPPABLE_DYLIB = 0x400000;
    private static final int MH_HAS_TLV_DESCRIPTORS = 0x800000;
    private static final int MH_NO_HEAP_EXECUTION = 0x1000000;
    private static final int MH_APP_EXTENSION_SAFE = 0x2000000;
    static final int CPU_TYPE_X86 = 7;
    static final int CPU_TYPE_X86_64 = 0x1000007;
    static final int CPU_TYPE_AARCH64 = 0x100000C;
    private static final int header64Size = 32;
    private static final int loadCommandSize = 8;
    private MachFile64 dumpFile;
    private MachFile64 executableMachFile;
    private MachFile64 dylinkerMachFile;
    private List<MachFile64> dylibMachFiles;
    private OSXProcessAddressSpace _process;
    private IModule _executable;
    private List<IModule> _modules;
    private int _signalNumber = -1;

    public MachoDumpReader(ImageInputStream in) throws IOException, InvalidDumpFormatException {
        this.coreFile = null;
        this._modules = new ArrayList<IModule>();
        this.dylibMachFiles = new ArrayList<MachFile64>();
        this.setReader(in);
        this.readCore();
    }

    public static boolean isMACHO(byte[] data) {
        int magic = MachoDumpReader.readInt(data, 0);
        return MachoDumpReader.isMACHO(magic);
    }

    private static boolean isMACHO(int magic) {
        return magic == -17958193 || magic == -805638658;
    }

    public static ICore getReaderForFile(File f) throws IOException, InvalidDumpFormatException {
        FileImageInputStream in = new FileImageInputStream(f);
        return MachoDumpReader.getReaderForFile(in);
    }

    public static ICore getReaderForFile(ImageInputStream in) throws IOException, InvalidDumpFormatException {
        int magic = in.readInt();
        if (!MachoDumpReader.isMACHO(magic)) {
            throw new InvalidDumpFormatException("The supplied file is not an Mach-O core dump.");
        }
        return new MachoDumpReader(in);
    }

    public String getCommandLine() throws DataUnavailableException {
        throw new DataUnavailableException("No command line available on OSX");
    }

    @Override
    public Platform getPlatform() {
        return Platform.OSX;
    }

    @Override
    public String getDumpFormat() {
        return "macho";
    }

    @Override
    public Collection<? extends IAddressSpace> getAddressSpaces() {
        return Collections.singletonList(this._process);
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("system.type", "OSX");
        props.setProperty("cpu.type", this.getCpuType());
        props.setProperty("cpu.subtype", "");
        return props;
    }

    @Override
    public void executablePathHint(String path) {
        if (this._executable != null) {
            try {
                this._executable = new Module(this._process, path, (List)this._executable.getSymbols(), this._executable.getMemoryRanges(), this._executable.getLoadAddress(), this._executable.getProperties());
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
        }
    }

    public IModule getExecutable() {
        return this._executable;
    }

    public List<? extends IModule> getModules() {
        return this._modules;
    }

    public long getProcessId() {
        return 0L;
    }

    public List<? extends IOSThread> getThreads() throws CorruptDataException {
        ArrayList<OSXAMD64Thread> threads = new ArrayList<OSXAMD64Thread>(this.dumpFile.threads.size());
        int cpuType = this.dumpFile.header.cpuType;
        for (ThreadCommand command : this.dumpFile.threads) {
            String sigNumReg;
            OSXThread nativeThread;
            switch (cpuType) {
                case 0x1000007: {
                    nativeThread = new OSXAMD64Thread(0L, command);
                    break;
                }
                case 0x100000C: {
                    nativeThread = new OSXAArch64Thread(0L, command);
                    break;
                }
                default: {
                    throw new CorruptDataException("Unrecognized CPU type.");
                }
            }
            threads.add((OSXAMD64Thread)nativeThread);
            if (this._signalNumber != -1) continue;
            String string = sigNumReg = cpuType == 0x1000007 ? "err" : "esr";
            if (nativeThread.registers.containsKey(sigNumReg)) {
                this._signalNumber = nativeThread.registers.get(sigNumReg).intValue();
                continue;
            }
            throw new CorruptDataException("Core dump missing thread exception registers.");
        }
        return threads;
    }

    public int getSignalNumber() throws DataUnavailableException {
        if (this._signalNumber == -1) {
            try {
                this.getThreads();
            }
            catch (CorruptDataException e) {
                throw new DataUnavailableException("Core dump missing thread exception registers.", e);
            }
        }
        return this._signalNumber;
    }

    private void readCore() throws IOException, InvalidDumpFormatException {
        this.dumpFile = this.readMachFile(0L);
        if (this.dumpFile.header.fileType != 4) {
            throw new InvalidDumpFormatException("The supplied file is not an Mach-O core dump.");
        }
        this._process = new OSXProcessAddressSpace(8, this._fileReader.getByteOrder(), this);
        Collection<? extends IMemorySource> coreMemoryRanges = this.dumpFile.getMemoryRangesWithOffset(0L);
        this._process.addMemorySources(coreMemoryRanges);
        for (SegmentCommand64 segment : this.dumpFile.segments) {
            this.seek(segment.fileOffset);
            try {
                int magic = this.readInt();
                if (!MachoDumpReader.isMACHO(magic)) continue;
                MachFile64 innerFile = this.readMachFile(segment.fileOffset);
                switch (innerFile.header.fileType) {
                    case 2: {
                        this.executableMachFile = innerFile;
                        this._executable = this.processExecutableFile(innerFile, segment);
                        break;
                    }
                    case 6: {
                        this.dylibMachFiles.add(innerFile);
                        this._modules.add(this.processModuleFile(innerFile, segment));
                        break;
                    }
                    case 7: {
                        this.dylinkerMachFile = innerFile;
                        break;
                    }
                }
            }
            catch (EOFException eOFException) {}
        }
    }

    public MachFile64 readMachFile(long fileOffset) throws IOException, InvalidDumpFormatException {
        MachFile64 machfile = new MachFile64();
        machfile.streamOffset = fileOffset;
        machfile.header = this.readHeader(fileOffset);
        if (machfile.header.numCommands > 0) {
            machfile.loadCommands = new ArrayList<LoadCommand>(machfile.header.numCommands);
            machfile.segments = new ArrayList<SegmentCommand64>();
            machfile.otherLoads = new ArrayList<LoadCommand>();
            machfile.threads = new ArrayList<ThreadCommand>();
        }
        long currentOffset = fileOffset + 32L;
        for (int i = 0; i < machfile.header.numCommands; ++i) {
            LoadCommand command = LoadCommand.readFullCommand(this._fileReader, currentOffset, fileOffset, machfile.header.cpuType);
            if (command instanceof SegmentCommand64) {
                machfile.segments.add((SegmentCommand64)command);
            } else if (command instanceof ThreadCommand) {
                machfile.threads.add((ThreadCommand)command);
            } else {
                machfile.otherLoads.add(command);
            }
            machfile.loadCommands.add(command);
            currentOffset += command.cmdSize;
        }
        return machfile;
    }

    private IModule processExecutableFile(MachFile64 executableFile, SegmentCommand64 container) throws IOException, InvalidDumpFormatException {
        ArrayList symbols = new ArrayList();
        Collection<? extends IMemorySource> memoryRanges = executableFile.getMemoryRangesWithOffset(container.vmaddr);
        return new Module(this._process, "executable", symbols, memoryRanges, executableFile.streamOffset, new Properties());
    }

    private IModule processModuleFile(MachFile64 moduleFile, SegmentCommand64 container) throws IOException, InvalidDumpFormatException {
        DylibCommand dylib = (DylibCommand)moduleFile.otherLoads.stream().filter(c -> c.cmdType == 13).findFirst().get();
        String moduleName = dylib.dylib.name.value;
        ArrayList symbols = new ArrayList();
        Collection<? extends IMemorySource> memoryRanges = moduleFile.getMemoryRangesWithOffset(container.vmaddr);
        return new Module(this._process, moduleName, symbols, memoryRanges, moduleFile.streamOffset, new Properties());
    }

    public MachHeader64 readHeader(long offset) throws IOException, InvalidDumpFormatException {
        this.seek(offset);
        MachHeader64 header = new MachHeader64();
        header.magic = this.readInt();
        if (header.magic == -805638658) {
            this._fileReader.setByteOrder(this._fileReader.getByteOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
        header.cpuType = this.readInt();
        header.cpuSubtype = this.readInt();
        header.fileType = this.readInt();
        header.numCommands = this.readInt();
        header.sizeCommands = Integer.toUnsignedLong(this.readInt());
        header.flags = this.readInt();
        this.readInt();
        return header;
    }

    private String getCpuType() {
        if (this.dumpFile.header.cpuType == 0x100000C) {
            return "AARCH64";
        }
        if (this.dumpFile.header.cpuType == 0x1000007) {
            return "X86_64";
        }
        return "";
    }

    public class MachFile64 {
        public MachHeader64 header;
        public List<LoadCommand> loadCommands;
        public List<SegmentCommand64> segments;
        public List<LoadCommand> otherLoads;
        public List<ThreadCommand> threads;
        long streamOffset;

        public Collection<? extends IMemorySource> getMemoryRangesWithOffset(long vmAddrOffset) throws IOException {
            LinkedList<ProtectedMemoryRange> ranges = new LinkedList<ProtectedMemoryRange>();
            for (SegmentCommand64 segment : this.segments) {
                if (segment.fileSize == 0L) continue;
                if (MachoDumpReader.this._fileReader.length() < 0L || this.streamOffset + segment.fileOffset + segment.fileSize <= MachoDumpReader.this._fileReader.length()) {
                    ranges.add(new DumpMemorySource(segment.vmaddr + vmAddrOffset, segment.fileSize, this.streamOffset + segment.fileOffset, MachoDumpReader.this));
                    continue;
                }
                ranges.add(new UnbackedMemorySource(segment.vmaddr + vmAddrOffset, segment.fileSize, "segment is beyond file end"));
            }
            return ranges;
        }
    }

    public class MachHeader64 {
        public int magic;
        public int cpuType;
        public int cpuSubtype;
        public int fileType;
        public int numCommands;
        public long sizeCommands;
        public int flags;

        public MachHeader64() {
        }

        public MachHeader64(int magic, int cpuType, int cpuSubtype, int fileType, int numCommands, long sizeCommands, int flags) {
            this.magic = magic;
            this.cpuType = cpuType;
            this.cpuSubtype = cpuSubtype;
            this.fileType = fileType;
            this.numCommands = numCommands;
            this.sizeCommands = sizeCommands;
            this.flags = flags;
        }
    }

    public static final class OSXAArch64Thread
    extends OSXThread {
        public OSXAArch64Thread(long tid, ThreadCommand thread) {
            super(tid, thread);
        }

        @Override
        public long getInstructionPointer() {
            return ((Number)this.registers.get("pc")).longValue();
        }

        @Override
        public long getBasePointer() {
            return ((Number)this.registers.get("fp")).longValue();
        }

        @Override
        public long getStackPointer() {
            return ((Number)this.registers.get("sp")).longValue();
        }
    }

    public static final class OSXAMD64Thread
    extends OSXThread {
        public OSXAMD64Thread(long tid, ThreadCommand thread) {
            super(tid, thread);
        }

        @Override
        public long getInstructionPointer() {
            return ((Number)this.registers.get("rip")).longValue();
        }

        @Override
        public long getBasePointer() {
            return ((Number)this.registers.get("rbp")).longValue();
        }

        @Override
        public long getStackPointer() {
            return ((Number)this.registers.get("rsp")).longValue();
        }
    }

    public static abstract class OSXThread
    implements IOSThread {
        final Map<String, Number> registers;
        private final Properties properties;
        private final long threadId;
        private final List<IMemoryRange> memoryRanges = new LinkedList<IMemoryRange>();
        private final List<IOSStackFrame> stackFrames = new LinkedList<IOSStackFrame>();

        public OSXThread(long tid, ThreadCommand thread) {
            this.threadId = tid;
            this.registers = new TreeMap<String, Number>();
            for (ThreadCommand.ThreadState state : thread.states) {
                this.registers.putAll(state.registers);
            }
            this.properties = new Properties();
        }

        @Override
        public long getThreadId() throws CorruptDataException {
            return this.threadId;
        }

        @Override
        public List<? extends IOSStackFrame> getStackFrames() {
            return Collections.emptyList();
        }

        @Override
        public Collection<? extends IRegister> getRegisters() {
            ArrayList<Register> regList = new ArrayList<Register>(this.registers.size());
            for (String regName : this.registers.keySet()) {
                Number value = this.registers.get(regName);
                regList.add(new Register(regName, value));
            }
            return regList;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            return this.memoryRanges;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }
    }
}

