/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMUtils;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.enc.ReferenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class DOMReferenceType
extends DOMStructure
implements ReferenceType,
DOMURIReference {
    final String uri;
    List content;
    Element refElem;
    InputStream dis;

    public DOMReferenceType(String uri, List content) {
        if (uri == null) {
            throw new NullPointerException("uri must be non-null");
        }
        if (content == null || content.isEmpty()) {
            this.content = Collections.EMPTY_LIST;
        } else {
            ArrayList contentCopy = new ArrayList(content);
            for (int i = 0; i < contentCopy.size(); ++i) {
                if (contentCopy.get(i) instanceof XMLStructure) continue;
                throw new ClassCastException("content[" + i + "] is not a valid type");
            }
            this.content = Collections.unmodifiableList(contentCopy);
        }
        try {
            new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.uri = uri;
    }

    public DOMReferenceType(Element refElem) throws MarshalException {
        Element nextSibling = DOMUtils.getFirstChildElement(refElem);
        ArrayList<javax.xml.crypto.dom.DOMStructure> content = new ArrayList<javax.xml.crypto.dom.DOMStructure>();
        while (nextSibling != null) {
            content.add(new javax.xml.crypto.dom.DOMStructure(nextSibling));
            nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
        }
        this.uri = DOMUtils.getAttributeValue(refElem, "URI");
        this.content = content.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(content);
        if (this.uri == null) {
            throw new MarshalException("uri must be non-null");
        }
        try {
            new URI(this.uri);
        }
        catch (URISyntaxException e) {
            throw new MarshalException(e.getMessage());
        }
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getType() {
        return null;
    }

    public List getContent() {
        return this.content;
    }

    @Override
    public abstract void marshal(Node var1, String var2, DOMCryptoContext var3) throws MarshalException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DOMReferenceType)) {
            return false;
        }
        DOMReferenceType oref = (DOMReferenceType)o;
        boolean urisEqual = this.uri.equals(oref.getURI());
        return urisEqual;
    }
}

