/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMDataReference;
import com.ibm.xml.enc.dom.DOMKeyReference;
import com.ibm.xml.enc.dom.DOMReferenceType;
import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.ReferenceType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMReferenceList
extends DOMStructure {
    private Attr here;
    private List references;
    private Element refElem;
    private InputStream dis;

    public DOMReferenceList(List references) {
        if (references == null) {
            throw new NullPointerException("references must be non-null");
        }
        if (references == null || references.isEmpty()) {
            this.references = Collections.EMPTY_LIST;
        } else {
            ArrayList referencesCopy = new ArrayList(references);
            for (int i = 0; i < referencesCopy.size(); ++i) {
                if (referencesCopy.get(i) instanceof DOMReferenceType) continue;
                throw new ClassCastException("references[" + i + "] is not a valid type");
            }
            this.references = Collections.unmodifiableList(referencesCopy);
        }
    }

    public DOMReferenceList(Element refElem) throws MarshalException {
        Element nextSibling = DOMUtils.getFirstChildElement(refElem);
        ArrayList<ReferenceType> references = new ArrayList<ReferenceType>();
        if (nextSibling == null) {
            throw new MarshalException("There should be at least one item in the ReferenceList");
        }
        while (nextSibling != null) {
            ReferenceType rType = this.parseElement(nextSibling);
            if (rType != null) {
                references.add(rType);
            }
            nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
        }
        this.references = references.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(references);
    }

    private ReferenceType parseElement(Element elem) throws MarshalException {
        if (elem.getLocalName().equals("DataReference")) {
            return new DOMDataReference(elem);
        }
        if (elem.getLocalName().equals("KeyReference")) {
            return new DOMKeyReference(elem);
        }
        return null;
    }

    public List getReferenceList() {
        return this.references;
    }

    @Override
    public void marshal(Node parent, String encPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element refElem = DOMUtils.createElement(ownerDoc, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        if (!this.references.isEmpty()) {
            for (DOMStructure domObject : this.references) {
                domObject.marshal(refElem, encPrefix, context);
            }
        }
        parent.appendChild(refElem);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DOMReferenceList)) {
            return false;
        }
        DOMReferenceList oref = (DOMReferenceList)o;
        boolean listEqual = this.references.equals(oref.getReferenceList());
        return listEqual;
    }
}

