/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import java.security.spec.AlgorithmParameterSpec;

public class PKCS11DSAKeyPairParameterSpec
implements AlgorithmParameterSpec {
    private int keySize;
    private AlgorithmParameterSpec params;
    private String id = null;
    private String subject = null;
    private String label = null;
    private Boolean isToken = null;
    private Boolean isSensitive = null;
    private Boolean extractable = null;

    public PKCS11DSAKeyPairParameterSpec(int keySize, String id, String subject, String label, Boolean isToken, Boolean isSensitive, Boolean extractable, AlgorithmParameterSpec params) {
        this.keySize = keySize;
        this.id = id;
        this.subject = subject;
        this.label = label;
        if (isToken != null) {
            this.isToken = new Boolean(isToken);
        }
        if (isSensitive != null) {
            this.isSensitive = new Boolean(isSensitive);
        }
        if (extractable != null) {
            this.extractable = new Boolean(extractable);
        }
        this.params = params;
    }

    public PKCS11DSAKeyPairParameterSpec(int keySize, String keyIdentifier, String subject, String label, AlgorithmParameterSpec params) {
        this(keySize, keyIdentifier, subject, label, Boolean.FALSE, Boolean.FALSE, null, params);
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getKeyID() {
        return this.id;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getSensitive() {
        if (this.isSensitive != null) {
            return new Boolean(this.isSensitive);
        }
        return this.isSensitive;
    }

    public Boolean getToken() {
        if (this.isToken != null) {
            return new Boolean(this.isToken);
        }
        return this.isToken;
    }

    public Boolean getExtractable() {
        if (this.extractable != null) {
            return new Boolean(this.extractable);
        }
        return this.extractable;
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }
}

