/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public final class DESParameters
extends AlgorithmParametersSpi {
    private byte[] iv;

    public DESParameters(Provider provider) {
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        byte[] iv = ((IvParameterSpec)paramSpec).getIV();
        if (iv.length != 8) {
            throw new InvalidParameterSpecException("IV not 8 bytes long");
        }
        this.iv = (byte[])iv.clone();
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        DerInputStream der = null;
        try {
            der = new DerInputStream(encoded);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException(e.getMessage());
        }
        byte[] tmpIv = der.getOctetString();
        if (der.available() != 0) {
            throw new IOException("IV parsing error: extra data");
        }
        if (tmpIv.length != 8) {
            throw new IOException("IV not 8 bytes long");
        }
        this.iv = tmpIv;
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        try {
            Class<T> ivParamSpec = Class.forName("javax.crypto.spec.IvParameterSpec");
            if (ivParamSpec.isAssignableFrom(paramSpec)) {
                return (T)((AlgorithmParameterSpec)paramSpec.cast(new IvParameterSpec(this.iv)));
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putOctetString(this.iv);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        String ivString = "\n    iv:\n[";
        HexDumpEncoder encoder = new HexDumpEncoder();
        ivString = ivString + encoder.encodeBuffer(this.iv);
        ivString = ivString + "]\n";
        return ivString;
    }
}

