/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.IBMXMLCryptoProvider;
import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.KeyInfoImpl;
import com.ibm.xml.crypto.dsig.dom.KeyNameImpl;
import com.ibm.xml.crypto.dsig.dom.KeyValueImpl;
import com.ibm.xml.crypto.dsig.dom.PGPDataImpl;
import com.ibm.xml.crypto.dsig.dom.RetrievalMethodImpl;
import com.ibm.xml.crypto.dsig.dom.URIDereferencerImpl;
import com.ibm.xml.crypto.dsig.dom.Unmarshalling;
import com.ibm.xml.crypto.dsig.dom.X509DataImpl;
import com.ibm.xml.crypto.dsig.dom.X509IssuerSerialImpl;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.PublicKey;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;

public class KeyInfoFactoryImpl
extends KeyInfoFactory {
    private AlgorithmFactory afactory = null;

    protected void setAlgorithmFactory(AlgorithmFactory af) {
        this.afactory = af;
    }

    public AlgorithmFactory getAlgorithmFactory() {
        if (this.afactory == null) {
            this.afactory = AlgorithmFactory.getInstance();
        }
        return this.afactory;
    }

    public KeyInfo newKeyInfo(List content) {
        return this.newKeyInfo(content, (String)null);
    }

    public KeyInfo newKeyInfo(List content, String id) {
        return new KeyInfoImpl(this.getAlgorithmFactory(), content, id);
    }

    @Override
    public KeyName newKeyName(String name) {
        return new KeyNameImpl(this.getAlgorithmFactory(), name);
    }

    @Override
    public KeyValue newKeyValue(PublicKey key) throws KeyException {
        return new KeyValueImpl(this.getAlgorithmFactory(), key);
    }

    @Override
    public PGPData newPGPData(byte[] keyId) {
        return this.newPGPData(keyId, (byte[])null, (List)null);
    }

    public PGPData newPGPData(byte[] keyId, byte[] keyPacket, List other) {
        return new PGPDataImpl(this.getAlgorithmFactory(), keyId, keyPacket, other);
    }

    public PGPData newPGPData(byte[] keyPacket, List other) {
        return this.newPGPData((byte[])null, keyPacket, other);
    }

    @Override
    public RetrievalMethod newRetrievalMethod(String uri) {
        return this.newRetrievalMethod(uri, (String)null, (List)null);
    }

    public RetrievalMethod newRetrievalMethod(String uri, String type, List transforms) {
        return new RetrievalMethodImpl(this.getAlgorithmFactory(), uri, type, transforms);
    }

    public X509Data newX509Data(List content) {
        return new X509DataImpl(this.getAlgorithmFactory(), content);
    }

    @Override
    public X509IssuerSerial newX509IssuerSerial(String issuerName, BigInteger serialNumber) {
        return new X509IssuerSerialImpl(this.getAlgorithmFactory(), issuerName, serialNumber);
    }

    @Override
    public boolean isFeatureSupported(String feature) {
        if (feature == null) {
            throw new NullPointerException("feature must not be null.");
        }
        return false;
    }

    @Override
    public URIDereferencer getURIDereferencer() {
        return URIDereferencerImpl.getInstance();
    }

    @Override
    public KeyInfo unmarshalKeyInfo(XMLStructure xs) throws MarshalException {
        if (xs == null) {
            throw new NullPointerException("XMLStructure is null.");
        }
        try {
            return Unmarshalling.unmarshalKeyInfo(XMLSignatureFactory.getInstance("DOM", new IBMXMLCryptoProvider()), xs);
        }
        catch (NoSuchMechanismException ex) {
            throw new MarshalException(ex);
        }
    }
}

