/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.securerandom.provider;

import com.ibm.securerandom.provider.SecureRandom;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandomSpi;

public final class SHA1PRNG
extends SecureRandomSpi
implements Serializable {
    static final long serialVersionUID = -3888978670357092251L;
    private transient MessageDigest sha1;
    private SecureRandom seedGenerator;
    private BigInteger P64;
    private int[] syms = new int[16];
    private byte[] sbuf = new byte[256];
    private byte[] rngTestBuf = null;
    private long accu = 0L;
    private boolean firstTrng = true;
    private boolean extSeeded = false;
    private long rngTest = 0L;
    private int bits = 0;
    private int nsam = 64;
    private static final short[] logtab;
    byte[] state = new byte[85];
    boolean resetState = false;
    private static final String[] z;

    public SHA1PRNG() {
        this.a(null);
    }

    public SHA1PRNG(byte[] byArray) {
        this.a(byArray);
    }

    private void a(byte[] byArray) {
        byte[] byArray2 = new byte[9];
        try {
            this.sha1 = MessageDigest.getInstance(z[10], z[8]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(z[9]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(z[11]);
        }
        byArray2[0] = 1;
        byArray2[8] = 13;
        this.P64 = new BigInteger(1, byArray2);
        SHA1PRNG.a(128, this.state, 49);
        SHA1PRNG.a(30, this.state, 53);
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    public boolean isFipsApproved() {
        return true;
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        this.b(byArray);
    }

    protected synchronized void b(byte[] byArray) {
        if (byArray != null) {
            int n2 = 0;
            int n3 = byArray.length;
            if (n3 > 40) {
                MessageDigest messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance(z[0], z[3]);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InternalError(z[2]);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new InternalError(z[1]);
                }
                byte[] byArray2 = new byte[20];
                messageDigest.update(byArray);
                byArray2 = messageDigest.digest();
                n3 = 20;
                byArray = this.state;
                n2 = 65;
                System.arraycopy(byArray2, 0, this.state, 65, n3);
            }
            while (--n3 >= 0) {
                int n4 = 25 + n3 % 20;
                this.state[n4] = (byte)(this.state[n4] ^ byArray[n2 + n3]);
            }
            if (this.state[0] == 0) {
                this.state[0] = 25;
            }
            this.extSeeded = true;
        }
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        this.c(byArray);
    }

    protected synchronized void c(byte[] byArray) {
        this.b(byArray, 0, byArray.length);
    }

    public byte[] engineGenerateSeed(int n2) {
        return this.a(n2);
    }

    protected byte[] a(int n2) {
        byte[] byArray = new byte[n2];
        this.b(byArray, 0, byArray.length);
        return byArray;
    }

    private int a() {
        int n2;
        while (this.bits == 0) {
            BigInteger bigInteger;
            long l2;
            this.accu = 0L;
            int n3 = 0;
            do {
                this.syms[n3] = 0;
            } while (++n3 < 16);
            int n4 = this.sbuf.length - 1;
            int n5 = 0;
            n2 = 0;
            int n6 = 0;
            int n7 = 0;
            while (true) {
                int n8 = 0;
                do {
                    l2 = System.currentTimeMillis();
                    while (l2 == System.currentTimeMillis()) {
                        ++n8;
                    }
                } while (n8 == 0);
                this.sbuf[n4] = (byte)(this.sbuf[n4] << 4 | n8 % 16);
                n4 -= n5;
                n5 ^= 1;
                if ((n7 - n8) * (n7 - n8) != 1) {
                    n7 = n8;
                }
                int n9 = n7 % 16;
                this.syms[n9] = this.syms[n9] + n2;
                n2 |= 1;
                if (n4 < 0) {
                    bigInteger = new BigInteger(1, this.sbuf);
                    this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue();
                    n4 += this.sbuf.length;
                    n2 = 0;
                }
                if (++n6 < this.nsam) continue;
                n3 = 0;
                int n10 = 0;
                int n11 = SHA1PRNG.b(n6);
                do {
                    n2 = this.syms[n3];
                    n10 += n2 * (n11 - SHA1PRNG.b(n2));
                } while (++n3 < 16);
                this.nsam = 96000 * n6 / n10;
                if (this.nsam <= n6) break;
                this.nsam = n10 > n6 ? this.nsam + 3 : n6 + 32;
                n2 = 0;
            }
            bigInteger = new BigInteger(1, this.sbuf);
            this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue() ^ l2;
            this.bits = 64;
            if (!this.firstTrng) continue;
            this.accu = 0L;
            this.bits = 0;
            this.firstTrng = false;
        }
        n2 = (int)(this.accu & 0xFFL);
        this.accu >>>= 8;
        this.bits -= 8;
        return n2;
    }

    private void a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.state;
        while (--n3 >= 0) {
            int n4 = 25 + n3 % 20;
            byArray2[n4] = (byte)(byArray2[n4] ^ this.a());
        }
        long l2 = (long)SHA1PRNG.a(byArray2, 53) * 1000L + System.currentTimeMillis();
        SHA1PRNG.a((int)(l2 >>> 32), byArray2, 57);
        SHA1PRNG.a((int)l2, byArray2, 61);
        if (byArray2[0] == 0) {
            byArray2[0] = 25;
        }
        this.state = byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void b(byte[] byArray, int n2, int n3) {
        int n4;
        byte[] byArray2 = this.state;
        byte[] byArray3 = new byte[45];
        byte[] byArray4 = null;
        if (this.resetState) {
            this.state = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            this.resetState = false;
        }
        while ((n4 = byArray2[0]) == 0) {
            this.a(null, 0, 20);
            byArray2 = this.state;
        }
        while (true) {
            if (--n3 < 0) {
                byArray2[0] = (byte)n4;
                return;
            }
            while (n4 == 25 || this.rngTestBuf == null) {
                int n5 = SHA1PRNG.a(byArray2, 49);
                if (n5 > 0 && !this.extSeeded) {
                    long l2 = ((long)SHA1PRNG.a(byArray2, 57) << 32) + ((long)SHA1PRNG.a(byArray2, 61) & 0xFFFFFFFFL);
                    int n6 = SHA1PRNG.a(byArray2, 45);
                    int n7 = n6 + 20;
                    if (n7 < n6) {
                        n6 = 0;
                        n7 = 0 + 20;
                    }
                    SHA1PRNG.a(n7, byArray2, 45);
                    n6 += n5 - n6 % n5;
                    while (n6 < n7) {
                        if (n6 > 0x59999994 || n6 < -1503238548) {
                            this.resetState = true;
                        }
                        byte[] byArray5 = this.sbuf;
                        // MONITORENTER : this.sbuf
                        if (this.bits > 0 || System.currentTimeMillis() >= l2) {
                            int n8 = 25 + n6 / n5 % 20;
                            byArray2[n8] = (byte)(byArray2[n8] ^ this.a());
                            l2 = (long)SHA1PRNG.a(byArray2, 53) * 1000L + System.currentTimeMillis();
                            SHA1PRNG.a((int)(l2 >>> 32), byArray2, 57);
                            SHA1PRNG.a((int)l2, byArray2, 61);
                        }
                        // MONITOREXIT : byArray5
                        n6 += n5;
                    }
                }
                System.arraycopy(byArray2, 5, byArray3, 0, 45);
                this.sha1.update(byArray3, 0, byArray3.length);
                byArray4 = this.sha1.digest();
                System.arraycopy(byArray4, 0, byArray2, 5, 20);
                if (this.rngTestBuf != null) {
                    n4 = 5;
                    continue;
                }
                this.rngTestBuf = new byte[20];
                n4 = 25;
            }
            byArray[n2++] = byArray2[n4++];
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.sha1 = MessageDigest.getInstance(z[5], z[7]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(z[6]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(z[4]);
        }
    }

    private static final int b(int n2) {
        int n3 = 6;
        if (n2 == 0) {
            return 0;
        }
        while (n2 < 64) {
            n2 <<= 1;
            --n3;
        }
        while (n2 >= 128) {
            n2 >>= 1;
            ++n3;
        }
        return n3 * 1000 + logtab[n2 & 0x3F];
    }

    static final int a(byte[] byArray, int n2) {
        return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static final void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 24);
        byArray[n3 + 1] = (byte)(n2 >>> 16);
        byArray[n3 + 2] = (byte)(n2 >>> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block119: {
            int n2;
            int n3;
            block118: {
                char[] cArray2;
                Object var0;
                block117: {
                    int n4;
                    block116: {
                        char[] cArray3;
                        block115: {
                            int n5;
                            block114: {
                                char[] cArray4;
                                block113: {
                                    int n6;
                                    block112: {
                                        char[] cArray5;
                                        block111: {
                                            int n7;
                                            block110: {
                                                char[] cArray6;
                                                block109: {
                                                    int n8;
                                                    block108: {
                                                        char[] cArray7;
                                                        block107: {
                                                            int n9;
                                                            block106: {
                                                                char[] cArray8;
                                                                block105: {
                                                                    int n10;
                                                                    block104: {
                                                                        char[] cArray9;
                                                                        block103: {
                                                                            int n11;
                                                                            block102: {
                                                                                char[] cArray10;
                                                                                block101: {
                                                                                    int n12;
                                                                                    block100: {
                                                                                        char[] cArray11;
                                                                                        block99: {
                                                                                            int n13;
                                                                                            block98: {
                                                                                                char[] cArray12;
                                                                                                block97: {
                                                                                                    int n14;
                                                                                                    block96: {
                                                                                                        stringArray = new String[12];
                                                                                                        var0 = null;
                                                                                                        char[] cArray13 = "o$'.".toCharArray();
                                                                                                        cArray12 = cArray13;
                                                                                                        n14 = cArray13.length;
                                                                                                        n3 = 0;
                                                                                                        if (!true) break block96;
                                                                                                        n14 = n14;
                                                                                                        if (n14 <= n3) break block97;
                                                                                                    }
                                                                                                    do {
                                                                                                        int n15;
                                                                                                        cArray12 = cArray12;
                                                                                                        int n16 = n3;
                                                                                                        char c2 = cArray12[n16];
                                                                                                        switch (n3 % 5) {
                                                                                                            case 0: {
                                                                                                                n15 = 60;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 1: {
                                                                                                                n15 = 108;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 2: {
                                                                                                                n15 = 102;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 3: {
                                                                                                                n15 = 31;
                                                                                                                break;
                                                                                                            }
                                                                                                            default: {
                                                                                                                n15 = 114;
                                                                                                            }
                                                                                                        }
                                                                                                        cArray12[n16] = (char)(c2 ^ n15);
                                                                                                        ++n3;
                                                                                                        n14 = n14;
                                                                                                    } while (n14 > n3);
                                                                                                }
                                                                                                stringArray[0] = new String(cArray12).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray14 = "u.+L\u0017_\u0019\u0014z ]\u0002\u0002p\u001f\u001c\u0005\u0015?\u001cS\u0018F~\u0004]\u0005\n~\u0010P\t".toCharArray();
                                                                                                cArray11 = cArray14;
                                                                                                n13 = cArray14.length;
                                                                                                n3 = 0;
                                                                                                if (!true) break block98;
                                                                                                n13 = n13;
                                                                                                if (n13 <= n3) break block99;
                                                                                            }
                                                                                            do {
                                                                                                int n17;
                                                                                                cArray11 = cArray11;
                                                                                                int n18 = n3;
                                                                                                char c3 = cArray11[n18];
                                                                                                switch (n3 % 5) {
                                                                                                    case 0: {
                                                                                                        n17 = 60;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 1: {
                                                                                                        n17 = 108;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 2: {
                                                                                                        n17 = 102;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 3: {
                                                                                                        n17 = 31;
                                                                                                        break;
                                                                                                    }
                                                                                                    default: {
                                                                                                        n17 = 114;
                                                                                                    }
                                                                                                }
                                                                                                cArray11[n18] = (char)(c3 ^ n17);
                                                                                                ++n3;
                                                                                                n13 = n13;
                                                                                            } while (n13 > n3);
                                                                                        }
                                                                                        stringArray[1] = new String(cArray11).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray15 = "u.+L\u0017_\u0019\u0014z ]\u0002\u0002p\u001f\u001c?.^C\u001c\u0005\u0015?\u001cS\u0018F~\u0004]\u0005\n~\u0010P\t".toCharArray();
                                                                                        cArray10 = cArray15;
                                                                                        n12 = cArray15.length;
                                                                                        n3 = 0;
                                                                                        if (!true) break block100;
                                                                                        n12 = n12;
                                                                                        if (n12 <= n3) break block101;
                                                                                    }
                                                                                    do {
                                                                                        int n19;
                                                                                        cArray10 = cArray10;
                                                                                        int n20 = n3;
                                                                                        char c4 = cArray10[n20];
                                                                                        switch (n3 % 5) {
                                                                                            case 0: {
                                                                                                n19 = 60;
                                                                                                break;
                                                                                            }
                                                                                            case 1: {
                                                                                                n19 = 108;
                                                                                                break;
                                                                                            }
                                                                                            case 2: {
                                                                                                n19 = 102;
                                                                                                break;
                                                                                            }
                                                                                            case 3: {
                                                                                                n19 = 31;
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                n19 = 114;
                                                                                            }
                                                                                        }
                                                                                        cArray10[n20] = (char)(c4 ^ n19);
                                                                                        ++n3;
                                                                                        n12 = n12;
                                                                                    } while (n12 > n3);
                                                                                }
                                                                                stringArray[2] = new String(cArray10).intern();
                                                                                var0 = null;
                                                                                char[] cArray16 = "u.+L\u0017_\u0019\u0014z ]\u0002\u0002p\u001f".toCharArray();
                                                                                cArray9 = cArray16;
                                                                                n11 = cArray16.length;
                                                                                n3 = 0;
                                                                                if (!true) break block102;
                                                                                n11 = n11;
                                                                                if (n11 <= n3) break block103;
                                                                            }
                                                                            do {
                                                                                int n21;
                                                                                cArray9 = cArray9;
                                                                                int n22 = n3;
                                                                                char c5 = cArray9[n22];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n21 = 60;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n21 = 108;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n21 = 102;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n21 = 31;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n21 = 114;
                                                                                    }
                                                                                }
                                                                                cArray9[n22] = (char)(c5 ^ n21);
                                                                                ++n3;
                                                                                n11 = n11;
                                                                            } while (n11 > n3);
                                                                        }
                                                                        stringArray[3] = new String(cArray9).intern();
                                                                        var0 = null;
                                                                        char[] cArray17 = "u.+L\u0017_\u0019\u0014z ]\u0002\u0002p\u001f\u001c\u0005\u0015?\u001cS\u0018F~\u0004]\u0005\n~\u0010P\t".toCharArray();
                                                                        cArray8 = cArray17;
                                                                        n10 = cArray17.length;
                                                                        n3 = 0;
                                                                        if (!true) break block104;
                                                                        n10 = n10;
                                                                        if (n10 <= n3) break block105;
                                                                    }
                                                                    do {
                                                                        int n23;
                                                                        cArray8 = cArray8;
                                                                        int n24 = n3;
                                                                        char c6 = cArray8[n24];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n23 = 60;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n23 = 108;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n23 = 102;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n23 = 31;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n23 = 114;
                                                                            }
                                                                        }
                                                                        cArray8[n24] = (char)(c6 ^ n23);
                                                                        ++n3;
                                                                        n10 = n10;
                                                                    } while (n10 > n3);
                                                                }
                                                                stringArray[4] = new String(cArray8).intern();
                                                                var0 = null;
                                                                char[] cArray18 = "o$'.".toCharArray();
                                                                cArray7 = cArray18;
                                                                n9 = cArray18.length;
                                                                n3 = 0;
                                                                if (!true) break block106;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block107;
                                                            }
                                                            do {
                                                                int n25;
                                                                cArray7 = cArray7;
                                                                int n26 = n3;
                                                                char c7 = cArray7[n26];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n25 = 60;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n25 = 108;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n25 = 102;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n25 = 31;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n25 = 114;
                                                                    }
                                                                }
                                                                cArray7[n26] = (char)(c7 ^ n25);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[5] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray19 = "u.+L\u0017_\u0019\u0014z ]\u0002\u0002p\u001f\u001c?.^C\u001c\u0005\u0015?\u001cS\u0018F~\u0004]\u0005\n~\u0010P\t".toCharArray();
                                                        cArray6 = cArray19;
                                                        n8 = cArray19.length;
                                                        n3 = 0;
                                                        if (!true) break block108;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block109;
                                                    }
                                                    do {
                                                        int n27;
                                                        cArray6 = cArray6;
                                                        int n28 = n3;
                                                        char c8 = cArray6[n28];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n27 = 60;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n27 = 108;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n27 = 102;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n27 = 31;
                                                                break;
                                                            }
                                                            default: {
                                                                n27 = 114;
                                                            }
                                                        }
                                                        cArray6[n28] = (char)(c8 ^ n27);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[6] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray20 = "u.+L\u0017_\u0019\u0014z ]\u0002\u0002p\u001f".toCharArray();
                                                cArray5 = cArray20;
                                                n7 = cArray20.length;
                                                n3 = 0;
                                                if (!true) break block110;
                                                n7 = n7;
                                                if (n7 <= n3) break block111;
                                            }
                                            do {
                                                int n29;
                                                cArray5 = cArray5;
                                                int n30 = n3;
                                                char c9 = cArray5[n30];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n29 = 60;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n29 = 108;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n29 = 102;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n29 = 31;
                                                        break;
                                                    }
                                                    default: {
                                                        n29 = 114;
                                                    }
                                                }
                                                cArray5[n30] = (char)(c9 ^ n29);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[7] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray21 = "u.+L\u0017_\u0019\u0014z ]\u0002\u0002p\u001f".toCharArray();
                                        cArray4 = cArray21;
                                        n6 = cArray21.length;
                                        n3 = 0;
                                        if (!true) break block112;
                                        n6 = n6;
                                        if (n6 <= n3) break block113;
                                    }
                                    do {
                                        int n31;
                                        cArray4 = cArray4;
                                        int n32 = n3;
                                        char c10 = cArray4[n32];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n31 = 60;
                                                break;
                                            }
                                            case 1: {
                                                n31 = 108;
                                                break;
                                            }
                                            case 2: {
                                                n31 = 102;
                                                break;
                                            }
                                            case 3: {
                                                n31 = 31;
                                                break;
                                            }
                                            default: {
                                                n31 = 114;
                                            }
                                        }
                                        cArray4[n32] = (char)(c10 ^ n31);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[8] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray22 = "u.+L\u0017_\u0019\u0014z ]\u0002\u0002p\u001f\u001c?.^C\u001c\u0005\u0015?\u001cS\u0018F~\u0004]\u0005\n~\u0010P\t".toCharArray();
                                cArray3 = cArray22;
                                n5 = cArray22.length;
                                n3 = 0;
                                if (!true) break block114;
                                n5 = n5;
                                if (n5 <= n3) break block115;
                            }
                            do {
                                int n33;
                                cArray3 = cArray3;
                                int n34 = n3;
                                char c11 = cArray3[n34];
                                switch (n3 % 5) {
                                    case 0: {
                                        n33 = 60;
                                        break;
                                    }
                                    case 1: {
                                        n33 = 108;
                                        break;
                                    }
                                    case 2: {
                                        n33 = 102;
                                        break;
                                    }
                                    case 3: {
                                        n33 = 31;
                                        break;
                                    }
                                    default: {
                                        n33 = 114;
                                    }
                                }
                                cArray3[n34] = (char)(c11 ^ n33);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[9] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray23 = "o$'.".toCharArray();
                        cArray2 = cArray23;
                        n4 = cArray23.length;
                        n3 = 0;
                        if (!true) break block116;
                        n4 = n4;
                        if (n4 <= n3) break block117;
                    }
                    do {
                        int n35;
                        cArray2 = cArray2;
                        int n36 = n3;
                        char c12 = cArray2[n36];
                        switch (n3 % 5) {
                            case 0: {
                                n35 = 60;
                                break;
                            }
                            case 1: {
                                n35 = 108;
                                break;
                            }
                            case 2: {
                                n35 = 102;
                                break;
                            }
                            case 3: {
                                n35 = 31;
                                break;
                            }
                            default: {
                                n35 = 114;
                            }
                        }
                        cArray2[n36] = (char)(c12 ^ n35);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[10] = new String(cArray2).intern();
                var0 = null;
                char[] cArray24 = "u.+L\u0017_\u0019\u0014z ]\u0002\u0002p\u001f\u001c\u0005\u0015?\u001cS\u0018F~\u0004]\u0005\n~\u0010P\t".toCharArray();
                cArray = cArray24;
                n2 = cArray24.length;
                n3 = 0;
                if (!true) break block118;
                n2 = n2;
                if (n2 <= n3) break block119;
            }
            do {
                int n37;
                cArray = cArray;
                int n38 = n3;
                char c13 = cArray[n38];
                switch (n3 % 5) {
                    case 0: {
                        n37 = 60;
                        break;
                    }
                    case 1: {
                        n37 = 108;
                        break;
                    }
                    case 2: {
                        n37 = 102;
                        break;
                    }
                    case 3: {
                        n37 = 31;
                        break;
                    }
                    default: {
                        n37 = 114;
                    }
                }
                cArray[n38] = (char)(c13 ^ n37);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[11] = new String(cArray).intern();
        z = stringArray;
        logtab = new short[]{0, 22, 44, 66, 87, 109, 129, 150, 170, 190, 209, 229, 248, 267, 285, 304, 322, 340, 358, 375, 392, 409, 426, 443, 459, 476, 492, 508, 524, 539, 555, 570, 585, 600, 615, 629, 644, 658, 672, 687, 700, 714, 728, 741, 755, 768, 781, 794, 807, 820, 833, 845, 858, 870, 883, 895, 907, 919, 931, 943, 954, 966, 977, 989};
    }
}

