/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertPathConstraintsParameters;
import com.ibm.security.cert.PKIX;
import com.ibm.security.util.ConstraintsParameters;
import com.ibm.security.util.DisabledAlgorithmConstraints;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.math.BigInteger;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Timestamp;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import sun.security.util.KeyUtil;

public final class AlgorithmChecker
extends PKIXCertPathChecker {
    private AlgorithmConstraints constraints;
    private final PublicKey trustedPubKey;
    private final Date date;
    private PublicKey prevPubKey;
    private final String variant;
    private TrustAnchor anchor;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final Set<CryptoPrimitive> KU_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE, CryptoPrimitive.KEY_ENCAPSULATION, CryptoPrimitive.PUBLIC_KEY_ENCRYPTION, CryptoPrimitive.KEY_AGREEMENT));
    private static final DisabledAlgorithmConstraints certPathDefaultConstraints = DisabledAlgorithmConstraints.certPathConstraints();

    public AlgorithmChecker(TrustAnchor anchor, String variant) {
        this(anchor, (AlgorithmConstraints)certPathDefaultConstraints, null, variant);
    }

    public AlgorithmChecker(TrustAnchor anchor) {
        this(anchor, (AlgorithmConstraints)certPathDefaultConstraints, null, null, null);
    }

    public AlgorithmChecker(TrustAnchor anchor, AlgorithmConstraints constraints) {
        this(anchor, constraints, null, null, null);
    }

    public AlgorithmChecker(TrustAnchor anchor, AlgorithmConstraints constraints, String variant) {
        this(anchor, constraints, null, null, variant);
    }

    public AlgorithmChecker(AlgorithmConstraints constraints, String variant) {
        this(null, constraints, null, variant);
    }

    public AlgorithmChecker(AlgorithmConstraints constraints, Timestamp jarTimestamp, String variant) {
        this(null, constraints, null, jarTimestamp, variant);
    }

    public AlgorithmChecker(AlgorithmConstraints constraints, Timestamp jarTimestamp) {
        this(null, constraints, null, jarTimestamp, null);
    }

    public AlgorithmChecker(TrustAnchor anchor, AlgorithmConstraints constraints, Date date, String variant) {
        if (anchor != null) {
            this.trustedPubKey = anchor.getTrustedCert() != null ? anchor.getTrustedCert().getPublicKey() : anchor.getCAPublicKey();
            this.anchor = anchor;
        } else {
            this.trustedPubKey = null;
        }
        this.prevPubKey = this.trustedPubKey;
        this.constraints = constraints == null ? certPathDefaultConstraints : constraints;
        this.date = date;
        this.variant = variant == null ? "generic" : variant;
    }

    public AlgorithmChecker(TrustAnchor anchor, AlgorithmConstraints constraints, Date pkixdate, Timestamp jarTimestamp, String variant) {
        this(anchor, constraints, pkixdate, variant);
    }

    public AlgorithmChecker(TrustAnchor anchor, AlgorithmConstraints constraints, Date pkixdate, Timestamp jarTimestamp) {
        this(anchor, constraints, pkixdate, jarTimestamp, null);
    }

    public AlgorithmChecker(TrustAnchor anchor, Date date, String variant) {
        this(anchor, (AlgorithmConstraints)certPathDefaultConstraints, date, variant);
    }

    public AlgorithmChecker(TrustAnchor anchor, Date pkixdate) {
        this(anchor, (AlgorithmConstraints)certPathDefaultConstraints, pkixdate, null, null);
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (!forward) {
            this.prevPubKey = this.trustedPubKey != null ? this.trustedPubKey : null;
        } else {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        AlgorithmId algorithmId;
        X509CertImpl x509Cert;
        if (!(cert instanceof X509Certificate) || this.constraints == null) {
            return;
        }
        boolean[] keyUsage = ((X509Certificate)cert).getKeyUsage();
        if (keyUsage != null && keyUsage.length < 9) {
            throw new CertPathValidatorException("incorrect KeyUsage extension", null, null, -1, PKIXReason.INVALID_KEY_USAGE);
        }
        try {
            x509Cert = X509CertImpl.toImpl((X509Certificate)((X509Certificate)cert));
            algorithmId = (AlgorithmId)x509Cert.get("x509.algorithm");
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException(ce);
        }
        AlgorithmParameters currSigAlgParams = algorithmId.getAlgParameters();
        PublicKey currPubKey = cert.getPublicKey();
        String currSigAlg = x509Cert.getSigAlgName();
        if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, currSigAlg, currSigAlgParams)) {
            throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + currSigAlg, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
        Set<CryptoPrimitive> primitives = KU_PRIMITIVE_SET;
        if (keyUsage != null) {
            primitives = EnumSet.noneOf(CryptoPrimitive.class);
            if (keyUsage[0] || keyUsage[1] || keyUsage[5] || keyUsage[6]) {
                primitives.add(CryptoPrimitive.SIGNATURE);
            }
            if (keyUsage[2]) {
                primitives.add(CryptoPrimitive.KEY_ENCAPSULATION);
            }
            if (keyUsage[3]) {
                primitives.add(CryptoPrimitive.PUBLIC_KEY_ENCRYPTION);
            }
            if (keyUsage[4]) {
                primitives.add(CryptoPrimitive.KEY_AGREEMENT);
            }
            if (primitives.isEmpty()) {
                throw new CertPathValidatorException("incorrect KeyUsage extension bits", null, null, -1, PKIXReason.INVALID_KEY_USAGE);
            }
        }
        CertPathConstraintsParameters cp = new CertPathConstraintsParameters((X509Certificate)x509Cert, this.variant, this.anchor, this.date);
        if (this.constraints instanceof DisabledAlgorithmConstraints) {
            ((DisabledAlgorithmConstraints)this.constraints).permits(currSigAlg, currSigAlgParams, (ConstraintsParameters)cp);
        } else {
            certPathDefaultConstraints.permits(currSigAlg, currSigAlgParams, (ConstraintsParameters)cp);
            if (!this.constraints.permits(primitives, currPubKey)) {
                throw new CertPathValidatorException("Algorithm constraints check failed on key " + currPubKey.getAlgorithm() + " with size of " + KeyUtil.getKeySize(currPubKey) + "bits", null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
        if (this.prevPubKey == null) {
            this.prevPubKey = currPubKey;
            return;
        }
        if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, currSigAlg, this.prevPubKey, currSigAlgParams)) {
            throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + currSigAlg, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
        if (PKIX.isDSAPublicKeyWithoutParams(currPubKey)) {
            if (!(this.prevPubKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("Input key is not of a appropriate type for inheriting parameters");
            }
            DSAParams params = ((DSAPublicKey)this.prevPubKey).getParams();
            if (params == null) {
                throw new CertPathValidatorException("Key parameters missing from public key.");
            }
            try {
                BigInteger y = ((DSAPublicKey)currPubKey).getY();
                KeyFactory kf = KeyFactory.getInstance("DSA");
                DSAPublicKeySpec ks = new DSAPublicKeySpec(y, params.getP(), params.getQ(), params.getG());
                currPubKey = kf.generatePublic(ks);
            }
            catch (GeneralSecurityException e) {
                throw new CertPathValidatorException("Unable to generate key with inherited parameters: " + e.getMessage(), e);
            }
        }
        this.prevPubKey = currPubKey;
    }

    void trySetTrustAnchor(TrustAnchor anchor) {
        if (this.prevPubKey == null) {
            if (anchor == null) {
                throw new IllegalArgumentException("The trust anchor cannot be null");
            }
            this.prevPubKey = anchor.getTrustedCert() != null ? anchor.getTrustedCert().getPublicKey() : anchor.getCAPublicKey();
            this.anchor = anchor;
        }
    }

    static void check(PublicKey key, X509CRL crl, String variant, TrustAnchor anchor) throws CertPathValidatorException {
        X509CRLImpl x509CRLImpl = null;
        try {
            x509CRLImpl = X509CRLImpl.toImpl((X509CRL)crl);
        }
        catch (CRLException ce) {
            throw new CertPathValidatorException(ce);
        }
        AlgorithmId algorithmId = x509CRLImpl.getSigAlgId();
        AlgorithmChecker.check(key, algorithmId, variant, anchor);
    }

    static void check(PublicKey key, AlgorithmId algorithmId, String variant, TrustAnchor anchor) throws CertPathValidatorException {
        certPathDefaultConstraints.permits(algorithmId.getName(), algorithmId.getAlgParameters(), (ConstraintsParameters)new CertPathConstraintsParameters(key, variant, anchor));
    }
}

