/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.validator;

import com.ibm.security.util.Debug;
import com.ibm.security.validator.CamerfirmaTLSPolicy;
import com.ibm.security.validator.EntrustTLSPolicy;
import com.ibm.security.validator.SymantecTLSPolicy;
import com.ibm.security.validator.ValidatorException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.EnumSet;

enum CADistrustPolicy {
    SYMANTEC_TLS{

        @Override
        void checkDistrust(String variant, X509Certificate[] chain) throws ValidatorException {
            if (!variant.equals("tls server")) {
                return;
            }
            SymantecTLSPolicy.checkDistrust(chain);
        }
    }
    ,
    ENTRUST_TLS{

        @Override
        void checkDistrust(String variant, X509Certificate[] chain) throws ValidatorException {
            if (!variant.equals("tls server")) {
                return;
            }
            EntrustTLSPolicy.checkDistrust(chain);
        }
    }
    ,
    CAMERFIRMA_TLS{

        @Override
        void checkDistrust(String variant, X509Certificate[] chain) throws ValidatorException {
            if (!variant.equals("tls server")) {
                return;
            }
            CamerfirmaTLSPolicy.checkDistrust(chain);
        }
    };

    static final EnumSet<CADistrustPolicy> POLICIES;

    abstract void checkDistrust(String var1, X509Certificate[] var2) throws ValidatorException;

    private static EnumSet<CADistrustPolicy> parseProperty() {
        String[] policies;
        String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty("jdk.security.caDistrustPolicies");
            }
        });
        EnumSet<CADistrustPolicy> set = EnumSet.noneOf(CADistrustPolicy.class);
        if (property == null || property.isEmpty()) {
            return set;
        }
        for (String policy : policies = property.split(",")) {
            policy = policy.trim();
            try {
                CADistrustPolicy caPolicy = Enum.valueOf(CADistrustPolicy.class, policy);
                set.add(caPolicy);
            }
            catch (IllegalArgumentException iae) {
                Debug debug = Debug.getInstance((String)"certpath");
                if (debug == null) continue;
                debug.println("Unknown value for the jdk.security.caDistrustPolicies property: " + policy);
            }
        }
        return set;
    }

    static {
        POLICIES = CADistrustPolicy.parseProperty();
    }
}

