/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.jgss.i18n.PropertyResource;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbCryptoException;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.Krb5;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.crypto.e;
import com.ibm.security.krb5.internal.crypto.s;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class Checksum {
    private int a;
    private byte[] b;
    public static final int CKSUMTYPE_NULL = 0;
    public static final int CKSUMTYPE_CRC32 = 1;
    public static final int CKSUMTYPE_RSA_MD4 = 2;
    public static final int CKSUMTYPE_RSA_MD4_DES = 3;
    public static final int CKSUMTYPE_DES_MAC = 4;
    public static final int CKSUMTYPE_DES_MAC_K = 5;
    public static final int CKSUMTYPE_RSA_MD4_DES_K = 6;
    public static final int CKSUMTYPE_RSA_MD5 = 7;
    public static final int CKSUMTYPE_RSA_MD5_DES = 8;
    public static final int CKSUMTYPE_HMAC_SHA1_DES3 = 12;
    public static final int CKSUMTYPE_HMAC_SHA1_DES3_KD = 12;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES128 = 15;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES256 = 16;
    public static final int CKSUMTYPE_HMAC_MD5_ARCFOUR = -138;
    public static int CKSUMTYPE_DEFAULT;
    public static int SAFECKSUMTYPE_DEFAULT;
    private static final int[] c;
    private static final String[] z;

    public static void initStatic() {
        block17: {
            Config config;
            String string;
            block15: {
                string = null;
                config = null;
                try {
                    block14: {
                        config = Config.getInstance();
                        string = config.get(z[5], z[0]);
                        if (string == null) break block14;
                        CKSUMTYPE_DEFAULT = Config.getType(string);
                        break block15;
                    }
                    CKSUMTYPE_DEFAULT = -1;
                }
                catch (Exception exception) {
                    if (Krb5.DEBUG) {
                        System.out.println(z[6] + Thread.currentThread().getName() + z[4]);
                        exception.printStackTrace();
                    }
                    CKSUMTYPE_DEFAULT = -1;
                }
            }
            try {
                block16: {
                    string = config.get(z[1], z[7]);
                    if (string == null) break block16;
                    SAFECKSUMTYPE_DEFAULT = Config.getType(string);
                    break block17;
                }
                SAFECKSUMTYPE_DEFAULT = -1;
            }
            catch (Exception exception) {
                if (Krb5.DEBUG) {
                    System.out.println(z[2] + Thread.currentThread().getName() + z[3]);
                    exception.printStackTrace();
                }
                SAFECKSUMTYPE_DEFAULT = -1;
            }
        }
    }

    public Checksum(byte[] byArray, int n2) {
        this.a = n2;
        this.b = byArray;
    }

    public boolean verifyAnyChecksum(byte[] byArray, EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbCryptoException {
        return e.a(this.a).a(byArray, byArray.length, encryptionKey.getBytes(), this.b, n2);
    }

    public Checksum(int n2, byte[] byArray, EncryptionKey encryptionKey, int n3) throws KdcErrException, KrbApErrException, KrbCryptoException {
        this.a = n2 == -1 ? s.a(encryptionKey.getEType()).checksumType() : n2;
        this.b = e.a(this.a).a(byArray, byArray.length, encryptionKey.getBytes(), n3);
    }

    public boolean verifyKeyedChecksum(byte[] byArray, EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbApErrException, KrbCryptoException {
        e e2 = e.a(this.a);
        if (!e2.c()) {
            throw new KrbApErrException(50);
        }
        return e2.a(byArray, byArray.length, encryptionKey.getBytes(), this.b, n2);
    }

    boolean a(Checksum checksum) throws KdcErrException {
        if (this.a != checksum.a) {
            return false;
        }
        return e.a(this.b, checksum.b);
    }

    public Checksum(DerValue derValue) throws Asn1Exception, IOException {
        block11: {
            block10: {
                DerValue derValue2;
                block9: {
                    block8: {
                        if (derValue.getTag() != 48) {
                            throw new Asn1Exception(906);
                        }
                        derValue2 = derValue.getData().getDerValue();
                        if ((derValue2.getTag() & 0x1F) != 0) break block8;
                        this.a = derValue2.getData().getBigInteger().intValue();
                        break block9;
                    }
                    throw new Asn1Exception(906);
                }
                derValue2 = derValue.getData().getDerValue();
                if ((derValue2.getTag() & 0x1F) != 1) break block10;
                this.b = derValue2.getData().getOctetString();
                break block11;
            }
            throw new Asn1Exception(906);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.a));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.b);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Checksum parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new Checksum(derValue2);
    }

    public final byte[] getBytes() {
        return this.b;
    }

    public final int getType() {
        return this.a;
    }

    public static boolean isSupportedType(int n2) {
        return Arrays.binarySearch(c, n2) >= 0;
    }

    public static boolean isValidType(int n2) {
        return Checksum.isSupportedType(n2);
    }

    public boolean isCollisionProofType() {
        return Checksum.isCollisionProofType(this.a);
    }

    public static boolean isCollisionProofType(int n2) {
        return n2 == 4 || n2 == 5 || n2 == 7 || n2 == 8 || n2 == 12 || n2 == 15 || n2 == 16 || n2 == -138;
    }

    public static int[] getSupportedTypes() {
        return c;
    }

    public boolean isSafeType() {
        return Checksum.isSafeType(this.a);
    }

    public static boolean isSafeType(int n2) {
        return n2 == 4 || n2 == 5 || n2 == 8 || n2 == 12 || n2 == 15 || n2 == 16 || n2 == -138;
    }

    public static int stringToChecksumType(String string) throws Exception {
        if (string == null) {
            I18NException.throwException(z[8]);
        }
        if (string.equalsIgnoreCase(z[10])) {
            return 12;
        }
        if (string.equalsIgnoreCase(z[11])) {
            return 8;
        }
        if (string.equalsIgnoreCase(z[9])) {
            return 7;
        }
        if (string.equalsIgnoreCase(z[13])) {
            return -138;
        }
        if (string.equalsIgnoreCase(z[14])) {
            return 4;
        }
        if (string.equalsIgnoreCase(z[16])) {
            return 5;
        }
        if (string.equalsIgnoreCase(z[12])) {
            return 15;
        }
        if (string.equalsIgnoreCase(z[15])) {
            return 16;
        }
        if (string.equalsIgnoreCase(z[18])) {
            return 1;
        }
        I18NException.throwException(z[17], new String[]{string});
        return -999;
    }

    public static String checksumTypeToString(int n2) {
        switch (n2) {
            case 12: {
                return z[26];
            }
            case 8: {
                return z[20];
            }
            case 7: {
                return z[19];
            }
            case -138: {
                return z[24];
            }
            case 4: {
                return z[22];
            }
            case 5: {
                return z[21];
            }
            case 15: {
                return z[27];
            }
            case 16: {
                return z[25];
            }
            case 1: {
                return z[23];
            }
        }
        PropertyResource propertyResource = PropertyResource.getExceptionInstance();
        return propertyResource.getFormattedString(z[28], new Integer[]{new Integer(n2)});
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[29];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "nOr.\u0012f^K,\u000foI\u007f<\u0012g";
        int n3 = -1;
        block36: while (true) {
            char[] cArray;
            block41: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block40: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block40;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block41;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 10;
                                break;
                            }
                            case 1: {
                                n9 = 42;
                                break;
                            }
                            case 2: {
                                n9 = 20;
                                break;
                            }
                            case 3: {
                                n9 = 79;
                                break;
                            }
                            default: {
                                n9 = 103;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "fCv+\u0002lKa#\u0013y";
                    n3 = 0;
                    continue block36;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "IBq,\fy_yu";
                    n3 = 1;
                    continue block36;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "0\nQ7\u0004oZ`&\bd\n}!GmO`;\u000edM4<\u0006lO4+\u0002lKa#\u0013*I|*\u0004aYa\"G|Kx:\u0002*Lf \n*^|*GiEz)\u000em_f.\u0013cEzo4o^`&\tm\n4\u0001\b*Yu)\u0002*Nq)\u0006\u007fF`o\u0004bOw$\u0014\u007fG4<\u0002~\u0004";
                    n3 = 2;
                    continue block36;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "0\nQ7\u0004oZ`&\bd\n}!GmO`;\u000edM4+\u0002lKa#\u0013*I|*\u0004aYa\"G|Kx:\u0002*Lf \n*^|*GiEz)\u000em_f.\u0013cEzo)e\np*\u0001k_x;GiBq,\fy_yo\u0014o^:";
                    n3 = 3;
                    continue block36;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "fCv+\u0002lKa#\u0013y";
                    n3 = 4;
                    continue block36;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "IBq,\fy_yu";
                    n3 = 5;
                    continue block36;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "yKr*8iBq,\fy_y\u0010\u0013sZq";
                    n3 = 6;
                    continue block36;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "D_x#$aYa\"3sZq\u001c\u0013xCz(";
                    n3 = 7;
                    continue block36;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "xYub\nn\u001f";
                    n3 = 8;
                    continue block36;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "bGu,JyBu~JnOg|";
                    n3 = 9;
                    continue block36;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "xYub\nn\u001f9+\u0002y";
                    n3 = 10;
                    continue block36;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "bGu,JyBu~J3\u001c9.\u0002y\u001b&w";
                    n3 = 11;
                    continue block36;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "bGu,JgN!";
                    n3 = 12;
                    continue block36;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "nOgb\nkI";
                    n3 = 13;
                    continue block36;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "bGu,JyBu~J3\u001c9.\u0002y\u0018!y";
                    n3 = 14;
                    continue block36;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "nOgb\nkI9$";
                    n3 = 15;
                    continue block36;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "HKp\f\fy_y\u001b\u001ezOG;\u0015cDs";
                    n3 = 16;
                    continue block36;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "IxW|U";
                    n3 = 17;
                    continue block36;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "xYub\nn\u001f";
                    n3 = 18;
                    continue block36;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "xYub\nn\u001f9+\u0002y";
                    n3 = 19;
                    continue block36;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "nOgb\nkI9$";
                    n3 = 20;
                    continue block36;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "nOgb\nkI";
                    n3 = 21;
                    continue block36;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "iXw|U";
                    n3 = 22;
                    continue block36;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "bGu,JgN!";
                    n3 = 23;
                    continue block36;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "bGu,JyBu~J3\u001c9.\u0002y\u0018!y";
                    n3 = 24;
                    continue block36;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "bGu,JyBu~JnOg|";
                    n3 = 25;
                    continue block36;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "bGu,JyBu~J3\u001c9.\u0002y\u001b&w";
                    n3 = 26;
                    continue block36;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "HKp\f\fy_y\u001b\u001ezO";
                    n3 = 27;
                    continue block36;
                }
                case 27: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        c = new int[]{7, 8, 4, 5, 1, -138, 12, 15, 16};
        Checksum.initStatic();
    }
}

