/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.DatabaseHashGenerator;
import com.ibm.security.cmskeystore.DatabaseHashGeneratorFactory$1;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKey;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.sequence.Sequence;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.PBEKeySpec;

final class DatabaseHashGeneratorFactory$DatabaseHashGeneratorV6Impl
implements DatabaseHashGenerator {
    private DatabaseHashGeneratorFactory$DatabaseHashGeneratorV6Impl() {
    }

    public ByteSequence generateHash(KeyDatabase keyDatabase, String string) throws NullPointerException, NoSuchAlgorithmException, IOException {
        if (keyDatabase == null || string == null) {
            throw new NullPointerException();
        }
        FileHeader fileHeader = keyDatabase.getHeader();
        Sequence sequence = keyDatabase.getRecords();
        Mac mac = Mac.getInstance("HmacSHA384");
        try {
            mac.init(new NonPrintableAsciiPBEKey(new PBEKeySpec(string.toCharArray())));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        ByteSequenceIterator byteSequenceIterator = fileHeader.getMagicNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMajorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMinorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordExpirationTime().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileType().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFixedRecordLength().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getRecordsAllocated().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileLabel().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordHeaderHash().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        for (Record record : sequence) {
            byteSequenceIterator = record.getIterator();
            while (byteSequenceIterator.hasNextByte()) {
                mac.update(byteSequenceIterator.getNextByte());
            }
        }
        ByteSequence byteSequence = ByteSequenceFactory.newByteSequence(mac.doFinal());
        return byteSequence;
    }

    DatabaseHashGeneratorFactory$DatabaseHashGeneratorV6Impl(DatabaseHashGeneratorFactory$1 databaseHashGeneratorFactory$1) {
        this();
    }
}

