/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.parser;

import com.ibm.xylem.AbstractTypeStore;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.Functor;
import com.ibm.xylem.FunctorApplicationDirective;
import com.ibm.xylem.ITypeStore;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.Program;
import com.ibm.xylem.TopLevelModuleImportDirective;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.TupleInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.parser.CoreFormHandler;
import com.ibm.xylem.parser.CoreTypeHandler;
import com.ibm.xylem.parser.IFormHandler;
import com.ibm.xylem.parser.ITypeHandler;
import com.ibm.xylem.parser.ParserException;
import com.ibm.xylem.parser.ParserSource;
import com.ibm.xylem.parser.SourceResolver;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.ConstructorDataType;
import com.ibm.xylem.types.JavaArrayType;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.LazyStreamType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.NullableType;
import com.ibm.xylem.types.PromiseType;
import com.ibm.xylem.types.SlotType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TagType;
import com.ibm.xylem.types.TupleType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.types.UnionType;
import com.ibm.xylem.types.VirtualDataTypeMap;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class Parser {
    protected HashMap m_formHandlers = new HashMap();
    protected HashMap m_typeHandlers = new HashMap();
    protected URL m_baseURL = null;
    protected ArrayList m_typeFixups = new ArrayList();
    protected ArrayList m_parsedLibrary = new ArrayList();
    protected ModuleSignatureStore m_knownModuleSignatures;
    protected HashMap m_typeVariables;
    protected HashMap m_importedJavaStaticMethods = new HashMap();
    protected ParserSource m_currentSource;
    protected ArrayList m_sourceStack = new ArrayList();
    protected SourceResolver m_sourceResolver;
    protected static final boolean REQUIRED = true;
    static final String s_hextable = "0123456789abcdef";

    public Parser(SourceResolver sourceResolver, ParserSource parserSource) {
        this(sourceResolver, parserSource, new ModuleSignatureStore(new LinkedList()));
    }

    public Parser(SourceResolver sourceResolver, ParserSource parserSource, ModuleSignatureStore moduleSignatureStore) {
        this.m_knownModuleSignatures = moduleSignatureStore;
        new CoreFormHandler().registerForms(this);
        new CoreTypeHandler().registerTypes(this);
        this.m_currentSource = parserSource;
        this.m_sourceResolver = sourceResolver;
        this.m_baseURL = parserSource.m_currentURL;
    }

    public void registerForm(String string, IFormHandler iFormHandler) {
        this.m_formHandlers.put(string, iFormHandler);
    }

    public void registerModuleSignature(String string, ModuleSignature moduleSignature) {
        this.m_knownModuleSignatures.registerModuleSignature(string, moduleSignature);
    }

    public void registerType(String string, ITypeHandler iTypeHandler) {
        this.m_typeHandlers.put(string, iTypeHandler);
    }

    protected void unread(char c) throws ParserException {
        this.m_currentSource.unread(c);
    }

    protected char read() throws ParserException {
        char c = this.m_currentSource.read();
        return c;
    }

    public char readStripComments() throws ParserException {
        char c = this.read();
        if (c == ';') {
            while ((c = this.read()) != '\n') {
            }
        }
        return c;
    }

    public int getOffsetInLine() {
        return this.m_currentSource.m_offset;
    }

    public int getLineNumber() {
        return this.m_currentSource.m_lineNumber;
    }

    public URL getCurrentURL() {
        return this.m_currentSource.m_currentURL;
    }

    public void parseOpenParen() throws ParserException {
        char c;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        if (c != '(') {
            throw new ParserException("Expected ( but found " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
    }

    public boolean parseOpenParenOrEnd() throws ParserException {
        char c;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        if (c != '(') {
            if (c == ')') {
                return false;
            }
            throw new ParserException("Expected ( or ) but found " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        return true;
    }

    public String parseFormProlog() throws ParserException {
        this.parseOpenParen();
        return this.parseIdentifier(true);
    }

    public String parseFormPrologOrEnd() throws ParserException {
        if (!this.parseOpenParenOrEnd()) {
            return null;
        }
        return this.parseIdentifier(true);
    }

    public void parseCloseParen() throws ParserException {
        char c;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        if (c != ')') {
            throw new ParserException("Expected ) but found " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
    }

    public Instruction parseForm(ITypeStore iTypeStore) throws ParserException {
        return this.parseForm(this.parseFormProlog(), iTypeStore);
    }

    public Instruction parseForm(String string, ITypeStore iTypeStore) throws ParserException {
        Instruction instruction;
        IFormHandler iFormHandler = (IFormHandler)this.m_formHandlers.get(string);
        if (iFormHandler == null) {
            StaticMethodSpec staticMethodSpec = (StaticMethodSpec)this.m_importedJavaStaticMethods.get(string);
            if (staticMethodSpec != null) {
                instruction = new StaticMethodInvocationInstruction(staticMethodSpec.m_class, staticMethodSpec.m_methodName, this.parseRemainingExpressions(iTypeStore), staticMethodSpec.m_returnType);
                if (instruction.getChildInstructionCount() != staticMethodSpec.m_parameterTypes.length) {
                    throw new ParserException("Invalid number of parameters to static Java method", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
            } else {
                instruction = new FunctionCallInstruction(string, this.parseRemainingExpressions(iTypeStore));
            }
        } else {
            instruction = iFormHandler.parseForm(string, this, iTypeStore);
        }
        if (this.getCurrentURL() != null) {
            instruction.setSourceFilename(this.getCurrentURL());
        }
        instruction.setSourceLineNumber(this.getLineNumber());
        return instruction;
    }

    public String parseIdentifier() throws ParserException {
        return this.parseIdentifier(true);
    }

    public String parseIdentifier(boolean bl) throws ParserException {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c;
            if (Character.isWhitespace(c = this.readStripComments()) || c == '@') {
                String string2 = stringBuffer.toString();
                if (string2.length() == 0) {
                    if (c != '@') continue;
                    string = "@";
                    break;
                }
                if (c == '@') {
                    this.unread('@');
                }
                string = string2;
                break;
            }
            if (c == ')' || c == '(') {
                this.unread(c);
                if (stringBuffer.length() == 0) {
                    if (bl) {
                        throw new ParserException("Unexpected \"" + c + "\"", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    string = null;
                    break;
                }
                string = stringBuffer.toString();
                break;
            }
            stringBuffer.append(c);
        }
        return string;
    }

    protected Type[] parseRemainingTypes(ITypeStore iTypeStore) throws ParserException {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while (true) {
            Type type;
            if ((type = this.parseTypeName(iTypeStore, false)) == null) {
                Type[] typeArray = new Type[arrayList.size()];
                arrayList.toArray(typeArray);
                return typeArray;
            }
            arrayList.add(type);
        }
    }

    protected Type[] parseUnionType(ITypeStore iTypeStore, boolean bl) throws ParserException {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while (true) {
            Type type;
            if ((type = this.parseUnionTypeName(iTypeStore, true)) == null) {
                Type[] typeArray = new Type[arrayList.size()];
                arrayList.toArray(typeArray);
                return typeArray;
            }
            arrayList.add(type);
        }
    }

    protected Type parseUnionTypeName(ITypeStore iTypeStore, boolean bl) throws ParserException {
        String string;
        char c;
        while (Character.isSpaceChar(c = this.readStripComments()) || c == '\n' || c == '\r' || c == '\t') {
        }
        if (c == ')') {
            return null;
        }
        if (c != '(') {
            this.unread(c);
        }
        if ((string = this.parseIdentifier(bl)) == null) {
            return null;
        }
        return this._parseTypeName(iTypeStore, string);
    }

    public Type parseTypeName(ITypeStore iTypeStore) throws ParserException {
        return this.parseTypeName(iTypeStore, true);
    }

    public Type parseTypeName(ITypeStore iTypeStore, boolean bl) throws ParserException {
        char c;
        while (Character.isSpaceChar(c = this.readStripComments()) || c == '\n' || c == '\r' || c == '\t') {
        }
        if (c == '(') {
            Type type;
            String string = this.parseIdentifier(true);
            if (string.equals("slot")) {
                type = new SlotType(this.parseTypeName(iTypeStore));
            } else if (string.equals("promise")) {
                type = new PromiseType(this.parseTypeName(iTypeStore));
            } else if (string.equals("tag")) {
                type = new TagType(this.parseIdentifier(), this.parseTypeName(iTypeStore));
            } else if (string.equals("nullable")) {
                type = new NullableType(this.parseTypeName(iTypeStore));
            } else if (string.equals("lazy-stream")) {
                type = new LazyStreamType(this.parseTypeName(iTypeStore));
            } else if (string.equals("->")) {
                this.parseOpenParen();
                Type[] typeArray = this.parseRemainingTypes(iTypeStore);
                this.parseCloseParen();
                type = new LambdaType(typeArray, this.parseTypeName(iTypeStore), true);
            } else if (string.equals("!->")) {
                this.parseOpenParen();
                Type[] typeArray = this.parseRemainingTypes(iTypeStore);
                this.parseCloseParen();
                type = new LambdaType(typeArray, this.parseTypeName(iTypeStore), false);
            } else if (string.equals("tuple")) {
                type = new TupleType(this.parseRemainingTypes(iTypeStore));
            } else if (string.equals("union")) {
                type = new UnionType(this.parseUnionType(iTypeStore, true));
            } else if (string.equals("java-array")) {
                type = this.parseTypeName(iTypeStore);
                int n = this.parseInteger();
                type = new JavaArrayType(type, n);
            } else if (string.equals("java")) {
                type = new JavaObjectType(this.parseIdentifier());
            } else {
                Type[] typeArray = this.parseRemainingTypes(iTypeStore);
                type = new NamedType(string, iTypeStore.getName(), typeArray);
            }
            this.parseCloseParen();
            c = this.readStripComments();
            if (c == '[') {
                c = this.readStripComments();
                if (c == ']') {
                    return new StreamType(type);
                }
                this.unread(c);
            } else {
                this.unread(c);
            }
            return type;
        }
        this.unread(c);
        String string = this.parseIdentifier(bl);
        if (string == null) {
            return null;
        }
        return this._parseTypeName(iTypeStore, string);
    }

    public Instruction[] parseRemainingExpressions(ITypeStore iTypeStore) throws ParserException {
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        while (true) {
            Instruction instruction;
            if ((instruction = this.parseExpression(iTypeStore, false)) == null) {
                Instruction[] instructionArray = new Instruction[arrayList.size()];
                arrayList.toArray(instructionArray);
                return instructionArray;
            }
            arrayList.add(instruction);
        }
    }

    public Object[] parseRemainingIdentifiers() throws ParserException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string;
        while ((string = this.parseIdentifier(false)) != null) {
            arrayList.add(string);
        }
        return arrayList.toArray();
    }

    public Type _parseTypeName(ITypeStore iTypeStore, String string) throws ParserException {
        Type type;
        boolean bl = false;
        if (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            bl = true;
        }
        if (string.startsWith("?")) {
            if (this.m_typeVariables == null) {
                throw new ParserException("Type variables not allowed here", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            type = (Type)this.m_typeVariables.get(string.substring(1));
            if (type == null) {
                type = new TypeVariable();
                this.m_typeVariables.put(string.substring(1), type);
            }
        } else {
            ITypeHandler iTypeHandler = (ITypeHandler)this.m_typeHandlers.get(string);
            if (iTypeHandler == null) {
                type = iTypeStore.lookupTypeAlias(string);
                if (type == null) {
                    type = new NamedType(string);
                }
            } else {
                type = iTypeHandler.parseType(string, this);
            }
            if (type == null) {
                throw new ParserException("Unknown type name: " + string, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        }
        return bl ? new StreamType(type) : type;
    }

    public Instruction parseExpression(ITypeStore iTypeStore) throws ParserException {
        return this.parseExpression(iTypeStore, true);
    }

    public Instruction parseExpression(ITypeStore iTypeStore, boolean bl) throws ParserException {
        char c;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        if (c == '(') {
            this.unread(c);
            return this.parseForm(iTypeStore);
        }
        if (c == ')') {
            if (bl) {
                throw new ParserException("Unexpected ')'", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            return null;
        }
        if (c == '\"') {
            return StreamInstruction.charStreamLiteral(this.parseStringLiteral());
        }
        if (c == '\'') {
            char c2 = this.read();
            if (c2 == '\\') {
                c2 = this.resolveEscapeSequence();
            }
            if (this.read() != '\'') {
                throw new ParserException("Malformed character literal", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            return LiteralInstruction.charLiteral(c2);
        }
        if (Character.isDigit(c) || c == '-' || c == '.') {
            this.unread(c);
            return this.parseNumber();
        }
        this.unread(c);
        Object object = this.parseName(bl);
        if (!bl && object == null) {
            return null;
        }
        if (object.equals("true")) {
            return LiteralInstruction.booleanTrueLiteral();
        }
        if (object.equals("false")) {
            return LiteralInstruction.booleanFalseLiteral();
        }
        if (object.equals("unit")) {
            return LiteralInstruction.unitLiteral();
        }
        if (object.equals("floatNaN")) {
            return LiteralInstruction.floatLiteral(Float.NaN);
        }
        if (object.equals("floatPosINF")) {
            return LiteralInstruction.floatLiteral(Float.POSITIVE_INFINITY);
        }
        if (object.equals("floatNegINF")) {
            return LiteralInstruction.floatLiteral(Float.NEGATIVE_INFINITY);
        }
        if (object.equals("doubleNaN")) {
            return LiteralInstruction.doubleLiteral(Double.NaN);
        }
        if (object.equals("doublePosINF")) {
            return LiteralInstruction.doubleLiteral(Double.POSITIVE_INFINITY);
        }
        if (object.equals("doubleNegINF")) {
            return LiteralInstruction.doubleLiteral(Double.NEGATIVE_INFINITY);
        }
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(object);
        if (this.getCurrentURL() != null) {
            identifierInstruction.setSourceFilename(this.getCurrentURL());
        }
        identifierInstruction.setSourceLineNumber(this.getLineNumber());
        return identifierInstruction;
    }

    long hex2long(String string) {
        int n = string.length();
        String string2 = string.toLowerCase();
        if (!string2.startsWith("0x")) {
            throw new NumberFormatException("Expected long hex value, saw: " + string);
        }
        if (n > 19) {
            throw new NumberFormatException("Too many digits in long hex value: " + string);
        }
        long l = 0L;
        for (int i = 2; i < n - 1; ++i) {
            int n2 = s_hextable.indexOf(string2.charAt(i));
            if (n2 < 0) {
                throw new NumberFormatException("Bad digit in long hex value: " + string);
            }
            l = l << 4 | (long)n2;
        }
        return l;
    }

    int hex2int(String string) {
        int n = string.length();
        String string2 = string.toLowerCase();
        if (!string2.startsWith("0x")) {
            throw new NumberFormatException("Expected hex value, saw: " + string);
        }
        if (n > 10) {
            throw new NumberFormatException("Too many digits in hex value: " + string);
        }
        int n2 = 0;
        for (int i = 2; i < n; ++i) {
            n2 = n2 << 4 | s_hextable.indexOf(string2.charAt(i)) - 1;
        }
        return n2;
    }

    public Instruction parseNumber() throws ParserException {
        String string = this.parseIdentifier(true);
        try {
            if (string.endsWith("f")) {
                return LiteralInstruction.floatLiteral(Float.parseFloat(string.substring(0, string.length() - 1)));
            }
            if (string.endsWith("d")) {
                return LiteralInstruction.doubleLiteral(Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            if (string.endsWith("l")) {
                return LiteralInstruction.longLiteral(string.startsWith("0x") | string.startsWith("0X") ? this.hex2long(string) : Long.parseLong(string.substring(0, string.length() - 1)));
            }
            if (string.indexOf(46) == -1) {
                return LiteralInstruction.integerLiteral(string.startsWith("0x") | string.startsWith("0X") ? this.hex2int(string) : Integer.parseInt(string));
            }
            return LiteralInstruction.doubleLiteral(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParserException("Could not parse number: " + string, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
    }

    public int parseInteger() throws ParserException {
        String string = this.parseIdentifier(true);
        return Integer.parseInt(string);
    }

    public Object parseName() throws ParserException {
        return this.parseName(true);
    }

    public Object parseName(boolean bl) throws ParserException {
        String string = this.parseIdentifier(bl);
        if (null != string && string.length() > 0 && string.charAt(0) == '#') {
            return new Integer(Integer.parseInt(string.substring(1)));
        }
        return string;
    }

    public final char resolveEscapeSequence() throws ParserException {
        char c = this.read();
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '\'': {
                return '\'';
            }
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case 'u': {
                char c2 = '\u0000';
                for (int i = 0; i < 4; ++i) {
                    char c3 = Character.toUpperCase(this.read());
                    if (c3 >= '0' && c3 <= '9') {
                        c2 = (char)((c2 << 4) + c3 - 48);
                        continue;
                    }
                    if (c3 >= 'A' && c3 <= 'F') {
                        c2 = (char)((c2 << 4) + 10 + c3 - 65);
                        continue;
                    }
                    throw new ParserException("A character that is not a hexadecimal digit was encountered in a Unicode escape sequence " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
                return c2;
            }
        }
        throw new ParserException("Unknown escape sequence \\" + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
    }

    public String parseStringLiteralFull() throws ParserException {
        char c = this.read();
        if (c == '\"') {
            return this.parseStringLiteral();
        }
        throw new ParserException("String Literal must begin with \", read: " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
    }

    public String parseStringLiteral() throws ParserException {
        StringBuffer stringBuffer = new StringBuffer();
        char c;
        while ((c = this.read()) != '\"') {
            if (c == '\\') {
                c = this.resolveEscapeSequence();
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public boolean parseBooleanLiteral() throws ParserException {
        String string = this.parseIdentifier(true);
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw new ParserException("Expected true or false; got " + string, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
    }

    protected void parseADT(ITypeStore iTypeStore) throws ParserException {
        AbstractDataType.Constructor[] constructorArray;
        String string = this.parseIdentifier(true);
        if (iTypeStore.lookupCompoundType(string) != null) {
            throw new ParserException("Duplicate type definition for " + string, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        ArrayList<AbstractDataType.Constructor> arrayList = new ArrayList<AbstractDataType.Constructor>();
        while ((constructorArray = this.parseFormPrologOrEnd()) != null) {
            Binding[] bindingArray;
            Object object;
            ArrayList<Binding[]> arrayList2 = new ArrayList<Binding[]>();
            while ((object = this.parseName(false)) != null) {
                bindingArray = new Binding(object);
                char c = this.readStripComments();
                if (c != '@') {
                    throw new ParserException("Abstract data type constructor parameters must have types");
                }
                bindingArray.setType(this.parseTypeName(iTypeStore));
                arrayList2.add(bindingArray);
            }
            this.parseCloseParen();
            bindingArray = new Binding[arrayList2.size()];
            arrayList2.toArray(bindingArray);
            arrayList.add(new AbstractDataType.Constructor((String)constructorArray, bindingArray));
        }
        constructorArray = new AbstractDataType.Constructor[arrayList.size()];
        arrayList.toArray(constructorArray);
        iTypeStore.addAbstractDataType(this.makeAbstractDataType(string, constructorArray));
    }

    protected AbstractDataType makeAbstractDataType(String string, AbstractDataType.Constructor[] constructorArray) {
        return new ConstructorDataType(string, constructorArray);
    }

    protected void parseTypeAlias(ITypeStore iTypeStore) throws ParserException {
        String string = this.parseIdentifier(true);
        Type type = this.parseTypeName(iTypeStore);
        if (type != null) {
            if (iTypeStore.lookupCompoundType(string) != null || iTypeStore.lookupTypeAlias(string) != null) {
                throw new ParserException("The new type name \"" + string + "\" specified in a type-alias was previously" + " defined.", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        } else {
            throw new ParserException("The existing type name specified in a type-alias is unknown.", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        iTypeStore.addTypeAlias(string, type);
        this.parseCloseParen();
    }

    protected void parseJavaStaticMethodImport(ITypeStore iTypeStore) throws ParserException {
        StaticMethodSpec staticMethodSpec = new StaticMethodSpec();
        staticMethodSpec.m_name = this.parseIdentifier(true);
        staticMethodSpec.m_class = this.parseIdentifier(true);
        staticMethodSpec.m_methodName = this.parseIdentifier(true);
        staticMethodSpec.m_returnType = this.parseTypeName(iTypeStore);
        staticMethodSpec.m_parameterTypes = this.parseRemainingTypes(iTypeStore);
        this.m_importedJavaStaticMethods.put(staticMethodSpec.m_name, staticMethodSpec);
    }

    protected void parseFunction(Module module) throws ParserException {
        Binding[] bindingArray;
        Object object;
        String string;
        Object object2;
        char c;
        this.m_typeVariables = new HashMap();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        this.unread(c);
        if (c != '(') {
            object2 = this.parseIdentifier();
            if (((String)object2).equals("memoize")) {
                bl = true;
            } else if (((String)object2).equals("impure")) {
                bl2 = true;
            } else if (((String)object2).equals("inline")) {
                bl3 = true;
            } else {
                throw new ParserException("Invalid function attribute " + (String)object2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        }
        if (module.getFunction(string = this.parseFormProlog()) != null) {
            object2 = module.getFunction(string);
            if (null == ((Function)object2).m_definitionURL && 0 == ((Function)object2).m_definitionLineNumber) {
                throw new ParserException("Duplicate function definition for " + string, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            throw new ParserException("Duplicate function definition for " + string + "\n" + "  First defined at " + ((Function)object2).m_definitionURL + " line " + ((Function)object2).m_definitionLineNumber, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        char c2 = this.readStripComments();
        Type type = null;
        if (c2 == '@') {
            type = this.parseTypeName(module);
        } else {
            this.unread(c2);
        }
        ArrayList<Binding[]> arrayList = new ArrayList<Binding[]>();
        while ((object = this.parseName(false)) != null) {
            bindingArray = new Binding(object);
            c2 = this.readStripComments();
            if (c2 != '@') {
                this.unread(c2);
            } else {
                bindingArray.setType(this.parseTypeName(module));
            }
            arrayList.add(bindingArray);
        }
        this.parseCloseParen();
        bindingArray = new Binding[arrayList.size()];
        arrayList.toArray(bindingArray);
        Instruction instruction = this.parseExpression(module);
        Function function = new Function(string, bindingArray, instruction, this.getCurrentURL(), this.getLineNumber());
        if (type != null) {
            function.setReturnType(type);
        }
        module.addFunction(function);
        if (bl) {
            function.setMemoizeResult(true);
        }
        if (bl2) {
            function.setImpurity(true);
        }
        if (bl3) {
            function.setInlineHint(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSignature parseExternalModuleSignature(ParserSource parserSource) throws ParserException {
        this.m_sourceStack.add(this.m_currentSource);
        try {
            this.m_currentSource = parserSource;
            if (!"module-signature".equals(this.parseFormProlog())) {
                throw new ParserException("Expected module-signature form at root level", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            ModuleSignature moduleSignature = this.parseModuleSignature();
            return moduleSignature;
        }
        finally {
            this.m_currentSource = (ParserSource)this.m_sourceStack.remove(this.m_sourceStack.size() - 1);
        }
    }

    protected ModuleSignature parseModuleSignature() throws ParserException {
        this.m_typeVariables = new HashMap();
        String string = this.parseIdentifier(true);
        if (this.m_knownModuleSignatures.lookupModuleSignature(string) != null) {
            throw new ParserException("Duplicate module signature definition for " + string, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        ModuleSignature moduleSignature = new ModuleSignature(string);
        while (true) {
            String string2;
            String string3;
            if ((string3 = this.parseFormPrologOrEnd()) == null) {
                this.m_knownModuleSignatures.registerModuleSignature(string, moduleSignature);
                return moduleSignature;
            }
            if (string3.equals("declare-function")) {
                Object object;
                string2 = this.parseIdentifier(true);
                if (!this.parseIdentifier(true).equals("@")) {
                    throw new ParserException("function signature must include return type", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
                Type type = this.parseTypeName(moduleSignature);
                ArrayList<Type> arrayList = new ArrayList<Type>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                while ((object = this.parseName(false)) != null) {
                    char c = this.readStripComments();
                    if (c != '@') {
                        throw new ParserException("parameters in function signature must include types", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    arrayList2.add(object);
                    arrayList.add(this.parseTypeName(moduleSignature));
                }
                Type[] typeArray = new Type[arrayList.size()];
                arrayList.toArray(typeArray);
                Object[] objectArray = new Object[arrayList2.size()];
                arrayList2.toArray(objectArray);
                moduleSignature.addFunctionSignature(new FunctionSignature(string2, objectArray, typeArray, type));
            } else if (string3.equals("declare-datatype")) {
                string2 = this.parseIdentifier(true);
            } else {
                if (string3.equals("define-datatype")) {
                    this.parseADT(moduleSignature);
                    continue;
                }
                if (string3.equals("type-alias")) {
                    this.parseTypeAlias(moduleSignature);
                    continue;
                }
                throw new ParserException("Unrecognized keyword: " + string3, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            this.parseCloseParen();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseLibrary(Module module, String string) throws ParserException {
        ParserSource parserSource = this.m_sourceResolver.resolve(this.m_currentSource, string);
        URL uRL = parserSource.m_currentURL;
        if (uRL == null) {
            throw new ParserException("An error occurred resolving library " + string);
        }
        if (this.m_parsedLibrary.contains(uRL)) {
            return;
        }
        this.m_parsedLibrary.add(uRL);
        this.m_sourceStack.add(this.m_currentSource);
        try {
            this.m_currentSource = parserSource;
            String string2 = this.parseFormProlog();
            if (!"library".equals(string2)) {
                throw new ParserException("Expected library form at root level of (" + string + "), found " + string2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            while (true) {
                String string3;
                String string4;
                if ((string4 = this.parseFormPrologOrEnd()) == null) {
                    return;
                }
                if (string4.equals("import-library")) {
                    string3 = this.parseIdentifier(true);
                    this.parseLibrary(module, string3);
                } else if (string4.equals("import-java-static-method")) {
                    this.parseJavaStaticMethodImport(module);
                } else if (string4.equals("declare-datatype")) {
                    string3 = this.parseIdentifier(true);
                } else if (string4.equals("function")) {
                    this.parseFunction(module);
                } else {
                    if (string4.equals("vdtmap")) {
                        this.parseVDTMap(module);
                        continue;
                    }
                    if (string4.equals("define-datatype")) {
                        this.parseADT(module);
                        continue;
                    }
                    if (!string4.equals("type-alias")) throw new ParserException("Unexpected form " + string4 + " in library form", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    this.parseTypeAlias(module);
                    continue;
                }
                this.parseCloseParen();
                continue;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ParserException("I/O error", exception);
        }
        finally {
            this.m_currentSource = (ParserSource)this.m_sourceStack.remove(this.m_sourceStack.size() - 1);
        }
    }

    public VirtualDataTypeMap parseVDTMap() throws ParserException {
        String string;
        AbstractTypeStore abstractTypeStore = new AbstractTypeStore();
        VirtualDataTypeMap virtualDataTypeMap = new VirtualDataTypeMap();
        if (!this.parseFormProlog().equals("vdtmap")) {
            throw new ParserException("Virtual data type maps must start with vdtmap", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        while ((string = this.parseFormPrologOrEnd()) != null) {
            if (!string.equals("map-datatype")) {
                throw new ParserException("Virtual data type maps can only contain map-datatype directives", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            String string2 = this.parseIdentifier();
            if (virtualDataTypeMap.hasVDTMapping(string2)) {
                throw new ParserException("map-datatype already supplied for " + string2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            Type type = this.parseTypeName(abstractTypeStore);
            VirtualDataTypeMap.ADTMapping aDTMapping = new VirtualDataTypeMap.ADTMapping();
            virtualDataTypeMap.addVDTMapping(string2, aDTMapping);
            aDTMapping.m_targetType = type;
            while ((string = this.parseFormPrologOrEnd()) != null) {
                if (string.equals("map-match")) {
                    if (aDTMapping.m_matchCode != null) {
                        throw new ParserException("map-match already supplied", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    aDTMapping.m_matchVariable = new Binding(this.parseName());
                    aDTMapping.m_matchCode = this.parseExpression(abstractTypeStore);
                    this.parseCloseParen();
                    continue;
                }
                if (string.equals("map-constructor")) {
                    String string3 = this.parseIdentifier();
                    VirtualDataTypeMap.ConstructorMapping constructorMapping = new VirtualDataTypeMap.ConstructorMapping();
                    if (aDTMapping.m_constructors.containsKey(string3)) {
                        throw new ParserException("map-constructor already supplied for " + string3, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    while ((string = this.parseFormPrologOrEnd()) != null) {
                        if (string.equals("construct")) {
                            if (constructorMapping.m_constructCode != null) {
                                throw new ParserException("construct already supplied", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                            }
                            this.parseOpenParen();
                            constructorMapping.m_constructParameters = Binding.getBindings(this.parseRemainingIdentifiers());
                            this.parseCloseParen();
                            constructorMapping.m_constructCode = this.parseExpression(abstractTypeStore);
                            this.parseCloseParen();
                            continue;
                        }
                        if (string.equals("deconstruct")) {
                            if (constructorMapping.m_deconstructVariable != null) {
                                throw new ParserException("deconstruct already supplied");
                            }
                            constructorMapping.m_deconstructVariable = new Binding(this.parseName());
                            continue;
                        }
                        throw new ParserException("Unrecognized form: " + string);
                    }
                    aDTMapping.m_constructors.put(string3, constructorMapping);
                    continue;
                }
                throw new ParserException("Unrecognized form: " + string, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        }
        return virtualDataTypeMap;
    }

    protected void parseVDTMap(Module module) throws ParserException {
        String string;
        while ((string = this.parseFormPrologOrEnd()) != null) {
            if (!string.equals("map-datatype")) {
                throw new ParserException("Virtual data type maps can only contain map-datatype directives");
            }
            String string2 = this.parseIdentifier();
            if (module.getVDTMap().hasVDTMapping(string2)) {
                throw new ParserException("map-datatype already supplied for " + string2);
            }
            Type type = this.parseTypeName(module);
            VirtualDataTypeMap.ADTMapping aDTMapping = new VirtualDataTypeMap.ADTMapping();
            module.getVDTMap().addVDTMapping(string2, aDTMapping);
            aDTMapping.m_targetType = type;
            while ((string = this.parseFormPrologOrEnd()) != null) {
                Object object;
                Object object2;
                if (string.equals("map-match")) {
                    if (aDTMapping.m_matchCode != null) {
                        throw new ParserException("map-match already supplied");
                    }
                    aDTMapping.m_matchVariable = new Binding(this.parseName());
                    object2 = new TupleInstruction(new Instruction[]{this.parseExpression(module)});
                    object = new Function(OptimizerUtilities.generateIntermediateIdentifier(), new Binding[]{new Binding(aDTMapping.m_matchVariable)}, (Instruction)object2);
                    try {
                        ((Function)object).typeCheck(module, null, new LinkedList());
                    }
                    catch (TypeCheckException typeCheckException) {
                        throw new ParserException("match code in " + string2 + " vdtmapping does not typecheck!", typeCheckException);
                    }
                    ((Function)object).reduce();
                    aDTMapping.m_matchCode = ((Function)object).getBody();
                    this.parseCloseParen();
                    continue;
                }
                if (string.equals("map-constructor")) {
                    object2 = this.parseIdentifier();
                    object = new VirtualDataTypeMap.ConstructorMapping();
                    if (aDTMapping.m_constructors.containsKey(object2)) {
                        throw new ParserException("map-constructor already supplied for " + (String)object2);
                    }
                    while ((string = this.parseFormPrologOrEnd()) != null) {
                        Object object3;
                        Instruction instruction;
                        if (string.equals("construct")) {
                            if (((VirtualDataTypeMap.ConstructorMapping)object).m_constructCode != null) {
                                throw new ParserException("construct already supplied");
                            }
                            this.parseOpenParen();
                            ((VirtualDataTypeMap.ConstructorMapping)object).m_constructParameters = Binding.getBindings(this.parseRemainingIdentifiers());
                            this.parseCloseParen();
                            instruction = this.parseExpression(module);
                            object3 = new Binding[((VirtualDataTypeMap.ConstructorMapping)object).m_constructParameters.length];
                            for (int i = 0; i < ((VirtualDataTypeMap.ConstructorMapping)object).m_constructParameters.length; ++i) {
                                object3[i] = new Binding(((VirtualDataTypeMap.ConstructorMapping)object).m_constructParameters[i]);
                            }
                            Function function = new Function(OptimizerUtilities.generateIntermediateIdentifier(), (Binding[])object3, instruction);
                            try {
                                function.typeCheck(module, null, new LinkedList());
                            }
                            catch (TypeCheckException typeCheckException) {
                                throw new ParserException("construct code in " + string2 + " vdtmapping does not typecheck!", typeCheckException);
                            }
                            function.reduce();
                            ((VirtualDataTypeMap.ConstructorMapping)object).m_constructCode = function.getBody();
                            this.parseCloseParen();
                            continue;
                        }
                        if (string.equals("deconstruct")) {
                            if (((VirtualDataTypeMap.ConstructorMapping)object).m_deconstructVariable != null) {
                                throw new ParserException("deconstruct already supplied");
                            }
                            ((VirtualDataTypeMap.ConstructorMapping)object).m_deconstructVariable = new Binding(this.parseName());
                            instruction = new TupleInstruction(this.parseRemainingExpressions(module));
                            object3 = new Function(OptimizerUtilities.generateIntermediateIdentifier(), new Binding[]{new Binding((Object)((VirtualDataTypeMap.ConstructorMapping)object).m_deconstructVariable, aDTMapping.m_targetType, new TypeEnvironment(module))}, instruction);
                            try {
                                ((Function)object3).typeCheck(module, null, new LinkedList());
                            }
                            catch (TypeCheckException typeCheckException) {
                                typeCheckException.printStackTrace();
                                throw new ParserException("deconstruct code in " + string2 + " vdtmapping does not typecheck!", typeCheckException);
                            }
                            ((Function)object3).reduce();
                            ((VirtualDataTypeMap.ConstructorMapping)object).m_deconstructCode = ((Function)object3).getBody();
                            continue;
                        }
                        throw new ParserException("Unrecognized form: " + string);
                    }
                    aDTMapping.m_constructors.put(object2, object);
                    continue;
                }
                throw new ParserException("Unrecognized form: " + string);
            }
        }
    }

    protected void parseModule(Module module, boolean bl) throws ParserException {
        String string;
        while ((string = this.parseFormPrologOrEnd()) != null) {
            Object[] objectArray;
            Object object;
            ModuleSignature moduleSignature;
            Object object2;
            String string2;
            if (string.equals("main")) {
                this.m_typeVariables = new HashMap();
                module.addFunction(new Function("main", new Binding[0], this.parseExpression(module), this.getCurrentURL(), this.getLineNumber()));
                this.parseCloseParen();
                break;
            }
            if (string.equals("import-library")) {
                string2 = this.parseIdentifier(true);
                this.parseLibrary(module, string2);
            } else if (string.equals("import-module")) {
                string2 = this.parseIdentifier(true);
                object2 = this.resolveModuleSignature(string2);
                module.addModuleImportDirective(new TopLevelModuleImportDirective(string2, (ModuleSignature)object2, string2));
            } else if (string.equals("apply-functor")) {
                string2 = this.parseIdentifier(true);
                if (!this.parseIdentifier(true).equals("@")) {
                    throw new ParserException("apply-functor must have signature specified", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
                object2 = this.parseIdentifier(true);
                moduleSignature = this.resolveModuleSignature((String)object2);
                object = this.parseIdentifier(true);
                objectArray = this.parseRemainingIdentifiers();
                module.addModuleImportDirective(new FunctorApplicationDirective(string2, moduleSignature, (String)object, objectArray));
            } else if (string.equals("import-java-static-method")) {
                this.parseJavaStaticMethodImport(module);
            } else if (string.equals("declare-datatype")) {
                string2 = this.parseIdentifier(true);
            } else if (string.equals("function")) {
                this.parseFunction(module);
            } else {
                if (string.equals("vdtmap")) {
                    this.parseVDTMap(module);
                    continue;
                }
                if (string.equals("module")) {
                    string2 = this.parseIdentifier(true);
                    if (!this.parseIdentifier(true).equals("@")) {
                        throw new ParserException("module must have signature specified", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    object2 = this.parseIdentifier(true);
                    moduleSignature = this.resolveModuleSignature((String)object2);
                    object = new Module(string2, module, moduleSignature);
                    this.parseModule((Module)object, false);
                    module.addModule((Module)object);
                    continue;
                }
                if (string.equals("functor")) {
                    Serializable serializable;
                    string2 = this.parseFormProlog();
                    if (!this.parseIdentifier(true).equals("@")) {
                        throw new ParserException("functor must have signature specified", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    object2 = this.parseIdentifier(true);
                    moduleSignature = this.resolveModuleSignature((String)object2);
                    object = this.parseRemainingIdentifiers();
                    this.parseCloseParen();
                    objectArray = new ModuleSignature[((Object[])object).length / 3];
                    Object[] objectArray2 = new Object[((Object[])object).length / 3];
                    for (int i = 0; i < ((Object[])object).length; i += 3) {
                        if (!object[i + 1].equals("@")) {
                            throw new ParserException("parameters to functor must include types", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                        }
                        serializable = this.resolveModuleSignature(object[i + 2].toString());
                        objectArray2[i / 3] = object[i];
                        objectArray[i / 3] = serializable;
                    }
                    Module module2 = new Module(string2, module, moduleSignature);
                    this.parseModule(module2, false);
                    serializable = new Functor(string2, module2, (ModuleSignature[])objectArray, (String[])objectArray2, moduleSignature);
                    module.addFunctor((Functor)serializable);
                    continue;
                }
                if (string.equals("define-datatype")) {
                    this.parseADT(module);
                    continue;
                }
                if (string.equals("type-alias")) {
                    this.parseTypeAlias(module);
                    continue;
                }
                throw new ParserException("Unexpected form " + string + " in program form", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            this.parseCloseParen();
        }
    }

    public Module parseModule() throws ParserException {
        return this.parseModule(null);
    }

    public Module parseModule(ModuleSignature moduleSignature) throws ParserException {
        boolean bl;
        this.m_parsedLibrary.add(this.m_baseURL);
        String string = this.parseFormProlog();
        boolean bl2 = bl = moduleSignature == null;
        if (!"module".equals(string)) {
            return this.parseProgramOrModuleFragment(false, string);
        }
        String string2 = this.parseIdentifier(true);
        if (moduleSignature == null) {
            moduleSignature = new ModuleSignature("");
        }
        Module module = new Module(string2, null, moduleSignature);
        this.parseModule(module, false);
        Parser.resolveFixups(module, this.m_typeFixups);
        this.m_typeFixups.clear();
        return module;
    }

    public static void resolveFixups(Module module, ArrayList arrayList) throws ParserException {
    }

    public ModuleSignature resolveModuleSignature(String string) throws ParserException {
        try {
            ModuleSignature moduleSignature = this.m_knownModuleSignatures.resolveModuleSignature(string);
            if (moduleSignature == null) {
                throw new RuntimeException();
            }
            return moduleSignature;
        }
        catch (Exception exception) {
            throw new ParserException("Unable to resolve module signature " + string + " in \n" + this.m_knownModuleSignatures, exception);
        }
    }

    public Module parseModuleFragment() throws ParserException {
        return this.parseProgramOrModuleFragment(true, null);
    }

    public Program parseProgram() throws ParserException {
        return (Program)this.parseProgramOrModuleFragment(false, null);
    }

    public Module parseProgramOrModuleFragment(boolean bl, String string) throws ParserException {
        Module module;
        ModuleSignature moduleSignature;
        boolean bl2 = true;
        while (true) {
            if (!bl2 || null == string) {
                this.m_parsedLibrary.add(this.m_baseURL);
                string = this.parseFormProlog();
            }
            bl2 = false;
            if (!string.equals("module-signature")) break;
            this.parseModuleSignature();
        }
        boolean bl3 = "library".equals(string);
        if (!bl3 && !"program".equals(string)) {
            throw new ParserException("Expected program or library form at root level", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        String string2 = null;
        if (!bl3) {
            string2 = this.parseIdentifier(false);
        }
        if (!bl3) {
            char c = this.read();
            if (c != '@') {
                moduleSignature = new ModuleSignature("");
                if (bl) {
                    moduleSignature.addFunctionSignature(new FunctionSignature("main", new Object[0], new Type[0], null));
                }
                this.unread(c);
            } else {
                String string3 = this.parseIdentifier(true);
                moduleSignature = this.resolveModuleSignature(string3);
            }
        } else {
            moduleSignature = new ModuleSignature("");
        }
        Module module2 = module = bl ? new Module("", null) : new Program(moduleSignature);
        if (null != string2) {
            module.setName(string2);
        }
        this.parseModule(module, bl3);
        return module;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.m_sourceStack.toArray();
        int n = objectArray.length + 1;
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n - 1);
        objectArray2[n - 1] = this.m_currentSource;
        for (int i = n - 1; 0 <= i; --i) {
            if (i == n - 1) {
                stringBuffer.append("at   ");
            } else {
                stringBuffer.append("from ");
            }
            ParserSource parserSource = (ParserSource)objectArray2[i];
            URL uRL = parserSource.m_currentURL;
            if (uRL != null) {
                String string = parserSource.m_currentURL.toString();
                int n2 = string.lastIndexOf(47);
                if (0 < n2) {
                    string = string.substring(n2);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(" at line ");
            stringBuffer.append(parserSource.m_lineNumber);
            stringBuffer.append(" at offset ");
            stringBuffer.append(parserSource.m_offset);
            stringBuffer.append('\n');
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static class StaticMethodSpec {
        String m_name;
        String m_class;
        String m_methodName;
        Type m_returnType;
        Type[] m_parameterTypes;
    }
}

