/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.MonthDayDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class XGMonthDay
extends XItemBase {
    private static TypeValidator m_validator = new MonthDayDV();
    private int m_month;
    private int m_day;

    public XGMonthDay(int n, int n2) {
        this(n, n2, Type.GMONTHDAY);
    }

    public XGMonthDay(int n, int n2, ItemType itemType) {
        this.m_month = n;
        this.m_day = n2;
        this.m_type = itemType;
    }

    @Override
    public int getPrimitiveId() {
        return 14;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getDay() {
        return this.m_day;
    }

    public static XGMonthDay parse(String string) {
        try {
            DateTimeBase dateTimeBase = (DateTimeBase)m_validator.getActualValue(string, null);
            return new XGMonthDay(dateTimeBase.getMonth(), dateTimeBase.getDay());
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof XGMonthDay) {
            XGMonthDay xGMonthDay = (XGMonthDay)object;
            return this.m_month == xGMonthDay.getMonth() && this.m_day == xGMonthDay.getDay();
        }
        return false;
    }

    @Override
    public XGMonthDay toGMonthDay() {
        return this;
    }

    @Override
    public String toString() {
        return "--" + CastLibrary.convertTo2CharString(this.m_month) + "-" + CastLibrary.convertTo2CharString(this.m_day);
    }

    @Override
    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    @Override
    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 14: {
                return this.equals(xItem.toGMonthDay());
            }
        }
        throw new TypeError();
    }

    public boolean equals(XGMonthDay xGMonthDay) {
        return this.m_month == xGMonthDay.getMonth() && this.m_day == xGMonthDay.getDay();
    }

    public final boolean notEquals(XGMonthDay xGMonthDay) throws TypeError {
        return !this.equals(xGMonthDay);
    }
}

