/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$ASCIIParser;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$BinaryParser;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$CertificateParser;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$PKCS7MimeParser;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$UnsuitableParserException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

class CertificateParserFactory$CompoundParser
implements CertificateParserFactory$CertificateParser {
    private Collection parsers = new ArrayList();

    public CertificateParserFactory$CompoundParser() {
        this.parsers.add(new CertificateParserFactory$ASCIIParser(null));
        this.parsers.add(new CertificateParserFactory$PKCS7MimeParser(null));
        this.parsers.add(new CertificateParserFactory$BinaryParser(null));
    }

    public Collection getCertificates(File file, String string) throws KeyManagerException {
        byte[] byArray;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byArray = new byte[((InputStream)bufferedInputStream).available()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)((InputStream)bufferedInputStream).read();
            }
            ((InputStream)bufferedInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INPUT_FILE_NOT_FOUND, fileNotFoundException, new String[]{file.toString()});
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, iOException, new String[]{iOException.getMessage()});
        }
        for (CertificateParserFactory$CertificateParser certificateParserFactory$CertificateParser : this.parsers) {
            try {
                return certificateParserFactory$CertificateParser.getCertificates(byArray, string);
            }
            catch (CertificateParserFactory$UnsuitableParserException certificateParserFactory$UnsuitableParserException) {
            }
            catch (KeyManagerException keyManagerException) {
                if (keyManagerException.getReason() == KeyManagerException$ExceptionReason.INVALID_CERTIFICATE_FILE || keyManagerException.getReason() == KeyManagerException$ExceptionReason.CORRUPT_CERTIFICATE) {
                    keyManagerException.addDetail(file.getAbsolutePath());
                }
                throw keyManagerException;
            }
        }
        throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_CERTIFICATE_FILE, new String[]{file.toString()});
    }

    public Collection getCertificates(Object object, String string) throws KeyManagerException {
        return this.getCertificates((File)object, string);
    }
}

