/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadRecordFlagException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.Buffer;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BufferFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.ByteSequenceInputStream;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.ByteSequenceInputStreamFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequence;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequenceFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RecordFlag;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncoding;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncodingFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordFactory$RequestRecordImpl;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import java.io.IOException;
import java.io.InputStream;

final class RequestRecordFactory {
    private RequestRecordFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static RequestRecord newRequestRecord(InputStream inputStream, int n) throws NullPointerException, IllegalArgumentException, BadRecordFlagException, IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        ByteSequenceInputStream byteSequenceInputStream = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        ByteSequence byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence == null) {
            return null;
        }
        RecordFlag recordFlag = RecordFlag.recordFlagFromByteSequence(IntableByteSequenceFactory.newIntableByteSequence(byteSequence));
        if (recordFlag == null) {
            throw new BadRecordFlagException();
        }
        byteSequence = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence == null) {
            return null;
        }
        IntableByteSequence intableByteSequence = IntableByteSequenceFactory.newIntableByteSequence(byteSequence);
        RequestRecordEncoding requestRecordEncoding = RequestRecordEncodingFactory.newRequestRecordEncoding(BufferFactory.newBuffer(inputStream));
        if (requestRecordEncoding == null) {
            return null;
        }
        Buffer buffer = BufferFactory.newBuffer(inputStream);
        if (buffer == null) {
            return null;
        }
        Buffer buffer2 = BufferFactory.newBuffer(inputStream);
        if (buffer2 == null) {
            return null;
        }
        int n2 = recordFlag.length() + intableByteSequence.length() + requestRecordEncoding.length() + buffer.length() + buffer2.length();
        int n3 = n - n2;
        if (n3 < 0) {
            throw new IllegalArgumentException();
        }
        inputStream.skip(n3);
        return new RequestRecordFactory$RequestRecordImpl(recordFlag, intableByteSequence, requestRecordEncoding, buffer, buffer2, n3);
    }
}

