/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.util.Properties;

public abstract class XCommand
extends BaseJdmpviewCommand {
    protected int argUnitSize = 1;
    protected int argUnitNumber = 1;
    protected String argDisplayFormat = "";

    public boolean recognises(String command, IContext context) {
        if (command.length() < 3) {
            return false;
        }
        return command.toLowerCase().startsWith("x/");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (command.length() > 3) {
            String arg = command.substring(2, command.length());
            this.parseArgs(arg);
        }
        this.doCommand(args);
    }

    protected abstract void doCommand(String[] var1);

    protected void parseArgs(String arg) {
        Character displayFormat;
        Character unitSize;
        int n;
        if (null == arg || arg.equals("")) {
            n = 1;
            unitSize = this.getDefaultUnitSize(this.ctx.getProperties());
            displayFormat = this.getDefaultDisplayFormat(this.ctx.getProperties());
        } else {
            char currChar;
            int i;
            n = 0;
            for (i = 0; i < arg.length() && Character.isDigit(arg.charAt(i)); ++i) {
                n *= 10;
                n += Character.getNumericValue(arg.charAt(i));
            }
            if (0 == n) {
                n = 1;
            }
            displayFormat = null;
            unitSize = null;
            if (i < arg.length()) {
                currChar = arg.charAt(i);
                switch (currChar) {
                    case 'b': 
                    case 'g': 
                    case 'h': 
                    case 'w': {
                        unitSize = Character.valueOf(currChar);
                        break;
                    }
                    default: {
                        displayFormat = Character.valueOf(currChar);
                    }
                }
                ++i;
            }
            if (i < arg.length()) {
                currChar = arg.charAt(i);
                switch (currChar) {
                    case 'b': 
                    case 'g': 
                    case 'h': 
                    case 'w': {
                        if (null == unitSize) {
                            unitSize = Character.valueOf(currChar);
                            break;
                        }
                        this.out.println("first letter after \"x/\" was a unit size character; second letter (if specified) must be a display format letter but it was also a unit size character");
                        return;
                    }
                    default: {
                        if (null == displayFormat) {
                            displayFormat = Character.valueOf(currChar);
                            break;
                        }
                        this.out.println("first letter after \"x/\" was a display format character; second letter (if specified) must be a unit size letter but it was also a display format character");
                        return;
                    }
                }
                ++i;
            }
            if (arg.length() != i) {
                this.out.println("too many letters after \"x/\"; the \"x/\" command accepts at most two letters, a display format character and a unit size character");
                return;
            }
            if (null == unitSize) {
                unitSize = this.getDefaultUnitSize(this.ctx.getProperties());
            } else {
                this.setDefaultUnitSize(this.ctx.getProperties(), unitSize);
            }
            if (null == displayFormat) {
                displayFormat = this.getDefaultDisplayFormat(this.ctx.getProperties());
            } else {
                this.setDefaultDisplayFormat(this.ctx.getProperties(), displayFormat);
            }
        }
        int nUnitSize = 1;
        char cUnitSize = unitSize.charValue();
        switch (cUnitSize) {
            default: {
                nUnitSize = 1;
                break;
            }
            case 'h': {
                nUnitSize = 2;
                break;
            }
            case 'w': {
                nUnitSize = 4;
                break;
            }
            case 'g': {
                nUnitSize = 8;
            }
        }
        this.argUnitSize = nUnitSize;
        this.argUnitNumber = n;
        this.argDisplayFormat = displayFormat.toString();
    }

    private Character getDefaultUnitSize(Properties properties) {
        Character defaultUnitSize = (Character)properties.get("x_default_unit_size");
        if (null == defaultUnitSize) {
            return Character.valueOf('w');
        }
        return defaultUnitSize;
    }

    private Character getDefaultDisplayFormat(Properties properties) {
        Character defaultDisplayFormat = (Character)properties.get("x_default_display_format");
        if (null == defaultDisplayFormat) {
            return Character.valueOf('x');
        }
        return defaultDisplayFormat;
    }

    private void setDefaultUnitSize(Properties properties, Character defaultUnitSize) {
        properties.put("x_default_unit_size", defaultUnitSize);
    }

    private void setDefaultDisplayFormat(Properties properties, Character defaultDisplayFormat) {
        properties.put("x_default_display_format", defaultDisplayFormat);
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("works like \"x/\" in gdb (including use of defaults): passes number of items to display and unit size ('b' for byte, 'h' for halfword, 'w' for word, 'g' for giant word) to sub-command (ie. x/12bd)");
    }
}

