/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.LockInfoUtil;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.MonitorInfoUtil;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class ThreadInfoUtil {
    private static CompositeType compositeType;

    public static CompositeType getCompositeType() {
        block3: {
            if (compositeType == null) {
                try {
                    String[] names = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    String[] descs = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    OpenType[] types = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, LockInfoUtil.getCompositeType(), SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(1, StackTraceElementUtil.getCompositeType()), new ArrayType(1, MonitorInfoUtil.getCompositeType()), new ArrayType(1, LockInfoUtil.getCompositeType())};
                    compositeType = new CompositeType(ThreadInfo.class.getName(), ThreadInfo.class.getName(), names, descs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static CompositeData toCompositeData(ThreadInfo info) {
        CompositeDataSupport result;
        block6: {
            result = null;
            if (info != null) {
                StackTraceElement[] st = info.getStackTrace();
                CompositeData[] stArray = new CompositeData[st.length];
                for (int i = 0; i < stArray.length; ++i) {
                    stArray[i] = StackTraceElementUtil.toCompositeData(st[i]);
                }
                MonitorInfo[] lockedMonitors = info.getLockedMonitors();
                CompositeData[] lmArray = new CompositeData[lockedMonitors.length];
                for (int i = 0; i < lmArray.length; ++i) {
                    lmArray[i] = MonitorInfoUtil.toCompositeData(lockedMonitors[i]);
                }
                LockInfo[] lockedSynchronizers = info.getLockedSynchronizers();
                CompositeData[] lsArray = new CompositeData[lockedSynchronizers.length];
                for (int i = 0; i < lsArray.length; ++i) {
                    lsArray[i] = LockInfoUtil.toCompositeData(lockedSynchronizers[i]);
                }
                CompositeType type = ThreadInfoUtil.getCompositeType();
                String[] names = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                Object[] values = new Object[]{info.getThreadId(), info.getThreadName(), info.getThreadState().name(), info.isSuspended(), info.isInNative(), info.getBlockedCount(), info.getBlockedTime(), info.getWaitedCount(), info.getWaitedTime(), LockInfoUtil.toCompositeData(info.getLockInfo()), info.getLockName(), info.getLockOwnerId(), info.getLockOwnerName(), stArray, lmArray, lsArray};
                try {
                    result = new CompositeDataSupport(type, names, values);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block6;
                    e.printStackTrace(System.err);
                }
            }
        }
        return result;
    }

    private ThreadInfoUtil() {
    }
}

