/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.spec.DHParameterSpec;

public final class DHPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private SessionManager sessionManager = null;
    private DHParameterSpec dhparamSpec = null;
    private Provider provider = null;
    private SecureRandom random = null;
    private Config config = null;

    public DHPKCS11KeyPairGenerator(Provider provider) {
        IBMPKCS11Impl.verifyJceJar();
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.provider = provider;
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        if (keysize < 512 || keysize > 2048 || keysize % 64 != 0) {
            throw new InvalidParameterException("Keysize must be multiple of 64, and can only range from 512 to 2048 (inclusive)");
        }
        this.random = random;
        try {
            AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH", this.provider);
            paramGen.init(keysize);
            AlgorithmParameters algParams = paramGen.generateParameters();
            this.dhparamSpec = algParams.getParameterSpec(DHParameterSpec.class);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair generateKeyPair() {
        KeyPair pair = null;
        if (this.random == null) {
            try {
                this.random = SecureRandom.getInstance("IBMSecureRandom", this.provider);
            }
            catch (NoSuchAlgorithmException nsae) {
                this.random = new SecureRandom();
            }
        }
        try {
            HashMap<Integer, Object> pubKeyGenAttribs = new HashMap<Integer, Object>();
            pubKeyGenAttribs.put(304, this.dhparamSpec.getP());
            pubKeyGenAttribs.put(306, this.dhparamSpec.getG());
            if (this.config != null) {
                pubKeyGenAttribs.putAll(this.config.getAttributes("GENERATE", PKCS11Object.PUBLIC_KEY, PKCS11Object.DH));
            }
            HashMap<Integer, Object> pvtKeyGenAttribs = new HashMap<Integer, Object>();
            pvtKeyGenAttribs.put(268, Boolean.TRUE);
            pvtKeyGenAttribs.put(352, this.dhparamSpec.getL());
            if (this.config != null) {
                pvtKeyGenAttribs.putAll(this.config.getAttributes("GENERATE", PKCS11Object.PRIVATE_KEY, PKCS11Object.DH));
            }
            int[] pubTypes = new int[pubKeyGenAttribs.size()];
            Object[] pubValues = new Object[pubKeyGenAttribs.size()];
            Iterator it = pubKeyGenAttribs.entrySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                pubTypes[i] = (Integer)entry.getKey();
                pubValues[i++] = entry.getValue();
            }
            int[] privTypes = new int[pvtKeyGenAttribs.size()];
            Object[] privValues = new Object[pvtKeyGenAttribs.size()];
            it = pvtKeyGenAttribs.entrySet().iterator();
            i = 0;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                privTypes[i] = (Integer)entry.getKey();
                privValues[i++] = entry.getValue();
            }
            Session session = null;
            PKCS11Object[] objs = null;
            DHPKCS11PublicKey pubKey = null;
            DHPKCS11PrivateKey privKey = null;
            try {
                session = this.sessionManager.getObjSession();
                byte[] seed = this.random.generateSeed(16);
                try {
                    session.seedRandom(seed, 0, 16);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    // empty catch block
                }
                objs = session.generateKeyPair(32, null, pubTypes, pubValues, privTypes, privValues);
                boolean pubTokenKey = session.getBoolAttributeValue(objs[0], 1);
                boolean privTokenKey = session.getBoolAttributeValue(objs[1], 1);
                if (!pubTokenKey) {
                    session.addObject();
                    pubKey = new DHPKCS11PublicKey(objs[0], session);
                    pubKey.setSession(session);
                } else {
                    pubKey = new DHPKCS11PublicKey(objs[0], session);
                }
                if (!privTokenKey) {
                    session.addObject();
                    privKey = new DHPKCS11PrivateKey(objs[1], session);
                    privKey.setSession(session);
                } else {
                    privKey = new DHPKCS11PrivateKey(objs[1], session);
                }
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
            pair = new KeyPair(pubKey, privKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage());
        }
        return pair;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null || !(params instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("DHParameterSpec must be specified");
        }
        this.dhparamSpec = (DHParameterSpec)params;
        this.random = random;
    }
}

