/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.VM;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.security.action.GetPropertyAction;

public class SBCS_Decoder
extends CharsetDecoder
implements ArrayDecoder {
    private final char[] byteToCharTable_charr;
    private final char[] charMap;
    private boolean subMode = true;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static boolean bidiConfigDone = false;
    private static String bidiInit;
    protected static final int NEW_LINE_INDEX = 149;
    protected static final char SWAPPED_NEW_LINE_CHAR = '\u0085';
    private String csName = null;
    protected boolean useArrayLoop = true;
    private char[] swaplf_byteToCharTable_charr = null;
    private static final boolean remapTable;

    protected SBCS_Decoder(Charset charset, String string) {
        super(charset, 1.0f, 1.0f);
        String string2 = this.handleIBMSwapLF(string);
        this.byteToCharTable_charr = string2.toCharArray();
        this.charMap = SBCS_Decoder.createCharMap(string2);
        this.csName = charset.name();
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected String handleIBMSwapLF(String string) {
        return string;
    }

    public static final boolean isSwapLF() {
        return ExtendedCharsets.isSwapLF();
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        boolean bl = false;
        int n5 = n;
        int n6 = n3;
        int n7 = n2 - n;
        if (n7 > n4 - n3) {
            bl = true;
            n7 = n4 - n3;
        }
        int n8 = n7;
        char c = '\u0000';
        if (this.charMap != null) {
            int n9 = this.decodeSBCS(byArray, n5, n8, cArray, n6, this.charMap);
        } else {
            for (int i = 0; i < n8; ++i) {
                cArray[i + n6] = c = this.byteToCharTable_charr[byArray[i + n5] + 128];
            }
        }
        int n10 = n + n7;
        int n11 = n3 + n7;
        if (bl) {
            coderResult = CoderResult.OVERFLOW;
        }
        byteBuffer.position(n10 - byteBuffer.arrayOffset());
        charBuffer.position(n11 - charBuffer.arrayOffset());
        return coderResult;
    }

    @Override
    public int decode(byte[] byArray, int n, int n2, char[] cArray) {
        BidiConvert bidiConvert;
        int n3 = 0;
        int n4 = Math.min(n2, cArray.length);
        int n5 = n;
        char[] cArray2 = this.charMap;
        char[] cArray3 = this.byteToCharTable_charr;
        int n6 = n2;
        if (n6 > n4) {
            n6 = n4;
        }
        int n7 = n6;
        char c = '\u0000';
        int n8 = 0;
        if (ExtendedCharsets.isSwapLF()) {
            if (null == this.swaplf_byteToCharTable_charr) {
                this.swaplf_byteToCharTable_charr = this.handleIBMSwapLF(new String(this.byteToCharTable_charr)).toCharArray();
            }
            cArray3 = this.swaplf_byteToCharTable_charr;
            cArray2 = null;
        }
        if (cArray2 != null) {
            int n9 = this.decodeSBCS(byArray, n, n7, cArray, n3, cArray2);
        } else {
            while (n8 < n7) {
                cArray[n8] = c = cArray3[byArray[n8 + n5] + 128];
                ++n8;
            }
        }
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, 0, n6, this.bidiParms, this.csName)) {
            char[] cArray4 = bidiConvert.toUnicode(cArray, 0, n6, this.bidiParms, this.csName);
            System.arraycopy(cArray4, 0, cArray, 0, cArray4.length);
        }
        return n6;
    }

    private final int decodeSBCS(byte[] byArray, int n, int n2, char[] cArray, int n3, char[] cArray2) {
        int n4;
        char c = '\u0000';
        for (n4 = 0; n4 < n2; ++n4) {
            cArray[n4 + n3] = c = cArray2[byArray[n4 + n] & 0xFF];
        }
        return n4;
    }

    private static boolean _isRemapTable() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.arch");
            }
        });
        return string.contains("390");
    }

    private static boolean isRemapTable() {
        return remapTable;
    }

    protected static char[] createCharMap(String string) {
        char[] cArray;
        if (SBCS_Decoder.isRemapTable()) {
            int n;
            cArray = new char[256];
            for (n = 0; n < 128; ++n) {
                cArray[n + 128] = string.charAt(n);
            }
            for (n = 128; n < 256; ++n) {
                cArray[n - 128] = string.charAt(n);
            }
        } else {
            cArray = null;
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                int n2 = byteBuffer.get() + 128;
                char c = n2 >= this.byteToCharTable_charr.length || n2 < 0 ? (char)'\ufffd' : (char)this.decode(n2, this.byteToCharTable_charr[n2]);
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        BidiConvert bidiConvert;
        int n;
        int n2;
        char[] cArray;
        CoderResult coderResult;
        boolean bl;
        int n3 = charBuffer.position();
        if (byteBuffer.hasArray() && charBuffer.hasArray() && this.useArrayLoop) {
            bl = true;
            coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
            int n4 = charBuffer.position();
            cArray = charBuffer.array();
            n2 = charBuffer.arrayOffset() + n3;
            n = charBuffer.arrayOffset() + n4;
        } else {
            bl = false;
            coderResult = this.decodeBufferLoop(byteBuffer, charBuffer);
            int n5 = charBuffer.position();
            n2 = 0;
            n = n5 - n3;
            cArray = new char[n];
            charBuffer.position(n3);
            charBuffer.get(cArray);
            charBuffer.position(n5);
        }
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n2, n, this.bidiParms, this.csName)) {
            cArray = bidiConvert.toUnicode(cArray, n2, n, this.bidiParms, this.csName);
            if (bl) {
                System.arraycopy(cArray, 0, charBuffer.array(), charBuffer.arrayOffset() + n3, cArray.length);
            } else {
                charBuffer.position(n3);
                charBuffer.put(cArray);
            }
        }
        return coderResult;
    }

    public char decode(int n, char c) {
        return c;
    }

    static {
        remapTable = SBCS_Decoder._isRemapTable();
    }
}

