/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class ServiceSection {
    TraceContext context;
    String serviceString;
    String textSummary;

    public ServiceSection(TraceContext context, ByteBuffer data) throws IllegalArgumentException {
        this.context = context;
        DataHeader dataHeader = new DataHeader(context, data, "UTSS");
        byte[] stringData = new byte[dataHeader.length - 16];
        data.get(stringData);
        for (int i = 0; i < stringData.length; ++i) {
            if (stringData[i] != 0) continue;
            try {
                this.serviceString = new String(stringData, 0, i, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.serviceString = new String(stringData, 0, i);
            }
            break;
        }
        if (context.debugStream != null) {
            context.debug(this, 1, this.summary());
        }
    }

    public String toString() {
        return "Service level";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder s = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            s.append("        ");
            s.append(this.serviceString).append(System.getProperty("line.separator"));
            this.textSummary = s.toString();
        }
        return this.textSummary;
    }
}

