/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.marshalling.data.events;

import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.FileInternalEvent;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.FileInternalObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FileEventHandler
extends Thread {
    List<FileInternalEvent> listeners = new ArrayList<FileInternalEvent>();
    Queue<FileInternalObject> events = new ConcurrentLinkedQueue<FileInternalObject>();
    private boolean flushData = false;
    private static int eventQueueSize = 0;
    private static final int maxEventQueueSize = 15;
    protected volatile boolean run = true;

    public FileEventHandler() {
        super("File Event Handler");
        this.setDaemon(true);
    }

    public void addFileEventListener(FileInternalEvent fileInternalEvent) {
        this.listeners.add(fileInternalEvent);
    }

    private void triggerFile(FileInternalObject fileInternalObject) {
        for (FileInternalEvent fileInternalEvent : this.listeners) {
            fileInternalEvent.fileEvent(fileInternalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(FileInternalObject fileInternalObject) {
        Queue<FileInternalObject> queue = this.events;
        synchronized (queue) {
            if (eventQueueSize < 15 && !this.flushData) {
                this.events.add(fileInternalObject);
                ++eventQueueSize;
            } else {
                this.flushData = true;
            }
            this.events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (!this.events.isEmpty()) {
                    if (this.flushData) {
                        while (this.flushData) {
                            this.triggerFile(this.events.poll());
                            --eventQueueSize;
                            if (!this.events.isEmpty()) continue;
                            this.flushData = false;
                        }
                    } else {
                        this.triggerFile(this.events.poll());
                        --eventQueueSize;
                    }
                }
                Queue<FileInternalObject> queue = this.events;
                synchronized (queue) {
                    try {
                        if (this.events.isEmpty()) {
                            this.events.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
    }
}

