/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.slicer;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.FileParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.slicer.SlicerImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.FileSlicer;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class FileSlicerImpl
extends SlicerImpl
implements FileSlicer {
    private static final String NEW_SLICER_FILE_SUFFIX = "file";
    private static final String NEW_SLICER_FILE_PREFIX = "fileslicer";
    private static Logger TRACE = LogFactory.getTrace(FileSlicerImpl.class);
    private FileParser fileParser;
    private File file;
    private long parsedLength = 0L;

    public FileSlicerImpl(Source source, FileParser fileParser, Marshaller marshaller) throws JavaDiagnosticsException {
        super(source, fileParser, marshaller);
        this.fileParser = fileParser;
        try {
            this.file = File.createTempFile(NEW_SLICER_FILE_PREFIX, NEW_SLICER_FILE_SUFFIX);
            this.file.deleteOnExit();
        }
        catch (IOException iOException) {
            throw new JavaDiagnosticsException(iOException.toString());
        }
    }

    @Override
    public void notifySourceChanged(InputStream inputStream) {
        if (this.file != null) {
            this.parsedLength = 0L;
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                byte[] byArray = new byte[1000];
                int n = ((InputStream)bufferedInputStream).read(byArray);
                while (n > 0) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    n = ((InputStream)bufferedInputStream).read(byArray);
                }
                ((OutputStream)bufferedOutputStream).close();
                if (this.isEnabled()) {
                    this.marshaller.addToQueue(this);
                }
            }
            catch (IOException iOException) {
                TRACE.warning(iOException.toString());
            }
        }
    }

    @Override
    protected ProgressIndicator internalTriggerParse(DataBuilder dataBuilder, OutputProperties outputProperties) throws JavaDiagnosticsException, IOException {
        if (dataBuilder == null) {
            TRACE.warning(NULL_DATA_WARNING);
            return null;
        }
        ProgressIndicator progressIndicator = this.fileParser.parse(this.file, dataBuilder, outputProperties);
        this.parsedLength = this.file.length();
        return progressIndicator;
    }

    @Override
    public boolean isUnseenSourceAvailable() {
        return this.getAvailableSize() > this.parsedLength;
    }

    @Override
    public boolean isAnySourceAvailable() {
        return this.isUnseenSourceAvailable();
    }

    public long getAvailableSize() {
        return this.file.length();
    }

    @Override
    protected void clearBufferCaches() {
        boolean bl;
        if (this.file != null && !(bl = this.file.delete())) {
            TRACE.warning(MessageFormat.format(Messages.getString("FileSlicerImpl.problem.deleting.file"), this.file.getAbsolutePath()));
        }
    }

    @Override
    protected int getDefaultSliceSize() {
        return 1;
    }
}

