/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.dumpreader;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressRange;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.dumpreader.Dump;
import com.ibm.dtfj.corereaders.zos.util.CharConversion;
import com.ibm.dtfj.corereaders.zos.util.IntegerMap;
import com.ibm.dtfj.corereaders.zos.util.ObjectLruCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddressSpace
implements Serializable {
    protected Dump dump;
    protected int asid;
    protected IntegerMap addressMap = new IntegerMap();
    private int quickCacheHits;
    private int cacheHits;
    private int cacheMisses;
    private ObjectLruCache blockCache;
    protected long lastBlockAddress;
    private byte[] lastBlock;
    protected long lastButOneBlockAddress;
    private byte[] lastButOneBlock;
    protected AddressRange[] ranges;
    private AddressSpaceImageInputStream imageStream;
    private boolean is64bit;
    private HashMap userMap = new HashMap();
    public static final long WILD_POINTER = -4995072469322842385L;
    private static Logger log = Logger.getLogger(AddressSpace.class.getName());
    private static final boolean printStats = Boolean.getBoolean("zebedee.printStats");

    public AddressSpace(Dump dump, int asid) {
        this.dump = dump;
        this.asid = asid;
        this.initialize();
    }

    public Dump getDump() {
        return this.dump;
    }

    public AddressSpace getRootAddressSpace() {
        return this.dump.rootSpace;
    }

    private void initialize() {
        this.blockCache = new ObjectLruCache(500);
        this.userMap = new HashMap();
        this.lastBlockAddress = -1L;
        this.lastButOneBlockAddress = -1L;
        if (printStats && this.getClass() == AddressSpace.class) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    System.out.println("stats for asid " + AddressSpace.hex(AddressSpace.this.asid) + ":");
                    System.out.println("    cacheMisses = " + AddressSpace.this.cacheMisses);
                    System.out.println("    cacheHits = " + AddressSpace.this.cacheHits);
                    System.out.println("    quickCacheHits = " + AddressSpace.this.quickCacheHits);
                }
            });
        }
    }

    public Map getUserMap() {
        return this.userMap;
    }

    public int getAsid() {
        return this.asid;
    }

    public AddressRange[] getAddressRanges() {
        if (this.ranges != null) {
            return this.ranges;
        }
        long[] addresses = this.addressMap.getKeysArray();
        Arrays.sort(addresses);
        long startAddress = 0L;
        long lastAddress = 0L;
        Vector<AddressRange> v = new Vector<AddressRange>();
        for (int i = 0; i < addresses.length; ++i) {
            if (i == 0) {
                startAddress = addresses[0];
            } else if (addresses[i] != lastAddress + 4096L) {
                v.add(new AddressRange(startAddress, lastAddress + 4096L - startAddress));
                startAddress = addresses[i];
            }
            lastAddress = addresses[i];
        }
        v.add(new AddressRange(startAddress, lastAddress + 4096L - startAddress));
        this.ranges = v.toArray(new AddressRange[0]);
        return this.ranges;
    }

    public AddressRange[] getUnusedAddressRanges() {
        this.getAddressRanges();
        AddressRange[] unused = new AddressRange[this.ranges.length - 1];
        for (int i = 0; i < unused.length; ++i) {
            long start = this.ranges[i].getEndAddress() + 1L;
            long end = this.ranges[i + 1].getStartAddress() - 1L;
            unused[i] = new AddressRange(start, end - start);
        }
        return unused;
    }

    public AddressSpaceImageInputStream getImageInputStream() {
        if (this.imageStream == null) {
            this.imageStream = new AddressSpaceImageInputStream(this);
        }
        assert (this.imageStream != null);
        return this.imageStream;
    }

    private void checkIfWild(long address) {
        assert (address != -4995072469322842385L);
        assert ((int)address != -559038737);
        assert (address < -4995072469322846481L || address > -4995072469322838289L) : AddressSpace.hex(address);
        assert ((int)address < -559042833 || (int)address > -559034641) : AddressSpace.hex((int)address);
    }

    protected long roundToPage(long address) {
        this.checkIfWild(address);
        if (this.is64bit()) {
            return address & 0xFFFFFFFFFFFFF000L;
        }
        return address & 0x7FFFF000L;
    }

    public long stripTopBit(long address) {
        this.checkIfWild(address);
        if (this.is64bit()) {
            assert (address >= 0L) : AddressSpace.hex(address);
            return address;
        }
        return address & Integer.MAX_VALUE;
    }

    private void read(long address, byte[] buf) throws IOException {
        long blockAddress;
        long offset;
        if (log.isLoggable(Level.FINER)) {
            log.finer("request to read " + buf.length + " from address 0x" + AddressSpace.hex(address));
        }
        if ((offset = this.addressMap.get(blockAddress = this.roundToPage(address))) == -1L) {
            if (this.asid != 1 && (offset = this.dump.rootSpace.addressMap.get(blockAddress)) != -1L) {
                log.fine("found address " + AddressSpace.hex(address) + " in root address space");
            }
            if (offset == -1L) {
                throw new IOException("block address " + AddressSpace.hex(address) + " not in dump");
            }
        }
        this.dump.seek(offset);
        if (buf.length > 4096) {
            throw new Error("to be completed");
        }
        this.dump.readFully(buf);
    }

    final byte[] getBlockFromQuickCache(long address) {
        assert ((address & 0xFFFL) == 0L);
        if (address == this.lastBlockAddress) {
            ++this.quickCacheHits;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("request to get block for address 0x" + AddressSpace.hex(address) + " met by quick cache");
            }
            return this.lastBlock;
        }
        if (address == this.lastButOneBlockAddress) {
            ++this.quickCacheHits;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("request to get block for address 0x" + AddressSpace.hex(address) + " met by quick cache");
            }
            return this.lastButOneBlock;
        }
        return null;
    }

    final void putBlockInQuickCache(long address, byte[] block) {
        assert ((address & 0xFFFL) == 0L);
        this.lastButOneBlockAddress = this.lastBlockAddress;
        this.lastButOneBlock = this.lastBlock;
        this.lastBlockAddress = address;
        this.lastBlock = block;
    }

    final byte[] getBlock(long address) throws IOException {
        byte[] b = this.getBlockFromQuickCache(address = this.roundToPage(address));
        return b != null ? b : this.getBlockFromCacheOrDisk(address);
    }

    protected byte[] getBlockFromCacheOrDisk(long address) throws IOException {
        assert ((address & 0xFFFL) == 0L);
        byte[] block = (byte[])this.blockCache.get(address);
        if (block == null) {
            ++this.cacheMisses;
            block = new byte[4096];
            this.read(address, block);
            this.blockCache.put(address, block);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("request to get block for address 0x" + AddressSpace.hex(address) + " met by file read");
            }
        } else {
            ++this.cacheHits;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("request to get block for address 0x" + AddressSpace.hex(address) + " met by cache");
            }
        }
        this.putBlockInQuickCache(address, block);
        return block;
    }

    public int read(long address) throws IOException {
        return this.getBlock(address)[(int)address & 0xFFF] & 0xFF;
    }

    public int readInt(long address) throws IOException {
        int offset = (int)address & 0xFFF;
        if (offset <= 4092) {
            return Dump.readInt(this.getBlock(address), offset);
        }
        int ch1 = this.read(address++);
        int ch2 = this.read(address++);
        int ch3 = this.read(address++);
        int ch4 = this.read(address++);
        return ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4;
    }

    public int readUnsignedByte(long address) throws IOException {
        return this.read(address);
    }

    public byte readByte(long address) throws IOException {
        return (byte)this.readUnsignedByte(address);
    }

    public int readUnsignedShort(long address) throws IOException {
        int ch1 = this.read(address);
        int ch2 = this.read(address + 1L);
        return ch1 << 8 | ch2;
    }

    public short readShort(long address) throws IOException {
        return (short)this.readUnsignedShort(address);
    }

    public long readUnsignedInt(long address) throws IOException {
        long i = this.readInt(address);
        return i & 0xFFFFFFFFL;
    }

    public long readLong(long address) throws IOException {
        long upper = this.readInt(address);
        long lower = this.readInt(address + 4L);
        return upper << 32 | lower & 0xFFFFFFFFL;
    }

    public long readWord(long address) throws IOException {
        return this.is64bit ? this.readLong(address) : (long)this.readInt(address) & 0xFFFFFFFFL;
    }

    public int getWordLength() {
        return this.is64bit ? 8 : 4;
    }

    public void read(long address, byte[] b, int off, int len) throws IOException {
        address = this.stripTopBit(address);
        while (true) {
            int blockOffset;
            byte[] block;
            int blockRemainder;
            if (len <= (blockRemainder = (block = this.getBlock(address)).length - (blockOffset = (int)(address % (long)block.length)))) {
                System.arraycopy(block, blockOffset, b, off, len);
                return;
            }
            System.arraycopy(block, blockOffset, b, off, blockRemainder);
            address += (long)blockRemainder;
            off += blockRemainder;
            len -= blockRemainder;
        }
    }

    public String readEbcdicString(long address, int length) throws IOException {
        byte[] b = new byte[length];
        this.read(address, b, 0, length);
        return CharConversion.getEbcdicString(b);
    }

    public String readEbcdicString(long address) throws IOException {
        int length = this.readUnsignedShort(address);
        return this.readEbcdicString(address + 2L, length);
    }

    public String readEbcdicCString(long address) throws IOException {
        int length = 0;
        long addr = address;
        while (this.read(addr) != 0) {
            ++addr;
            ++length;
        }
        return this.readEbcdicString(address, length);
    }

    public String readAsciiString(long address, int length) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buf.append((char)this.read(address++));
        }
        return buf.toString();
    }

    public String readAsciiCString(long address) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while ((c = this.read(address++)) != 0) {
            buf.append((char)c);
        }
        return buf.toString();
    }

    public String readAsciiString(long address) throws IOException {
        int length = this.readUnsignedShort(address);
        return this.readAsciiString(address + 2L, length);
    }

    public String readUtf8String(long address) throws IOException {
        int length = this.readUnsignedShort(address);
        return this.readAsciiString(address + 2L, length);
    }

    public boolean isValid(long address) {
        AddressRange[] ranges = this.getAddressRanges();
        for (int i = 0; i < ranges.length; ++i) {
            if (address < ranges[i].getStartAddress() || address > ranges[i].getEndAddress()) continue;
            return true;
        }
        return false;
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public void setIs64bit(boolean is64bit) {
        log.fine("Set address space " + this.asid + " as " + (is64bit ? "64-bit" : "32-bit"));
        this.is64bit = is64bit;
    }

    void mapAddressToFileOffset(long address, long offset) {
        if (this.addressMap.get(address) != -1L) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("duplicate address 0x" + AddressSpace.hex(address) + " for asid " + this.asid);
            }
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("mapping address 0x" + AddressSpace.hex(address) + " to offset " + AddressSpace.hex(offset) + " for asid " + this.asid);
        }
        this.addressMap.put(address, offset);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    public String toString() {
        return AddressSpace.hex(this.asid);
    }

    void setDump(Dump dump) {
        this.dump = dump;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.asid);
        out.writeObject(this.addressMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.asid = in.readInt();
        this.addressMap = (IntegerMap)in.readObject();
        this.initialize();
    }
}

