/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.NativeThreadContext;
import com.ibm.dtfj.corereaders.Register;
import com.ibm.dtfj.corereaders.StackFrame;
import java.util.Iterator;
import java.util.Vector;

public class GenericThread {
    protected String threadId;
    protected String javaLangThreadObjectAddress;
    protected String threadDetails;
    protected String threadName;
    protected String state;
    protected String monitorId;
    boolean isJavaThread;
    long stackstart = 0L;
    int stacksize = 0;
    int rva = 0;
    Vector registers = new Vector();
    Vector nativeFrames = new Vector();
    protected NativeThreadContext context = null;

    public GenericThread(GenericThread thread) {
        this.threadId = thread.getThreadId();
        this.javaLangThreadObjectAddress = thread.javaLangThreadObjectAddress();
        this.state = thread.getState();
        this.monitorId = thread.getMonitorId();
        this.isJavaThread = true;
    }

    public GenericThread(String threadId, long stackstart, int stacksize, int rva) {
        this.threadId = threadId;
        this.stackstart = stackstart;
        this.stacksize = stacksize;
        this.rva = rva;
        this.state = "Unknown";
        this.isJavaThread = false;
    }

    public GenericThread(String id, String obj, String state, String monitor) {
        this.threadId = id;
        this.javaLangThreadObjectAddress = obj;
        this.state = state;
        this.monitorId = monitor;
        this.isJavaThread = true;
    }

    public String javaLangThreadObjectAddress() {
        return this.javaLangThreadObjectAddress;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getMonitorId() {
        return this.monitorId;
    }

    public String getState() {
        return this.state;
    }

    public String getThreadName() {
        if (null == this.threadName) {
            return " Un-established";
        }
        return this.threadName;
    }

    public boolean isJavaThread() {
        return false;
    }

    public void addRegister(Register r) {
        this.registers.add(r);
    }

    public void addNativeFrame(StackFrame f) {
        this.nativeFrames.add(f);
    }

    public Register getNamedRegister(String name) {
        String name1 = name.toUpperCase();
        Iterator it = this.getRegisters();
        while (it.hasNext()) {
            Register r = (Register)it.next();
            if (!r.name.toUpperCase().equals(name1)) continue;
            return r;
        }
        return null;
    }

    public Iterator getRegisters() {
        return this.registers.iterator();
    }

    public Iterator getNativeFrames() {
        return this.nativeFrames.iterator();
    }

    public int getStacksize() {
        return this.stacksize;
    }

    public long getStackstart() {
        return this.stackstart;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.printHeader(sb);
        sb.append(" System thread\n");
        sb.append("  Id      : " + this.threadId + "\n");
        sb.append("  State   : " + this.state);
        this.printNativeFrames(sb);
        sb.append("\n");
        return sb.toString();
    }

    public void printHeader(StringBuffer sb) {
        sb.append("Info for system thread - " + this.threadId + "\n====================================\n");
    }

    public void printNativeFrames(StringBuffer sb) {
        if (0 != this.nativeFrames.size()) {
            sb.append("\n\tStack:\n");
            for (int i = 0; i < this.nativeFrames.size(); ++i) {
                StackFrame frameInfo = (StackFrame)this.nativeFrames.get(i);
                if (null == frameInfo) continue;
                sb.append("\t\t" + frameInfo.toString() + "\n");
            }
        } else {
            sb.append("\n\t No Stack available");
        }
    }

    public NativeThreadContext getContext() {
        return this.context;
    }

    public void setContext(NativeThreadContext context) {
        this.context = context;
    }

    public String getJavaLangThreadObjectAddress() {
        return this.javaLangThreadObjectAddress;
    }

    public void setStacksize(int stacksize) {
        this.stacksize = stacksize;
    }

    public void setStackstart(long stackstart) {
        this.stackstart = stackstart;
    }

    public boolean matchIdOrName(String key) {
        if ("*".equals(key)) {
            return true;
        }
        String tid = this.getThreadId();
        String name = this.getThreadName();
        if (tid.equals(key) || tid.toUpperCase().equals(key.toUpperCase()) || tid.equals("0x" + key) || tid.toUpperCase().equals(("0x" + key).toUpperCase())) {
            return true;
        }
        if (null != name && (name.equals(key) || name.toUpperCase().equals(key.toUpperCase()) || name.startsWith(key) || name.toUpperCase().startsWith(key.toUpperCase()))) {
            return true;
        }
        String deriveThread = new String(key);
        if (deriveThread.toUpperCase().startsWith("0x")) {
            deriveThread = deriveThread.substring(2);
        }
        while (deriveThread.startsWith("0")) {
            deriveThread = deriveThread.substring(1);
        }
        deriveThread = "0x" + deriveThread;
        deriveThread = deriveThread.toUpperCase();
        return tid.toUpperCase().equals(deriveThread);
    }
}

