/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.rmi.util.EqualByIdentity;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.WeakHashMap;

public final class BAPool {
    private final HashMap holderKeyToEntriesMap;
    private final WeakHashMap baToHeldEntryMap;
    private final WeakHashMap holderToHolderKeyMap;
    private final ReferenceQueue holderQueue;
    private final int baSize;
    private Entry freeListHead = null;
    private Entry freeListLast = null;
    private static final HashMap sizeToBAPoolMap = new HashMap();

    public static synchronized BAPool getInstance(int n) {
        Integer n2 = n;
        BAPool bAPool = (BAPool)sizeToBAPoolMap.get(n2);
        if (bAPool == null) {
            bAPool = new BAPool(n);
            sizeToBAPoolMap.put(n2, bAPool);
        }
        return bAPool;
    }

    private BAPool(int n) {
        this.baSize = n;
        this.holderKeyToEntriesMap = new HashMap();
        this.baToHeldEntryMap = new WeakHashMap();
        this.holderToHolderKeyMap = new WeakHashMap();
        this.holderQueue = new ReferenceQueue();
    }

    private Object getHolderKey(EqualByIdentity equalByIdentity) {
        Object object = this.holderToHolderKeyMap.get(equalByIdentity);
        if (object == null) {
            object = new WeakReference<EqualByIdentity>(equalByIdentity, this.holderQueue);
            this.holderToHolderKeyMap.put(equalByIdentity, object);
        }
        return object;
    }

    public int getBASize() {
        return this.baSize;
    }

    public synchronized byte[] getBA(EqualByIdentity equalByIdentity) {
        byte[] byArray = null;
        Entry entry = null;
        this.processQueue();
        while ((entry = this.freeListHead) != null) {
            this.freeListHead = entry.getNext();
            if (this.freeListHead == null) {
                this.freeListLast = null;
            }
            if ((byArray = (byte[])entry.get()) == null) continue;
        }
        if (byArray == null) {
            byArray = new byte[this.baSize];
            entry = new Entry(byArray);
        } else {
            entry.setNext(null);
            entry.incHoldCount();
        }
        this.addEntryToHolderSet(equalByIdentity, entry);
        this.baToHeldEntryMap.put(byArray, entry);
        return byArray;
    }

    public synchronized boolean registerBAHolder(EqualByIdentity equalByIdentity, byte[] byArray) {
        Entry entry = null;
        boolean bl = false;
        this.processQueue();
        entry = (Entry)this.baToHeldEntryMap.get(byArray);
        if (entry != null) {
            bl = true;
            if (this.addEntryToHolderSet(equalByIdentity, entry)) {
                entry.incHoldCount();
            }
        }
        return bl;
    }

    public synchronized void unregisterBAHolder(EqualByIdentity equalByIdentity, byte[] byArray) {
        Object object;
        Object v;
        Entry entry = null;
        this.processQueue();
        entry = (Entry)this.baToHeldEntryMap.get(byArray);
        if (entry != null && (v = this.holderKeyToEntriesMap.get(object = this.getHolderKey(equalByIdentity))) != null) {
            if (v instanceof Entry) {
                if (v == entry) {
                    this.releaseEntryHold(entry);
                }
            } else {
                TreeSet treeSet = (TreeSet)v;
                if (treeSet.remove(entry)) {
                    this.releaseEntryHold(entry);
                }
            }
        }
    }

    private void processQueue() {
        Reference reference = null;
        while ((reference = this.holderQueue.poll()) != null) {
            Object v = this.holderKeyToEntriesMap.remove(reference);
            if (v == null) continue;
            if (v instanceof Entry) {
                this.releaseEntryHold((Entry)v);
                continue;
            }
            Iterator iterator = ((TreeSet)v).iterator();
            while (iterator.hasNext()) {
                this.releaseEntryHold((Entry)iterator.next());
            }
        }
    }

    private void releaseEntryHold(Entry entry) {
        entry.decHoldCount();
        if (!entry.isHeld()) {
            this.baToHeldEntryMap.remove(entry);
            if (this.freeListHead == null) {
                this.freeListHead = this.freeListLast = entry;
            } else {
                this.freeListLast.setNext(entry);
                this.freeListLast = entry;
            }
        }
    }

    private boolean addEntryToHolderSet(EqualByIdentity equalByIdentity, Entry entry) {
        TreeSet<Object> treeSet;
        Object object = this.getHolderKey(equalByIdentity);
        Object v = this.holderKeyToEntriesMap.get(object);
        if (v == null) {
            this.holderKeyToEntriesMap.put(object, entry);
            return true;
        }
        if (v instanceof Entry) {
            treeSet = new TreeSet<Object>();
            treeSet.add(v);
            this.holderKeyToEntriesMap.put(object, treeSet);
        } else {
            treeSet = (TreeSet<Object>)v;
        }
        return treeSet.add(entry);
    }

    private static final class Entry
    extends SoftReference {
        private Entry next = null;
        private int holdCount = 1;

        Entry(byte[] byArray) {
            super(byArray);
        }

        void setNext(Entry entry) {
            this.next = entry;
        }

        Entry getNext() {
            return this.next;
        }

        void incHoldCount() {
            ++this.holdCount;
        }

        void decHoldCount() {
            --this.holdCount;
        }

        boolean isHeld() {
            return this.holdCount != 0;
        }
    }
}

