/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.HiddenInstanceField;
import com.ibm.j9ddr.vm29_00.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29_00.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29_00.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29_00.structure.J9Object;
import com.ibm.j9ddr.vm29_00.types.U32;
import com.ibm.j9ddr.vm29_00.types.UDATA;
import java.util.ArrayList;
import java.util.LinkedList;

public class ObjectFieldInfo {
    J9ROMClassPointer romClass;
    int _superclassFieldsSize;
    boolean _objectCanUseBackfill;
    public static final int fj9object_t_SizeOf = J9BuildFlags.gc_compressedPointers ? 4 : UDATA.SIZEOF;
    public static final int j9objectmonitor_t_SizeOf;
    int _instanceObjectCount = 0;
    int _instanceSingleCount = 0;
    int _instanceDoubleCount = 0;
    int _totalObjectCount = 0;
    int _totalSingleCount = 0;
    int _totalDoubleCount = 0;
    boolean _instanceFieldBackfillEligible;
    int _hiddenFieldCount = 0;
    int _superclassBackfillOffset;
    int _myBackfillOffset;
    int _subclassBackfillOffset;
    public static final int NO_BACKFILL_AVAILABLE = -1;
    public static final int BACKFILL_SIZE = 4;
    public static final int LOCKWORD_SIZE;
    public static final int FINALIZE_LINK_SIZE;
    public static final int OBJECT_SIZE_INCREMENT_IN_BYTES = 8;

    ObjectFieldInfo(J9ROMClassPointer romClass) {
        this.romClass = romClass;
        this._superclassFieldsSize = -1;
        this._superclassBackfillOffset = -1;
        this._myBackfillOffset = -1;
        this._subclassBackfillOffset = -1;
        this._objectCanUseBackfill = fj9object_t_SizeOf == 4;
        this._instanceFieldBackfillEligible = false;
    }

    int getTotalDoubleCount() {
        return this._totalDoubleCount;
    }

    int getTotalObjectCount() {
        return this._totalObjectCount;
    }

    int getTotalSingleCount() {
        return this._totalSingleCount;
    }

    int getNonBackfilledObjectCount() {
        int nonBackfilledObjects = this._totalObjectCount;
        if (this.isBackfillSuitableObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --nonBackfilledObjects;
        }
        return nonBackfilledObjects;
    }

    int getNonBackfilledSingleCount() {
        int nonBackfilledSingle = this._totalSingleCount;
        if (this.isBackfillSuitableSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --nonBackfilledSingle;
        }
        return nonBackfilledSingle;
    }

    int getNonBackfilledInstanceObjectCount() {
        int nonBackfilledObjects = this._instanceObjectCount;
        if (this.isBackfillSuitableInstanceObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --nonBackfilledObjects;
        }
        return nonBackfilledObjects;
    }

    int getNonBackfilledInstanceSingleCount() {
        int nonBackfilledSingle = this._instanceSingleCount;
        if (this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --nonBackfilledSingle;
        }
        return nonBackfilledSingle;
    }

    int getInstanceDoubleCount() {
        return this._instanceDoubleCount;
    }

    int getInstanceObjectCount() {
        return this._instanceObjectCount;
    }

    int getInstanceSingleCount() {
        return this._instanceSingleCount;
    }

    int getHiddenFieldCount() {
        return this._hiddenFieldCount;
    }

    boolean isBackfillSuitableSingleAvailable() {
        return 0 != this.getTotalSingleCount();
    }

    boolean isBackfillSuitableObjectAvailable() {
        return this._objectCanUseBackfill && 0 != this.getTotalObjectCount();
    }

    boolean isBackfillSuitableInstanceSingleAvailable() {
        return 0 != this.getInstanceSingleCount();
    }

    boolean isBackfillSuitableInstanceObjectAvailable() {
        return this._objectCanUseBackfill && 0 != this.getInstanceObjectCount();
    }

    boolean isBackfillSuitableFieldAvailable() {
        return this.isBackfillSuitableSingleAvailable() || this.isBackfillSuitableObjectAvailable();
    }

    UDATA getMyBackfillOffsetForHiddenField() {
        return new UDATA((long)this._myBackfillOffset + J9Object.SIZEOF);
    }

    int getSuperclassFieldsSize() {
        return this._superclassFieldsSize;
    }

    long getSuperclassObjectSize() {
        return (long)this._superclassFieldsSize + J9Object.SIZEOF;
    }

    void setSuperclassFieldsSize(int i) {
        this._superclassFieldsSize = i;
    }

    boolean isMyBackfillSlotAvailable() {
        return this._myBackfillOffset >= 0;
    }

    boolean isSuperclassBackfillSlotAvailable() {
        return this._superclassBackfillOffset >= 0;
    }

    int calculateFieldDataStart() {
        int fieldDataStart = this.getSuperclassFieldsSize();
        if (this.getSuperclassObjectSize() % 8L != 0L && (this._totalDoubleCount > 0 || !this._objectCanUseBackfill && this._totalObjectCount > 0)) {
            fieldDataStart += 4;
        }
        return fieldDataStart;
    }

    int addDoublesArea(int start) {
        return start + this._totalDoubleCount * 8;
    }

    int addObjectsArea(int start) {
        int nonBackfilledObjects = this.getNonBackfilledObjectCount();
        return start + nonBackfilledObjects * fj9object_t_SizeOf;
    }

    int getMyBackfillOffset() {
        return this._myBackfillOffset;
    }

    int getSubclassBackfillOffset() {
        return this._subclassBackfillOffset;
    }

    void setSuperclassBackfillOffset(int superclassBackfillOffset) {
        this._superclassBackfillOffset = superclassBackfillOffset;
    }

    int getSuperclassBackfillOffset() {
        return this._superclassBackfillOffset;
    }

    boolean isInstanceFieldBackfillEligible() {
        return this._instanceFieldBackfillEligible;
    }

    void countInstanceFields() throws CorruptDataException {
        J9ROMFieldShapeIterator fields = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
        for (J9ROMFieldShapePointer f : fields) {
            U32 modifiers = f.modifiers();
            if (modifiers.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                ++this._instanceObjectCount;
                ++this._totalObjectCount;
                continue;
            }
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this._instanceDoubleCount;
                ++this._totalDoubleCount;
                continue;
            }
            ++this._instanceSingleCount;
            ++this._totalSingleCount;
        }
        this._instanceFieldBackfillEligible = this._instanceSingleCount > 0 || this._objectCanUseBackfill && this._instanceSingleCount > 0;
    }

    int countAndCopyHiddenFields(LinkedList<HiddenInstanceField> hiddenFieldList, ArrayList<HiddenInstanceField> hiddenFieldArray) throws CorruptDataException {
        J9UTF8Pointer className = this.romClass.className();
        this._hiddenFieldCount = 0;
        for (HiddenInstanceField hiddenField : hiddenFieldList) {
            if (hiddenField.className() != null && !className.equals(hiddenField.className())) continue;
            U32 modifiers = hiddenField.shape().modifiers();
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                ++this._totalObjectCount;
            } else if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this._totalDoubleCount;
            } else {
                ++this._totalSingleCount;
            }
            hiddenFieldArray.add(hiddenField);
            ++this._hiddenFieldCount;
        }
        return this._hiddenFieldCount;
    }

    int calculateTotalFieldsSizeAndBackfill() {
        long accumulator = (long)this._superclassFieldsSize + (long)this._totalObjectCount * J9Object.SIZEOF + (long)(this._totalSingleCount * 4) + (long)(this._totalDoubleCount * 8);
        if (this.getSuperclassObjectSize() % 8L != 0L && (this._totalDoubleCount > 0 || !this._objectCanUseBackfill && this._totalObjectCount > 0)) {
            this._superclassBackfillOffset = this.getSuperclassFieldsSize();
            accumulator += 4L;
        }
        if (this.isSuperclassBackfillSlotAvailable() && this.isBackfillSuitableFieldAvailable()) {
            accumulator -= 4L;
            this._myBackfillOffset = this._superclassBackfillOffset;
            this._superclassBackfillOffset = -1;
        }
        if ((accumulator + J9Object.SIZEOF) % 8L != 0L) {
            this._subclassBackfillOffset = (int)accumulator;
            accumulator += 4L;
        } else {
            this._subclassBackfillOffset = this._superclassBackfillOffset;
        }
        return (int)accumulator;
    }

    static {
        LOCKWORD_SIZE = j9objectmonitor_t_SizeOf = J9BuildFlags.interp_smallMonitorSlot ? 4 : UDATA.SIZEOF;
        FINALIZE_LINK_SIZE = fj9object_t_SizeOf;
    }
}

