/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCScavengerForwardedHeader;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.types.UDATA;

class CheckObjectHeap
extends Check {
    CheckObjectHeap() {
    }

    @Override
    public void check() {
        try {
            GCHeapRegionIterator regions = GCHeapRegionIterator.from();
            boolean midScavenge = this._engine.isMidscavengeFlagSet();
            boolean isVLHGC = GCExtensions.isVLHGC();
            block2: while (regions.hasNext()) {
                GCHeapRegionDescriptor region = GCHeapRegionDescriptor.fromHeapRegionDescriptor(regions.next());
                boolean isRegionTypeNew = region.getTypeFlags().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW);
                GCObjectHeapIterator heapIterator = region.objectIterator(true, true);
                while (heapIterator.hasNext()) {
                    GCScavengerForwardedHeader scavengerForwardedHeader;
                    J9ObjectPointer object = heapIterator.peek();
                    if (midScavenge && (isVLHGC || isRegionTypeNew) && (scavengerForwardedHeader = GCScavengerForwardedHeader.fromJ9Object(object)).isForwardedPointer()) {
                        this._engine.reportForwardedObject(object, scavengerForwardedHeader.getForwardedObject());
                        UDATA objectSize = scavengerForwardedHeader.getObjectSize();
                        heapIterator.advance(objectSize);
                        this._engine.pushPreviousObject(object);
                        continue;
                    }
                    int result = this._engine.checkObjectHeap(object, region);
                    if (result != 0) continue block2;
                    heapIterator.next();
                    this._engine.pushPreviousObject(object);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "HEAP";
    }

    @Override
    public void print() {
    }
}

