/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuntimeSettingsCommand
extends Command {
    private static final Pattern p = Pattern.compile("(\\d+[KMG]).*");
    private static final String usageInfo = "Prints VM information that can change during runtime (e.g. initial and current softmx values).";
    private static final int PADDING = 4;

    public RuntimeSettingsCommand() {
        this.addCommand("runtimesettings", "", usageInfo);
    }

    private void printUsage(PrintStream out) {
        out.println("runtimesettings - Prints VM information that can change during runtime (e.g. initial and current softmx values).");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (0 < args.length) {
            out.println("!runtimesettings expects no args. Usage :");
            this.printUsage(out);
            return;
        }
        try {
            String qualifiedCurrentSoftmx = "";
            String initialSoftmx = "not set";
            J9RASPointer ras = DataType.getJ9RASPointer();
            J9JavaVMPointer vm = J9RASHelper.getVM(ras);
            IProcess process = vm.getProcess();
            J9DDRImageProcess ddrProcess = new J9DDRImageProcess(process);
            String cmdline = ddrProcess.getCommandLine();
            int start = cmdline.indexOf("-Xsoftmx");
            int length = "-Xsoftmx".length();
            int end = cmdline.indexOf(" ", start);
            if (-1 != start) {
                initialSoftmx = cmdline.substring(start + length, end);
                initialSoftmx = initialSoftmx.toUpperCase();
            }
            Long currentSoftmx = GCExtensions.softMx().longValue();
            qualifiedCurrentSoftmx = currentSoftmx.toString();
            Matcher m = p.matcher(initialSoftmx);
            if (m.matches()) {
                initialSoftmx = m.group(1);
                qualifiedCurrentSoftmx = this.qualifiedSize(currentSoftmx);
                m = p.matcher(qualifiedCurrentSoftmx);
                if (!m.matches()) {
                    initialSoftmx = this.sizeInBytes(initialSoftmx);
                }
            } else {
                qualifiedCurrentSoftmx = currentSoftmx.toString();
            }
            this.printTableOfEqualSpacedColumns(out, new String[]{"name", "initial value", "current value"}, new String[][]{{"-Xsoftmx", initialSoftmx, qualifiedCurrentSoftmx}});
        }
        catch (DataUnavailable e) {
            out.println("COMMANDLINE is not available\n");
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            throw new DDRInteractiveCommandException("CorruptDataException occured while getting the commandline from process");
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printTableOfEqualSpacedColumns(PrintStream out, String[] headings, String[][] values) {
        if (!this.isColumnNumbersValid(headings, values)) {
            out.println("Warning: the number of headers do not match the number of values");
            assert (false);
        } else {
            int max = this.getLongestStringLength(headings);
            for (int i = 0; i < values.length; ++i) {
                max = this.max(max, this.getLongestStringLength(values[i]));
            }
            this.printTableDivider(out, headings.length, max += 4);
            this.printTableRows(out, max, headings);
            this.printTableDivider(out, headings.length, max);
            for (String[] strings : values) {
                this.printTableRows(out, max, strings);
                this.printTableDivider(out, headings.length, max);
            }
        }
    }

    private boolean isColumnNumbersValid(String[] headings, String[][] values) {
        for (int i = 0; i < values.length; ++i) {
            if (headings.length == values[i].length) continue;
            return false;
        }
        return true;
    }

    private void printTableRows(PrintStream out, int cellSize, String[] values) {
        for (int j = 0; j != values.length; ++j) {
            int i;
            out.print('|');
            int padding = (cellSize - values[j].length()) / 2;
            for (i = 0; i != padding; ++i) {
                out.print(' ');
            }
            out.print(values[j]);
            for (i = 0; i != padding; ++i) {
                out.print(' ');
            }
            if (0 != values[j].length() % 2) continue;
            out.print(' ');
        }
        out.print("|\n");
    }

    private void printTableDivider(PrintStream out, int numColumns, int cellSize) {
        for (int j = 0; j != numColumns; ++j) {
            out.print('+');
            for (int i = 0; i != cellSize; ++i) {
                out.print('-');
            }
        }
        out.print("+\n");
    }

    private int max(int i, int j) {
        if (i > j) {
            return i;
        }
        return j;
    }

    private int getLongestStringLength(String[] values) {
        String str = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i].length() <= str.length()) continue;
            str = values[i];
        }
        return str.length();
    }

    private String sizeInBytes(String qSize) {
        Long number = Long.valueOf(qSize.substring(0, qSize.length() - 1));
        if (qSize.endsWith("K")) {
            number = number * 1024L;
        } else if (qSize.endsWith("M")) {
            number = number * 1024L * 1024L;
        } else if (qSize.endsWith("G")) {
            number = number * 1024L * 1024L * 1024L;
        } else assert (false);
        return number.toString();
    }

    private String qualifiedSize(Long size) {
        String suffix = "";
        if (0L == size % 1024L) {
            size = size / 1024L;
            suffix = "K";
            if (0L < size && 0L == size % 1024L) {
                size = size / 1024L;
                suffix = "M";
                if (0L < size && 0L == size % 1024L) {
                    size = size / 1024L;
                    suffix = "G";
                }
            }
        }
        return size + suffix;
    }
}

