/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.BCNames;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29.j9.OptInfo;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTable;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTableIterator;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9EnclosingObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9LineNumberPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodParameterPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodParametersDataPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantDynamicRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodHandleRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodTypeRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMRecordComponentShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SourceDebugExtensionPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodDebugInfoHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9EnclosingObject;
import com.ibm.j9ddr.vm29.structure.J9ExceptionHandler;
import com.ibm.j9ddr.vm29.structure.J9ExceptionInfo;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9MethodDebugInfo;
import com.ibm.j9ddr.vm29.structure.J9NonbuilderConstants;
import com.ibm.j9ddr.vm29.structure.J9ROMClass;
import com.ibm.j9ddr.vm29.structure.J9ROMConstantPoolItem;
import com.ibm.j9ddr.vm29.structure.J9ROMRecordComponentShape;
import com.ibm.j9ddr.vm29.structure.J9RecordComponentFlags;
import com.ibm.j9ddr.vm29.structure.J9SourceDebugExtension;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ClassWalker;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.nio.ByteOrder;

public class RomClassWalker
extends ClassWalker {
    private final J9ROMClassPointer romClass;
    private final Context context;
    public static final int CFR_STACKMAP_TYPE_OBJECT = 7;
    public static final int CFR_STACKMAP_SAME = 0;
    public static final int CFR_STACKMAP_SAME_LOCALS_1_STACK = 64;
    public static final int CFR_STACKMAP_SAME_LOCALS_1_STACK_END = 128;
    public static final int CFR_STACKMAP_SAME_LOCALS_1_STACK_EXTENDED = 247;
    public static final int CFR_STACKMAP_SAME_EXTENDED = 251;
    public static final int CFR_STACKMAP_APPEND_BASE = 251;
    public static final int CFR_STACKMAP_FULL = 255;

    public RomClassWalker(StructurePointer clazz, Context context) {
        this.clazz = clazz;
        this.context = context;
        this.romClass = clazz instanceof J9ROMClassPointer ? (J9ROMClassPointer)clazz : J9ROMClassPointer.NULL;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void allSlotsInObjectDo(IClassWalkCallbacks classWalker) throws CorruptDataException {
        this.classWalkerCallback = classWalker;
        if (null == this.romClass) {
            throw new CorruptDataException("The StructurePointer clazz is not an instance of J9ClassPointer");
        }
        this.classWalkerCallback = classWalker;
        this.allSlotsInROMHeaderDo();
        this.allSlotsInConstantPoolDo();
        this.allSlotsInROMMethodsSectionDo();
        this.allSlotsInROMFieldsSectionDo();
        this.allSlotsInCPShapeDescriptionDo();
        this.allSlotsInOptionalInfoDo();
        this.allSlotsInVarHandleMethodTypeLookupTableDo();
        this.allSlotsInStaticSplitMethodRefIndexesDo();
        this.allSlotsInSpecialSplitMethodRefIndexesDo();
    }

    private void allSlotsInROMHeaderDo() throws CorruptDataException {
        this.classWalkerCallback.addSection(this.clazz, this.clazz, J9ROMClass.SIZEOF, "romHeader", true);
        if (J9ROMClassHelper.isArray(this.romClass)) {
            this.addObjectsasSlot(J9ROMArrayClassPointer.cast(this.romClass));
            return;
        }
        this.addObjectsasSlot(this.romClass);
        SelfRelativePointer srpCursor = this.romClass.interfaces();
        long count = this.romClass.interfaceCount().longValue();
        this.classWalkerCallback.addSection(this.clazz, srpCursor, count * 4L, "interfacesSRPs", true);
        int i22 = 0;
        while ((long)i22 < count) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, srpCursor, "interfaceUTF8");
            srpCursor = srpCursor.add(1L);
            ++i22;
        }
        srpCursor = this.romClass.innerClasses();
        this.classWalkerCallback.addSection(this.clazz, srpCursor, count * 4L, "innerClassesSRPs", true);
        for (count = (long)this.romClass.innerClassCount().intValue(); 0L != count; --count) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, srpCursor, "innerClassNameUTF8");
            srpCursor = srpCursor.add(1L);
        }
        try {
            srpCursor = this.romClass.enclosedInnerClasses();
            this.classWalkerCallback.addSection(this.clazz, srpCursor, count * 4L, "enclosedInnerClassesSRPs", true);
            for (count = (long)this.romClass.enclosedInnerClassCount().intValue(); 0L != count; --count) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, srpCursor, "enclosedInnerClassesNameUTF8");
                srpCursor = srpCursor.add(1L);
            }
        }
        catch (NoSuchFieldException i22) {
            // empty catch block
        }
        J9ROMMethodPointer firstMethod = this.romClass.romMethods();
        long size = firstMethod.getAddress() - srpCursor.getAddress();
        this.classWalkerCallback.addSection(this.clazz, srpCursor, size, "cpNamesAndSignaturesSRPs", true);
    }

    private void allSlotsInROMMethodsSectionDo() throws CorruptDataException {
        J9ROMMethodPointer firstMethod;
        J9ROMMethodPointer methodCursor = firstMethod = this.romClass.romMethods();
        for (int count = this.romClass.romMethodCount().intValue(); count > 0 && methodCursor.notNull(); --count) {
            J9ROMMethodPointer nextMethod = this.allSlotsInROMMethodDo(methodCursor);
            this.classWalkerCallback.addSection(this.clazz, methodCursor, nextMethod.getAddress() - methodCursor.getAddress(), "method", true);
            methodCursor = nextMethod;
        }
        this.classWalkerCallback.addSection(this.clazz, firstMethod, methodCursor.getAddress() - firstMethod.getAddress(), "methods", true);
    }

    private void allSlotsInROMFieldsSectionDo() throws CorruptDataException {
        J9ROMFieldShapePointer currentField;
        int fieldLength;
        J9ROMFieldShapeIterator iterator = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
        int size = 0;
        while (iterator.hasNext() && 0 != (fieldLength = this.allSlotsInROMFieldDo(currentField = (J9ROMFieldShapePointer)iterator.next()))) {
            size += fieldLength;
        }
        this.classWalkerCallback.addSection(this.clazz, this.romClass.romFields(), size, "fields", true);
    }

    private J9ROMMethodPointer allSlotsInROMMethodDo(J9ROMMethodPointer method) throws CorruptDataException {
        this.addObjectsasSlot(method);
        U32Pointer cursor = ROMHelp.J9_EXTENDED_MODIFIERS_ADDR_FROM_ROM_METHOD(method);
        this.allSlotsInBytecodesDo(method);
        if (J9ROMMethodHelper.hasExtendedModifiers(method)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, cursor, "extendedModifiers");
            cursor = cursor.add(1L);
        }
        if (J9ROMMethodHelper.hasGenericSignature(method)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, cursor, "methodUTF8");
            cursor = cursor.add(1L);
        }
        if (J9ROMMethodHelper.hasExceptionInfo(method)) {
            J9ExceptionInfoPointer exceptionInfo = J9ExceptionInfoPointer.cast(cursor);
            long exceptionInfoSize = J9ExceptionInfo.SIZEOF + exceptionInfo.catchCount().longValue() * J9ExceptionHandler.SIZEOF + exceptionInfo.throwCount().longValue() * 4L;
            this.allSlotsInExceptionInfoDo(exceptionInfo);
            cursor = cursor.addOffset(exceptionInfoSize);
        }
        if (J9ROMMethodHelper.hasMethodAnnotations(method)) {
            cursor = cursor.add(this.allSlotsInAnnotationDo(cursor, "methodAnnotation"));
        }
        if (J9ROMMethodHelper.hasParameterAnnotations(method)) {
            cursor = cursor.add(this.allSlotsInAnnotationDo(cursor, "parameterAnnotations"));
        }
        if (J9ROMMethodHelper.hasMethodTypeAnnotations(method)) {
            cursor = cursor.add(this.allSlotsInAnnotationDo(cursor, "method typeAnnotations"));
        }
        if (J9ROMMethodHelper.hasCodeTypeAnnotations(method)) {
            cursor = cursor.add(this.allSlotsInAnnotationDo(cursor, "code typeAnnotations"));
        }
        if (J9ROMMethodHelper.hasDefaultAnnotation(method)) {
            cursor = cursor.add(this.allSlotsInAnnotationDo(cursor, "defaultAnnotation"));
        }
        if (J9ROMMethodHelper.hasDebugInfo(method)) {
            cursor = cursor.add(this.allSlotsInMethodDebugInfoDo(cursor));
        }
        if (J9ROMMethodHelper.hasStackMap(method)) {
            long stackMapSize = cursor.at(0L).longValue();
            U8Pointer stackMap = U8Pointer.cast(cursor.add(1L));
            this.classWalkerCallback.addSection(this.clazz, cursor, stackMapSize, "stackMap", true);
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, cursor, "stackMapSize");
            this.allSlotsInStackMapDo(stackMap);
            cursor = cursor.addOffset(stackMapSize);
        }
        if (J9ROMMethodHelper.hasMethodParameters(method)) {
            cursor = cursor.add(this.allSlotsInMethodParametersDataDo(cursor));
        }
        return J9ROMMethodPointer.cast(cursor);
    }

    private long allSlotsInMethodParametersDataDo(U32Pointer cursor) throws CorruptDataException {
        J9MethodParametersDataPointer methodParametersData = J9MethodParametersDataPointer.cast(cursor);
        J9MethodParameterPointer parameters = methodParametersData.parameters();
        long methodParametersSize = ROMHelp.J9_METHOD_PARAMS_SIZE_FROM_NUMBER_OF_PARAMS(methodParametersData.parameterCount().longValue());
        long padding = 4L - methodParametersSize % 4L;
        if (padding == 4L) {
            padding = 0L;
        }
        long size = methodParametersSize + padding;
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, methodParametersData.parameterCountEA(), "parameterCount");
        int i = 0;
        while ((long)i < methodParametersData.parameterCount().longValue()) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, parameters.nameEA(), "methodParameterName");
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, parameters.flagsEA(), "methodParameterFlag");
            ++i;
        }
        cursor = cursor.addOffset(methodParametersSize);
        while (padding > 0L) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, cursor, "MethodParameters padding");
            cursor.addOffset(1L);
            --padding;
        }
        this.classWalkerCallback.addSection(this.clazz, methodParametersData, size, "Method Parameters", true);
        return size / 4L;
    }

    private int allSlotsInROMFieldDo(J9ROMFieldShapePointer field) throws CorruptDataException {
        J9ROMNameAndSignaturePointer fieldNAS = field.nameAndSignature();
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, fieldNAS.nameEA(), "name");
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, fieldNAS.signatureEA(), "signature");
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, field.modifiersEA(), "modifiers");
        UDATA modifiers = field.modifiers();
        U32Pointer initialValue = U32Pointer.cast(field.add(1L));
        if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagConstant)) {
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(initialValue), "fieldInitialValue");
                initialValue = initialValue.add(2L);
            } else {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I32, initialValue, "fieldInitialValue");
                initialValue = initialValue.add(1L);
            }
        }
        if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagHasGenericSignature)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, initialValue, "fieldGenSigUTF8");
            initialValue = initialValue.add(1L);
        }
        if (modifiers.allBitsIn(J9FieldFlags.J9FieldFlagHasFieldAnnotations)) {
            initialValue = initialValue.add(this.allSlotsInAnnotationDo(initialValue, "fieldAnnotation"));
        }
        int fieldLength = (int)(initialValue.getAddress() - field.getAddress());
        this.classWalkerCallback.addSection(this.clazz, field, fieldLength, "field", true);
        return fieldLength;
    }

    void allSlotsInExceptionInfoDo(J9ExceptionInfoPointer exceptionInfo) throws CorruptDataException {
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, exceptionInfo.catchCountEA(), "catchCount");
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, exceptionInfo.throwCountEA(), "throwCount");
        J9ExceptionHandlerPointer exceptionHandler = ROMHelp.J9EXCEPTIONINFO_HANDLERS(exceptionInfo);
        int i = 0;
        while ((long)i < exceptionInfo.catchCount().longValue()) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, exceptionHandler.startPCEA(), "startPC");
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, exceptionHandler.endPCEA(), "endPC");
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, exceptionHandler.handlerPCEA(), "handlerPC");
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, exceptionHandler.exceptionClassIndexEA(), "exceptionClassIndex");
            exceptionHandler = exceptionHandler.add(1L);
            ++i;
        }
        SelfRelativePointer throwNames = SelfRelativePointer.cast(exceptionHandler);
        int i2 = 0;
        while (i2 < exceptionInfo.throwCount().intValue()) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, throwNames, "throwNameUTF8");
            ++i2;
            throwNames = throwNames.add(1L);
        }
    }

    private void allSlotsInBytecodesDo(J9ROMMethodPointer method) throws CorruptDataException {
        U8Pointer bytecodes;
        long length = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(method).longValue();
        if (length == 0L) {
            return;
        }
        U8Pointer pc = bytecodes = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(method);
        while (pc.getAddress() - bytecodes.getAddress() < length) {
            long i;
            int bc = pc.at(0L).intValue();
            try {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, BCNames.getName(bc));
            }
            catch (Exception exception) {
                // empty catch block
            }
            pc = pc.add(1L);
            if (bc == 16 || bc == 18 || bc == 21 || bc == 22 || bc == 23 || bc == 24 || bc == 25 || bc == 54 || bc == 55 || bc == 56 || bc == 57 || bc == 58 || bc == 188) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcArg8");
                pc = pc.add(1L);
                continue;
            }
            if (bc == BCNames.JBinvokeinterface2) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcArg8");
                pc = pc.add(1L);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcArg8");
                pc = pc.add(1L);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, pc, "bcArg16");
                pc = pc.add(2L);
                continue;
            }
            if (bc == 17 || bc == 19 || bc == BCNames.JBldc2dw || bc == 20 || bc == BCNames.JBiloadw || bc == BCNames.JBlloadw || bc == BCNames.JBfloadw || bc == BCNames.JBdloadw || bc == BCNames.JBaloadw || bc == BCNames.JBistorew || bc == BCNames.JBlstorew || bc == BCNames.JBfstorew || bc == BCNames.JBdstorew || bc == BCNames.JBastorew || bc == 153 || bc == 154 || bc == 155 || bc == 156 || bc == 157 || bc == 158 || bc == 159 || bc == 160 || bc == 161 || bc == 162 || bc == 163 || bc == 164 || bc == 165 || bc == 166 || bc == 167 || bc == 198 || bc == 199 || bc == 178 || bc == 179 || bc == 180 || bc == 181 || bc == 182 || bc == 183 || bc == 184 || bc == BCNames.JBinvokehandle || bc == BCNames.JBinvokehandlegeneric || bc == 186 || bc == 185 || bc == 187 || bc == BCNames.JBnewdup || bc == 189 || bc == 192 || bc == 193 || bc == BCNames.JBinvokestaticsplit || bc == BCNames.JBinvokespecialsplit) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, pc, "bcArg16");
                pc = pc.add(2L);
                continue;
            }
            if (bc == 132) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcArg8");
                pc = pc.add(1L);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcArg8");
                pc = pc.add(1L);
                continue;
            }
            if (bc == BCNames.JBiincw) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, pc, "bcArg16");
                pc = pc.add(2L);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, pc, "bcArg16");
                pc = pc.add(2L);
                continue;
            }
            if (bc == 197) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, pc, "bcArg16");
                pc = pc.add(2L);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcArg8");
                pc = pc.add(1L);
                continue;
            }
            if (bc == 200) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, pc, "bcArg32");
                pc = pc.add(4L);
                continue;
            }
            if (bc == 170) {
                int delta = (int)(pc.getAddress() - bytecodes.getAddress() - 1L);
                switch (delta % 4) {
                    case 0: {
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcPad");
                        pc = pc.add(1L);
                    }
                    case 1: {
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcPad");
                        pc = pc.add(1L);
                    }
                    case 2: {
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcPad");
                        pc = pc.add(1L);
                    }
                }
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, pc, "bcArg32");
                pc = pc.add(4L);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, pc, "bcArg32");
                I32 low = I32Pointer.cast(pc).at(0L);
                pc = pc.add(4L);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, pc, "bcArg32");
                I32 high = I32Pointer.cast(pc).at(0L);
                pc = pc.add(4L);
                for (i = 0L; i <= high.sub(low).longValue(); ++i) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, pc, "bcArg32");
                    pc = pc.add(4L);
                }
                continue;
            }
            if (bc != 171) continue;
            int delta2 = (int)(pc.getAddress() - bytecodes.getAddress() - 1L);
            switch (delta2 % 4) {
                case 0: {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcArg8");
                    pc = pc.add(1L);
                }
                case 1: {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcArg8");
                    pc = pc.add(1L);
                }
                case 2: {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcArg8");
                    pc = pc.add(1L);
                }
            }
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, pc, "bcArg32");
            pc = pc.add(4L);
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, pc, "bcArg32");
            i = U32Pointer.cast(pc).at(0L).longValue();
            pc = pc.add(4L);
            while (i-- > 0L) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, pc, "bcArg32");
                pc = pc.add(4L);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, pc, "bcArg32");
                pc = pc.add(4L);
            }
        }
        long roundedLength = ROMHelp.J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(method).longValue();
        while (length++ < roundedLength) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, pc, "bcSectionPadding");
            pc = pc.add(1L);
        }
        this.classWalkerCallback.addSection(this.clazz, bytecodes, pc.getAddress() - bytecodes.getAddress(), "methodBytecodes", true);
    }

    void allSlotsInCPShapeDescriptionDo() throws CorruptDataException {
        U32Pointer cpShapeDescription = J9ROMClassHelper.cpShapeDescription(this.romClass);
        int romConstantPoolCount = this.romClass.romConstantPoolCount().intValue();
        int count = (romConstantPoolCount + 8 - 1) / 8;
        this.classWalkerCallback.addSection(this.clazz, cpShapeDescription, count * 4, "cpShapeDescription", true);
        for (int i = 0; i < count; ++i) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, cpShapeDescription.add(i), "cpShapeDescriptionU32");
        }
    }

    private void allSlotsInConstantPoolDo() throws CorruptDataException {
        J9ROMConstantPoolItemPointer constantPool = J9ROMClassHelper.constantPool(this.romClass);
        U32Pointer cpShapeDescription = J9ROMClassHelper.cpShapeDescription(this.romClass);
        if (cpShapeDescription.isNull()) {
            return;
        }
        int constPoolCount = this.romClass.romConstantPoolCount().intValue();
        PointerPointer cpEntry = PointerPointer.cast(J9ROMClassHelper.constantPool(this.romClass));
        this.classWalkerCallback.addSection(this.clazz, constantPool, constPoolCount * 8, "constantPool              ", true);
        for (int index = 0; index < constPoolCount; ++index) {
            StructurePointer ref;
            long shapeDesc = ConstantPoolHelpers.J9_CP_TYPE(cpShapeDescription, index);
            if (shapeDesc == J9ConstantPool.J9CPTYPE_CLASS) {
                ref = J9ROMStringRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, ((J9ROMStringRefPointer)ref).utf8DataEA(), "cpFieldUtf8");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMStringRefPointer)ref).cpTypeEA(), "cpFieldType");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_STRING || shapeDesc == J9ConstantPool.J9CPTYPE_ANNOTATION_UTF8) {
                ref = J9ROMStringRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, ((J9ROMStringRefPointer)ref).utf8DataEA(), "cpFieldUtf8");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMStringRefPointer)ref).cpTypeEA(), "cpFieldType");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_INT) {
                ref = J9ROMConstantPoolItemPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMConstantPoolItemPointer)ref).slot1EA(), "cpFieldInt");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMConstantPoolItemPointer)ref).slot2EA(), "cpFieldIntUnused");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_FLOAT) {
                ref = J9ROMConstantPoolItemPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMConstantPoolItemPointer)ref).slot1EA(), "cpFieldFloat");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMConstantPoolItemPointer)ref).slot2EA(), "cpFieldFloatUnused");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_LONG) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(cpEntry), "cpField8");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_DOUBLE) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(cpEntry), "cpField8");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_FIELD) {
                ref = J9ROMFieldRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRPNAS, ((J9ROMFieldRefPointer)ref).nameAndSignatureEA(), "cpFieldNAS");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMFieldRefPointer)ref).classRefCPIndexEA(), "cpFieldClassRef");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_HANDLE_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_STATIC_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_INSTANCE_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_INTERFACE_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_INTERFACE_INSTANCE_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_INTERFACE_STATIC_METHOD) {
                ref = J9ROMMethodRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRPNAS, ((J9ROMMethodRefPointer)ref).nameAndSignatureEA(), "cpFieldNAS");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMMethodRefPointer)ref).classRefCPIndexEA(), "cpFieldClassRef");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_METHOD_TYPE) {
                ref = J9ROMMethodTypeRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, ((J9ROMMethodTypeRefPointer)ref).signatureEA(), "signature");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMMethodTypeRefPointer)ref).cpTypeEA(), "cpType");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_METHODHANDLE) {
                ref = J9ROMMethodHandleRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMMethodHandleRefPointer)ref).methodOrFieldRefIndexEA(), "methodOrFieldRefIndex");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMMethodHandleRefPointer)ref).handleTypeAndCpTypeEA(), "handleTypeAndCpType");
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_CONSTANT_DYNAMIC) {
                try {
                    ref = J9ROMConstantDynamicRefPointer.cast(cpEntry);
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRPNAS, ((J9ROMConstantDynamicRefPointer)ref).nameAndSignatureEA(), "cpFieldNAS");
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, ((J9ROMConstantDynamicRefPointer)ref).bsmIndexAndCpTypeEA(), "cpFieldBSMIndexAndCpType");
                }
                catch (NoClassDefFoundError | NoSuchFieldException e) {
                    throw new CorruptDataException(e);
                }
            } else if (shapeDesc == J9ConstantPool.J9CPTYPE_UNUSED || shapeDesc == J9ConstantPool.J9CPTYPE_UNUSED8) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(cpEntry), "cpFieldUnused");
            } else {
                throw new CorruptDataException("Unknown CP entry type: " + shapeDesc);
            }
            cpEntry = cpEntry.addOffset(J9ROMConstantPoolItem.SIZEOF);
        }
    }

    void allSlotsInOptionalInfoDo() throws CorruptDataException {
        U32Pointer optionalInfo = J9ROMClassHelper.optionalInfo(this.romClass);
        SelfRelativePointer cursor = SelfRelativePointer.cast(optionalInfo);
        if (this.romClass.optionalFlags().anyBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_SOURCE_FILE_NAME)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, cursor, "optionalFileNameUTF8");
            cursor = cursor.add(1L);
        }
        if (this.romClass.optionalFlags().anyBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_GENERIC_SIGNATURE)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, cursor, "optionalGenSigUTF8");
            cursor = cursor.add(1L);
        }
        if (this.romClass.optionalFlags().anyBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_SOURCE_DEBUG_EXTENSION)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, cursor, "optionalSourceDebugExtSRP");
            this.allSlotsInSourceDebugExtensionDo(J9SourceDebugExtensionPointer.cast(cursor.get()));
            cursor = cursor.add(1L);
        }
        if (this.romClass.optionalFlags().anyBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_ENCLOSING_METHOD)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, cursor, "optionalEnclosingMethodSRP");
            this.allSlotsInEnclosingObjectDo(J9EnclosingObjectPointer.cast(cursor.get()));
            cursor = cursor.add(1L);
        }
        if (this.romClass.optionalFlags().anyBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_SIMPLE_NAME)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, cursor, "optionalSimpleNameUTF8");
            cursor = cursor.add(1L);
        }
        if (this.romClass.optionalFlags().allBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_VERIFY_EXCLUDE)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, cursor, "optionalVerifyExclude");
            cursor = cursor.add(1L);
        }
        if (this.romClass.optionalFlags().allBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_CLASS_ANNOTATION_INFO)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, cursor, "classAnnotationsSRP");
            this.allSlotsInAnnotationDo(U32Pointer.cast(cursor.get()), "classAnnotations");
            cursor = cursor.add(1L);
        }
        if (this.romClass.optionalFlags().allBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_RECORD_ATTRIBUTE)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, cursor, "recordAttributeSRP");
            this.recordAttributeDo(U32Pointer.cast(cursor.get()));
            cursor = cursor.add(1L);
        }
        if (this.romClass.optionalFlags().allBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_PERMITTEDSUBCLASSES_ATTRIBUTE)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, cursor, "permittedSubclassesAttributeSRP");
            this.permittedSubclassAttributeDo(U32Pointer.cast(cursor.get()));
            cursor = cursor.add(1L);
        }
        if (ValueTypeHelper.getValueTypeHelper().areValueTypesSupported()) {
            if (this.romClass.optionalFlags().allBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_INJECTED_INTERFACE_INFO)) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, cursor, "optionalInjectedInterfaces");
                cursor = cursor.add(1L);
            }
            if (J9ROMClassHelper.hasLoadableDescriptorsAttribute(this.romClass)) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, cursor, "loadableDescriptorsAttributeSRP");
                this.loadableDescriptorsAttributeDo(U32Pointer.cast(cursor.get()));
                cursor = cursor.add(1L);
            }
        }
        if (J9ROMClassHelper.hasImplicitCreationAttribute(this.romClass)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, cursor, "implicitCreationAttributeSRP");
            this.implicitCreationAttributeDo(U32Pointer.cast(cursor.get()));
            cursor = cursor.add(1L);
        }
        this.classWalkerCallback.addSection(this.clazz, optionalInfo, cursor.getAddress() - optionalInfo.getAddress(), "optionalInfo", true);
    }

    void allSlotsInIntermediateClassDataDo() throws CorruptDataException {
        UDATA count = this.romClass.intermediateClassDataLength();
        if (count.gt(0)) {
            U8Pointer cursor = this.romClass.intermediateClassData();
            String j9xHelp = "!j9x " + cursor.getHexAddress() + "," + count.getHexValue();
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_IntermediateClassData, cursor, "intermediateClassData", j9xHelp);
            this.classWalkerCallback.addSection(this.clazz, cursor, count.longValue(), "intermediateClassDataSection", true);
        }
    }

    void allSlotsInVarHandleMethodTypeLookupTableDo() throws CorruptDataException {
        if (J9BuildFlags.J9VM_OPT_METHOD_HANDLE && !J9BuildFlags.J9VM_OPT_OPENJDK_METHODHANDLE) {
            try {
                int count = this.romClass.varHandleMethodTypeCount().intValue();
                if (count > 0) {
                    SelfRelativePointer cursorVoidEA = this.romClass.varHandleMethodTypeLookupTableEA();
                    VoidPointer cursorVoid = SelfRelativePointer.cast(cursorVoidEA).get();
                    U16Pointer cursor = U16Pointer.cast(cursorVoid);
                    this.classWalkerCallback.addSection(this.clazz, cursor, count * 2, "varHandleMethodTypeLookupTable", true);
                    for (int i = 0; i < count; ++i) {
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor.add(i), "cpIndex");
                    }
                }
            }
            catch (NoSuchFieldException e) {
                throw new CorruptDataException(e);
            }
        }
    }

    void allSlotsInStaticSplitMethodRefIndexesDo() throws CorruptDataException {
        int count = this.romClass.staticSplitMethodRefCount().intValue();
        U16Pointer cursor = this.romClass.staticSplitMethodRefIndexes();
        if (count > 0) {
            this.classWalkerCallback.addSection(this.clazz, cursor, count * 2, "staticSplitMethodRefIndexes", true);
            for (int i = 0; i < count; ++i) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor.add(i), "cpIndex");
            }
        }
    }

    void allSlotsInSpecialSplitMethodRefIndexesDo() throws CorruptDataException {
        int count = this.romClass.specialSplitMethodRefCount().intValue();
        U16Pointer cursor = this.romClass.specialSplitMethodRefIndexes();
        if (count > 0) {
            this.classWalkerCallback.addSection(this.clazz, cursor, count * 2, "specialSplitMethodRefIndexes", true);
            for (int i = 0; i < count; ++i) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor.add(i), "cpIndex");
            }
        }
    }

    private long allSlotsInStackMapFramesDo(U8Pointer cursor, long frameCount) throws CorruptDataException {
        U8Pointer cursorStart = U8Pointer.NULL;
        while (frameCount > 0L) {
            if (cursorStart.isNull()) {
                cursorStart = cursor;
            }
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, cursor, "stackMapFrameType");
            long frameType = cursor.at(0L).longValue();
            cursor = cursor.add(1L);
            if (64L <= frameType) {
                int length;
                if (128L > frameType) {
                    length = this.allSlotsInVerificationTypeInfoDo(cursor);
                    if (0 == length) {
                        return cursor.getAddress() - cursorStart.getAddress();
                    }
                    cursor = cursor.add(length);
                } else if (247L <= frameType) {
                    long count;
                    if (247L == frameType) {
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor, "stackMapFrameOffset");
                        cursor = cursor.add(2L);
                        length = this.allSlotsInVerificationTypeInfoDo(cursor);
                        if (0 == length) {
                            return cursor.getAddress() - cursorStart.getAddress();
                        }
                        cursor = cursor.add(length);
                    } else if (251L >= frameType) {
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor, "stackMapFrameOffset");
                        cursor = cursor.add(2L);
                    } else if (255L > frameType) {
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor, "stackMapFrameOffset");
                        cursor = cursor.add(2L);
                        for (count = frameType - 251L; count > 0L; --count) {
                            length = this.allSlotsInVerificationTypeInfoDo(cursor);
                            if (0 == length) {
                                return cursor.getAddress() - cursorStart.getAddress();
                            }
                            cursor = cursor.add(length);
                        }
                    } else if (255L == frameType) {
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor, "stackMapFrameOffset");
                        cursor = cursor.add(2L);
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor, "stackMapFrameLocalsCount");
                        count = U16Pointer.cast(cursor).at(0L).longValue();
                        cursor = cursor.add(2L);
                        for (count = (long)this.SWAP2BE((short)count); count > 0L; --count) {
                            length = this.allSlotsInVerificationTypeInfoDo(cursor);
                            if (0 == length) {
                                return cursor.getAddress() - cursorStart.getAddress();
                            }
                            cursor = cursor.add(length);
                        }
                        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor, "stackMapFrameItemsCount");
                        count = U16Pointer.cast(cursor).at(0L).longValue();
                        cursor = cursor.add(2L);
                        for (count = (long)this.SWAP2BE((short)count); count > 0L; --count) {
                            length = this.allSlotsInVerificationTypeInfoDo(cursor);
                            if (0 == length) {
                                return cursor.getAddress() - cursorStart.getAddress();
                            }
                            cursor = cursor.add(length);
                        }
                    }
                }
            }
            --frameCount;
        }
        return cursor.getAddress() - cursorStart.getAddress();
    }

    private void allSlotsInStackMapDo(U8Pointer stackMap) throws CorruptDataException {
        U8Pointer cursor = stackMap;
        if (stackMap.isNull()) {
            return;
        }
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, U16Pointer.cast(cursor), "stackMapFrameCount");
        short frameCount = this.SWAP2BE(U16Pointer.cast(cursor).at(0L).shortValue());
        cursor = cursor.add(2L);
        this.allSlotsInStackMapFramesDo(cursor, frameCount);
    }

    int allSlotsInVerificationTypeInfoDo(U8Pointer cursor) throws CorruptDataException {
        try {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, cursor, "typeInfoTag");
            long type2 = cursor.at(0L).longValue();
            cursor = cursor.add(1L);
            if (type2 < 7L) {
                return 1;
            }
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, cursor, "typeInfoU16");
        }
        catch (MemoryFault e) {
            return 0;
        }
        return 3;
    }

    void recordAttributeDo(U32Pointer attribute) throws CorruptDataException {
        if (attribute.isNull()) {
            return;
        }
        U32Pointer attributeStart = attribute;
        int numRecordComponents = attribute.at(0L).intValue();
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, attribute, "numberRecordComponents");
        attribute = attribute.add(1L);
        for (int i = 0; i < numRecordComponents; ++i) {
            try {
                int increment;
                J9ROMRecordComponentShapePointer recordComponent = J9ROMRecordComponentShapePointer.cast(attribute);
                attribute = U32Pointer.cast(recordComponent.add(1L));
                J9ROMNameAndSignaturePointer recordComponentNAS = recordComponent.nameAndSignature();
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, recordComponentNAS.nameEA(), "name");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, recordComponentNAS.signatureEA(), "signature");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, recordComponent.attributeFlagsEA(), "attributeFlags");
                this.classWalkerCallback.addSection(this.clazz, recordComponent, J9ROMRecordComponentShape.SIZEOF, "recordComponentShape", true);
                UDATA attributeFlags = recordComponent.attributeFlags();
                if (attributeFlags.anyBitsIn(J9RecordComponentFlags.J9RecordComponentFlagHasGenericSignature)) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, attribute, "recordComponentGenSigUTF8");
                    attribute = attribute.add(1L);
                }
                if (attributeFlags.anyBitsIn(J9RecordComponentFlags.J9RecordComponentFlagHasAnnotations)) {
                    increment = this.allSlotsInAnnotationDo(attribute, "recordComponentAnnotation");
                    attribute = attribute.add(increment);
                }
                if (!attributeFlags.anyBitsIn(J9RecordComponentFlags.J9RecordComponentFlagHasTypeAnnotations)) continue;
                increment = this.allSlotsInAnnotationDo(attribute, "recordComponentTypeAnnotation");
                attribute = attribute.add(increment);
                continue;
            }
            catch (NoClassDefFoundError | NoSuchFieldException e) {
                throw new CorruptDataException(e);
            }
        }
        int recordComponentLength = (int)(attribute.getAddress() - attributeStart.getAddress());
        int padding = recordComponentLength % 4;
        if (0 != padding) {
            padding = 4 - padding;
        }
        U8Pointer attributeU8 = U8Pointer.cast(attribute);
        for (int i = 0; i < padding; ++i) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, attributeU8, "recordComponent padding");
            attributeU8 = attributeU8.add(1L);
        }
        this.classWalkerCallback.addSection(this.clazz, attributeStart, recordComponentLength + padding, "recordComponent", true);
    }

    void permittedSubclassAttributeDo(U32Pointer attribute) throws CorruptDataException {
        if (attribute.isNull()) {
            return;
        }
        U32Pointer attributeStart = attribute;
        int numPermittedSubclasses = attribute.at(0L).intValue();
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, attribute, "numberPermittedSubclasses");
        attribute = attribute.add(1L);
        for (int i = 0; i < numPermittedSubclasses; ++i) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, attribute, "permittedSubclassName");
            attribute = attribute.add(1L);
        }
        this.classWalkerCallback.addSection(this.clazz, attributeStart, attribute.getAddress() - attributeStart.getAddress(), "permittedSubclass", true);
    }

    void loadableDescriptorsAttributeDo(U32Pointer attribute) throws CorruptDataException {
        if (attribute.isNull()) {
            return;
        }
        U32Pointer attributeStart = attribute;
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, attribute, "numberLoadableDescriptors");
        int numLoadableDescriptors = attribute.at(0L).intValue();
        for (int i = 0; i < numLoadableDescriptors; ++i) {
            attribute = attribute.add(1L);
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, attribute, "loadableDescriptorName");
        }
        attribute = attribute.add(1L);
        this.classWalkerCallback.addSection(this.clazz, attributeStart, attribute.getAddress() - attributeStart.getAddress(), "loadableDescriptorsAttribute", true);
    }

    void implicitCreationAttributeDo(U32Pointer attribute) throws CorruptDataException {
        if (attribute.isNull()) {
            return;
        }
        U32Pointer attributeStart = attribute;
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, attribute, "implicitCreationFlags");
        attribute = attribute.add(1L);
        this.classWalkerCallback.addSection(this.clazz, attributeStart, attribute.getAddress() - attributeStart.getAddress(), "implicitCreationAttribute", true);
    }

    int allSlotsInAnnotationDo(U32Pointer annotation, String annotationSectionName) throws CorruptDataException {
        int count;
        int increment = 0;
        int annotationLength = annotation.at(0L).intValue();
        int padding = 4 - annotationLength % 4;
        increment = annotationLength / 4;
        if (4 == padding) {
            padding = 0;
        }
        if (padding > 0) {
            ++increment;
        }
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, annotation, "annotation length");
        U8Pointer cursor = U8Pointer.cast(annotation.add(1L));
        for (count = annotationLength; count > 0; --count) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, cursor, "annotation data");
            cursor = cursor.add(1L);
        }
        for (count = padding; count > 0; --count) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, cursor, "annotation padding");
            cursor = cursor.add(1L);
        }
        this.classWalkerCallback.addSection(this.clazz, annotation, ++increment * 4, annotationSectionName, true);
        return increment;
    }

    long allSlotsInMethodDebugInfoDo(U32Pointer cursor) throws CorruptDataException {
        U8Pointer variableTable;
        J9MethodDebugInfoPointer methodDebugInfo;
        boolean inlineDebugExtension;
        long inlineSize = 1L;
        long sectionSizeBytes = 0L;
        boolean bl = inlineDebugExtension = 1 == (cursor.at(0L).intValue() & 1);
        if (inlineDebugExtension) {
            methodDebugInfo = J9MethodDebugInfoPointer.cast(cursor);
            inlineSize = cursor.at(0L).intValue() / 4;
            sectionSizeBytes = inlineSize * 4L;
        } else {
            methodDebugInfo = J9MethodDebugInfoPointer.cast(SelfRelativePointer.cast(cursor).get());
            if (AlgorithmVersion.getVersionOf("VM_LINE_NUMBER_TABLE_VERSION").getAlgorithmVersion() < 1) {
                sectionSizeBytes = J9MethodDebugInfo.SIZEOF + (long)(J9MethodDebugInfoHelper.getLineNumberCount(methodDebugInfo).intValue() * 4);
            } else {
                sectionSizeBytes = J9MethodDebugInfo.SIZEOF + (long)J9MethodDebugInfoHelper.getLineNumberCompressedSize(methodDebugInfo).intValue();
                sectionSizeBytes = sectionSizeBytes + 2L - 1L & 0xFFFFFFFFFFFFFFFEL;
            }
        }
        if (!inlineDebugExtension && inlineSize == 1L) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, cursor, "SRP to DebugInfo");
            this.classWalkerCallback.addSection(this.clazz, cursor, inlineSize * 4L, "methodDebugInfo out of line", true);
        }
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRP, methodDebugInfo.srpToVarInfoEA(), "SizeOfDebugInfo(low tagged)");
        if (AlgorithmVersion.getVersionOf("VM_LINE_NUMBER_TABLE_VERSION").getAlgorithmVersion() < 1) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, methodDebugInfo.lineNumberCountEA(), "lineNumberCount");
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, methodDebugInfo.varInfoCountEA(), "varInfoCount");
            J9LineNumberPointer lineNumberPtr = J9MethodDebugInfoHelper.getLineNumberTableForROMClass(methodDebugInfo);
            if (lineNumberPtr.notNull()) {
                int j = 0;
                while (j < methodDebugInfo.lineNumberCount().intValue()) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U16, lineNumberPtr.lineNumberEA(), "lineNumber");
                    ++j;
                    lineNumberPtr = lineNumberPtr.add(1L);
                }
            }
        } else {
            U8Pointer currentLineNumberPtr;
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, methodDebugInfo.lineNumberCountEA(), "lineNumberCount(encoded)");
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, methodDebugInfo.varInfoCountEA(), "varInfoCount");
            if (methodDebugInfo.lineNumberCount().allBitsIn(1L)) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, U32Pointer.cast(methodDebugInfo.add(1L)), "compressed line number size");
            }
            if ((currentLineNumberPtr = J9MethodDebugInfoHelper.getCompressedLineNumberTableForROMClassV1(methodDebugInfo)).notNull()) {
                for (int j = 0; j < J9MethodDebugInfoHelper.getLineNumberCompressedSize(methodDebugInfo).intValue(); ++j) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, currentLineNumberPtr, "pc, lineNumber compressed");
                    currentLineNumberPtr = currentLineNumberPtr.add(1L);
                }
            }
        }
        if ((variableTable = OptInfo.getV1VariableTableForMethodDebugInfo(methodDebugInfo)).notNull()) {
            LocalVariableTableIterator variableInfoValuesIterator = LocalVariableTableIterator.localVariableTableIteratorFor(methodDebugInfo);
            U8Pointer start = variableInfoValuesIterator.getLocalVariableTablePtr();
            while (variableInfoValuesIterator.hasNext()) {
                LocalVariableTable values = (LocalVariableTable)variableInfoValuesIterator.next();
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, values.getNameSrp(), "name");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, values.getSignatureSrp(), "signature");
                if (!values.getGenericSignature().notNull()) continue;
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, values.getGenericSignatureSrp(), "genericSignature");
            }
            U8Pointer end = variableInfoValuesIterator.getLocalVariableTablePtr();
            int localVariableSectionSize = end.sub(start).intValue();
            for (int j = 0; j < localVariableSectionSize; ++j) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, start, "variableInfo compressed");
                start = start.add(1L);
            }
            this.classWalkerCallback.addSection(this.clazz, variableTable, localVariableSectionSize, "variableInfo" + (inlineDebugExtension ? " Inline" : ""), inlineDebugExtension);
        }
        this.classWalkerCallback.addSection(this.clazz, methodDebugInfo, sectionSizeBytes, "methodDebugInfo" + (inlineDebugExtension ? " Inline" : ""), inlineDebugExtension);
        return inlineSize;
    }

    void allSlotsInEnclosingObjectDo(J9EnclosingObjectPointer enclosingObject) throws CorruptDataException {
        if (enclosingObject.isNull()) {
            return;
        }
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, enclosingObject.classRefCPIndexEA(), "classRefCPIndex");
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_SRPNAS, enclosingObject.nameAndSignatureEA(), "nameAndSignature");
        this.classWalkerCallback.addSection(this.clazz, enclosingObject, J9EnclosingObject.SIZEOF, "enclosingObject", true);
        this.addObjectsasSlot(enclosingObject);
    }

    void allSlotsInSourceDebugExtensionDo(J9SourceDebugExtensionPointer sde) throws CorruptDataException {
        long i;
        if (sde.isNull()) {
            return;
        }
        this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U32, sde.sizeEA(), "optionalSourceDebugExtSize");
        long size = sde.size().longValue();
        long alignedSize = size + 4L - 1L & 0xFFFFFFFFFFFFFFFCL;
        U8Pointer data = U8Pointer.cast(sde.add(1L));
        for (i = 0L; i < size; ++i) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, data.add(i), "optionalSourceDebugExtData");
        }
        for (i = size; i < alignedSize; ++i) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, data.add(i), "optionalSourceDebugExtPadding");
        }
        this.classWalkerCallback.addSection(this.clazz, sde, J9SourceDebugExtension.SIZEOF + alignedSize, "optionalSourceDebugExt", true);
    }

    private short SWAP2BE(short in) {
        IProcess process = this.context.process;
        if (process.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return Short.reverseBytes(in);
        }
        return in;
    }
}

