/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.Pointer;
import com.ibm.j9ddr.vm27.types.I8;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

public class I8Pointer
extends Pointer {
    public static final int SIZEOF = 1;
    public static final I8Pointer NULL = new I8Pointer(0L);

    protected I8Pointer(long address) {
        super(address);
    }

    public static I8Pointer cast(AbstractPointer pointer) {
        return I8Pointer.cast(pointer.getAddress());
    }

    public static I8Pointer cast(UDATA udata) {
        return I8Pointer.cast(udata.longValue());
    }

    public static I8Pointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new I8Pointer(address);
    }

    @Override
    public I8 at(long index) throws CorruptDataException {
        return new I8(this.getByteAtOffset(index * 1L));
    }

    @Override
    public I8 at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    public I8Pointer untag() {
        return this.untag(0L);
    }

    @Override
    public I8Pointer untag(long mask) {
        return new I8Pointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public I8Pointer add(long count) {
        return new I8Pointer(this.address + 1L * count);
    }

    @Override
    public I8Pointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public I8Pointer addOffset(long offset) {
        return new I8Pointer(this.address + offset);
    }

    @Override
    public I8Pointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public I8Pointer sub(long count) {
        return new I8Pointer(this.address - 1L * count);
    }

    @Override
    public I8Pointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public I8Pointer subOffset(long offset) {
        return new I8Pointer(this.address - offset);
    }

    @Override
    public I8Pointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 1L;
    }
}

