/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class WeakValueMap<K, V> {
    private final Map<K, ReferenceType<K, V>> map = new HashMap<K, ReferenceType<K, V>>();
    private final ReferenceQueue<V> refQueue = new ReferenceQueue();

    public void put(K key, V value) {
        this.cleanupTax();
        this.map.put(key, new ReferenceType<K, V>(key, value, this.refQueue));
    }

    public V get(K key) {
        this.cleanupTax();
        ReferenceType<K, V> entry = this.map.get(key);
        if (entry != null) {
            return (V)entry.get();
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }

    private void cleanupTax() {
        ReferenceType queued = null;
        while ((queued = (ReferenceType)this.refQueue.poll()) != null) {
            this.map.remove(queued.key);
        }
    }

    private static class ReferenceType<K, V>
    extends SoftReference<V> {
        public final K key;

        public ReferenceType(K key, V value, ReferenceQueue<V> refQueue) {
            super(value, refQueue);
            this.key = key;
        }
    }
}

