/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFARM32DumpReader
extends ELFDumpReader {
    ELFARM32DumpReader(ELFFileReader reader) throws IOException, InvalidDumpFormatException {
        super(reader);
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readShort() & 0xFFFFL;
    }

    @Override
    protected String getProcessorType() {
        return "arm";
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        TreeMap<String, Number> registers = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator());
        for (int i = 0; i < 13; ++i) {
            registers.put("r" + i, (long)this._reader.readInt() & 0xFFFFFFFFL);
        }
        registers.put("sp", (long)this._reader.readInt() & 0xFFFFFFFFL);
        registers.put("lr", (long)this._reader.readInt() & 0xFFFFFFFFL);
        registers.put("pc", (long)this._reader.readInt() & 0xFFFFFFFFL);
        registers.put("spsr", (long)this._reader.readInt() & 0xFFFFFFFFL);
        return registers;
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "sp";
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> registers) {
        return this.getStackPointerFrom(registers);
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> registers) {
        return registers.get("pc").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> registers) {
        return registers.get("lr").longValue();
    }

    @Override
    protected void readHighwordRegisters(DataEntry entry, Map<String, Number> registers) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in ARM ELF dump");
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        String[] registersVals = new String[16];
        for (int i = 0; i < 13; ++i) {
            registersVals[i] = "r" + i;
        }
        registersVals[13] = "sp";
        registersVals[14] = "lr";
        registersVals[15] = "pc";
        registersVals[16] = "spsr";
        return registersVals;
    }
}

