/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.HelperBase;
import com.ibm.j9ddr.StructureReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;

final class StructureHelper
extends HelperBase {
    private final String className;
    private final ClassWriter clazz;
    private final MethodVisitor clinit;
    private final StructureReader.StructureDescriptor structure;

    static byte[] getClassBytes(StructureReader.StructureDescriptor structure, String className) {
        StructureHelper helper = new StructureHelper(structure, className);
        return helper.generate();
    }

    private StructureHelper(StructureReader.StructureDescriptor structure, String className) {
        this.className = className;
        this.clazz = new ClassWriter(0);
        this.clazz.visit(52, 49, className, null, "java/lang/Object", null);
        this.clinit = this.clazz.visitMethod(8, "<clinit>", voidMethod, null, null);
        this.clinit.visitCode();
        this.structure = structure;
    }

    private void defineField(String name, Type type2, long value) {
        String typeDescriptor = type2.getDescriptor();
        this.clazz.visitField(25, name, typeDescriptor, null, null).visitEnd();
        if (type2.getSort() == 5) {
            StructureHelper.loadInt(this.clinit, (int)value);
        } else {
            StructureHelper.loadLong(this.clinit, value);
        }
        this.clinit.visitFieldInsn(179, this.className, name, typeDescriptor);
    }

    private void defineFields() {
        this.defineField("SIZEOF", Type.LONG_TYPE, this.structure.getSizeOf());
        for (StructureReader.ConstantDescriptor constant : this.structure.getConstants()) {
            this.defineField(constant.getName(), Type.LONG_TYPE, constant.getValue());
        }
        int bitFieldBitCount = 0;
        for (StructureReader.FieldDescriptor field : this.structure.getFields()) {
            if (!field.isPresent()) continue;
            String fieldName = field.getName();
            int fieldOffset = field.getOffset();
            String type2 = field.getType();
            int colonIndex = type2.lastIndexOf(58);
            if (colonIndex <= 0 || type2.charAt(colonIndex - 1) == ':') {
                this.defineField(String.format("_%sOffset_", fieldName), Type.INT_TYPE, fieldOffset);
                continue;
            }
            int bitSize = Integer.parseInt(type2.substring(colonIndex + 1).trim());
            if (bitSize > 32 - (bitFieldBitCount = Math.max(bitFieldBitCount, fieldOffset * 8)) % 32) {
                throw new InternalError(String.format("Bitfield %s->%s must not span cells", this.structure.getName(), fieldName));
            }
            this.defineField(String.format("_%s_s_", fieldName), Type.INT_TYPE, bitFieldBitCount);
            this.defineField(String.format("_%s_b_", fieldName), Type.INT_TYPE, bitSize);
            bitFieldBitCount += bitSize;
        }
        this.clinit.visitInsn(177);
        this.clinit.visitMaxs(2, 0);
        this.clinit.visitEnd();
    }

    private byte[] generate() {
        this.defineFields();
        MethodVisitor method = this.clazz.visitMethod(1, "<init>", voidMethod, null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(183, "java/lang/Object", "<init>", voidMethod, false);
        method.visitInsn(177);
        method.visitMaxs(1, 1);
        method.visitEnd();
        this.clazz.visitEnd();
        return this.clazz.toByteArray();
    }
}

