/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.KeyInfoImpl;
import com.ibm.xml.crypto.dsig.dom.Marshalling;
import com.ibm.xml.crypto.dsig.dom.ReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.SignedInfoImpl;
import com.ibm.xml.crypto.dsig.dom.Utils;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.w3c.dom.Node;

class XMLSignatureImpl
extends XMLStructureImpl
implements XMLSignature {
    private SignedInfo signedInfo;
    private KeyInfo keyInfo;
    List objects;
    private String id;
    private String svId;
    private byte[] signatureValue;
    private XMLSignature.SignatureValue signatureValueInstance;
    private boolean validated;
    private boolean cachedResult;
    private Node signatureValueNode;
    private Node node;
    private HashMap signatureIdMap;

    XMLSignatureImpl(AlgorithmFactory f, SignedInfo si, KeyInfo ki, List objs, String id, String svi) {
        super(f);
        if (si == null) {
            throw new NullPointerException("SignatureMethod must not be null.");
        }
        this.signedInfo = si;
        this.keyInfo = ki;
        if (objs == null || objs.size() == 0) {
            this.objects = null;
        } else {
            this.objects = new ArrayList(objs.size());
            for (XMLObject obj : objs) {
                this.objects.add(obj);
            }
        }
        this.id = id;
        this.svId = svi;
        this.signatureValue = null;
        this.signatureValueInstance = null;
        this.signatureValueNode = null;
        this.node = null;
        this.validated = false;
        this.cachedResult = false;
    }

    @Override
    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List getObjects() {
        return this.objects == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.objects);
    }

    @Override
    public KeySelectorResult getKeySelectorResult() {
        return ((SignedInfoImpl)this.signedInfo).getKeySelectorResult();
    }

    @Override
    public XMLSignature.SignatureValue getSignatureValue() {
        if (this.signatureValueInstance == null) {
            this.signatureValueInstance = new SignatureValueImpl(this.afactory, this);
        }
        return this.signatureValueInstance;
    }

    void setSignatureValue(byte[] sv) {
        this.signatureValue = sv;
    }

    void setNode(Node n) {
        this.node = n;
        ((SignedInfoImpl)this.signedInfo).setSignatureNode(this.node);
        if (this.keyInfo != null) {
            ((KeyInfoImpl)this.keyInfo).setSignatureNode(this.node);
        }
    }

    void setSignatureValueNode(Node n) {
        this.signatureValueNode = n;
    }

    @Override
    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    @Override
    public void sign(XMLSignContext scontext) throws MarshalException, XMLSignatureException {
        if (scontext == null) {
            throw new NullPointerException("Null context");
        }
        DOMSignContext dscontext = (DOMSignContext)scontext;
        if (this.node == null) {
            Marshalling.marshalSignature(this, dscontext, this.afactory);
            dscontext.getParent().insertBefore(this.node, dscontext.getNextSibling());
        }
        SignedInfoImpl si = (SignedInfoImpl)this.signedInfo;
        this.signReferences(scontext, si);
        this.setSignatureValue(si.sign(scontext, this.keyInfo));
        if (this.signatureValueNode == null) {
            throw new XMLSignatureException("Internal Error: <ds:SignatureValue> element is not registered.");
        }
        DOMUtil.removeAllChildren(this.signatureValueNode);
        Marshalling.insertBase64Binary(this.signatureValueNode, this.signatureValue);
    }

    private void signReferences(XMLSignContext signContext, SignedInfo si) {
        int i;
        ArrayList<Reference> allReferences = new ArrayList<Reference>();
        this.signatureIdMap = new HashMap();
        this.signatureIdMap.put(this.id, this);
        this.signatureIdMap.put(si.getId(), si);
        List<Reference> refs = si.getReferences();
        int size = refs.size();
        for (i = 0; i < size; ++i) {
            Reference ref = refs.get(i);
            this.signatureIdMap.put(ref.getId(), ref);
        }
        if (this.objects != null) {
            int objSize = this.objects.size();
            int size2 = objSize;
            for (int i2 = 0; i2 < size2; ++i2) {
                XMLObject obj = (XMLObject)this.objects.get(i2);
                this.signatureIdMap.put(obj.getId(), obj);
                List<XMLStructure> content = obj.getContent();
                int csize = content.size();
                for (int j = 0; j < csize; ++j) {
                    XMLStructure xs = content.get(j);
                    if (!(xs instanceof Manifest)) continue;
                    Manifest man = (Manifest)xs;
                    this.signatureIdMap.put(man.getId(), man);
                    List<Reference> manRefs = man.getReferences();
                    int msize = manRefs.size();
                    for (int k = 0; k < msize; ++k) {
                        Reference ref = manRefs.get(k);
                        allReferences.add(ref);
                        this.signatureIdMap.put(ref.getId(), ref);
                    }
                }
            }
        }
        allReferences.addAll(si.getReferences());
        size = allReferences.size();
        for (i = 0; i < size; ++i) {
            ReferenceImpl ref = (ReferenceImpl)allReferences.get(i);
            try {
                this.digestReference(ref, signContext);
                continue;
            }
            catch (XMLSignatureException e) {
                e.printStackTrace();
            }
        }
        size = allReferences.size();
        for (i = 0; i < size; ++i) {
            ReferenceImpl ref = (ReferenceImpl)allReferences.get(i);
            if (ref.isDigested()) continue;
            try {
                ref.sign(signContext);
                continue;
            }
            catch (XMLSignatureException e) {
                e.printStackTrace();
            }
        }
    }

    private void digestReference(ReferenceImpl ref, XMLSignContext signContext) throws XMLSignatureException {
        if (ref.isDigested()) {
            return;
        }
        String uri = ref.getURI();
        if (Utils.sameDocumentURI(uri)) {
            String id = Utils.parseIdFromSameDocumentURI(uri);
            if (id != null && this.signatureIdMap.containsKey(id)) {
                Object obj = this.signatureIdMap.get(id);
                if (obj instanceof ReferenceImpl) {
                    this.digestReference((ReferenceImpl)obj, signContext);
                } else if (obj instanceof Manifest) {
                    Manifest man = (Manifest)obj;
                    List<Reference> manRefs = man.getReferences();
                    int size = manRefs.size();
                    for (int i = 0; i < size; ++i) {
                        this.digestReference((ReferenceImpl)manRefs.get(i), signContext);
                    }
                }
            }
            if (uri.length() == 0) {
                List transforms = ref.getTransforms();
                int size = transforms.size();
                for (int i = 0; i < size; ++i) {
                    Transform transform = (Transform)transforms.get(i);
                    String transformAlg = transform.getAlgorithm();
                    if (!transformAlg.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") && !transformAlg.equals("http://www.w3.org/2002/06/xmldsig-filter2")) continue;
                    return;
                }
            }
        }
        ref.sign(signContext);
    }

    @Override
    public boolean validate(XMLValidateContext vcontext) throws XMLSignatureException {
        if (vcontext == null) {
            throw new NullPointerException("Null context");
        }
        DOMValidateContext dvcontext = (DOMValidateContext)vcontext;
        if (this.validated) {
            return this.cachedResult;
        }
        SignedInfoImpl si = (SignedInfoImpl)this.signedInfo;
        for (int i = 0; i < si.content.size(); ++i) {
            Reference ref = (Reference)si.content.get(i);
            if (ref.validate(vcontext)) continue;
            this.cachedResult = false;
            this.validated = true;
            return this.cachedResult;
        }
        this.cachedResult = this.validateSignedInfo(vcontext);
        this.validated = true;
        return this.cachedResult;
    }

    boolean validateSignedInfo(XMLValidateContext vcontext) throws XMLSignatureException {
        SignedInfoImpl si = (SignedInfoImpl)this.signedInfo;
        return si.validate(vcontext, this.keyInfo, this.signatureValue);
    }

    public boolean equals(Object o) {
        boolean idEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof XMLSignature)) {
            return false;
        }
        XMLSignature osig = (XMLSignature)o;
        boolean bl = this.id == null ? osig.getId() == null : (idEqual = this.id.equals(osig.getId()));
        boolean keyInfoEqual = this.keyInfo == null ? osig.getKeyInfo() == null : this.keyInfo.equals(osig.getKeyInfo());
        boolean signatureValueEqual = this.getSignatureValue().equals(osig.getSignatureValue());
        boolean signedInfoEqual = this.signedInfo.equals(osig.getSignedInfo());
        boolean objectsEqual = this.getObjects().equals(osig.getObjects());
        return idEqual && keyInfoEqual && signatureValueEqual && signedInfoEqual && objectsEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        if (this.keyInfo != null) {
            result = 31 * result + this.keyInfo.hashCode();
        }
        result = 31 * result + this.getSignatureValue().hashCode();
        result = 31 * result + this.signedInfo.hashCode();
        result = 31 * result + this.getObjects().hashCode();
        return result;
    }

    static class SignatureValueImpl
    extends XMLStructureImpl
    implements XMLSignature.SignatureValue {
        XMLSignatureImpl parent;

        SignatureValueImpl(AlgorithmFactory f, XMLSignatureImpl xsig) {
            super(f);
            this.parent = xsig;
        }

        @Override
        public String getId() {
            return this.parent.svId;
        }

        @Override
        public byte[] getValue() {
            if (this.parent.signatureValue == null) {
                return null;
            }
            byte[] ret = new byte[this.parent.signatureValue.length];
            System.arraycopy(this.parent.signatureValue, 0, ret, 0, ret.length);
            return ret;
        }

        @Override
        public boolean validate(XMLValidateContext vcontext) throws XMLSignatureException {
            return this.parent.validateSignedInfo(vcontext);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof XMLSignature.SignatureValue)) {
                return false;
            }
            XMLSignature.SignatureValue osv = (XMLSignature.SignatureValue)o;
            boolean idEqual = this.getId() == null ? osv.getId() == null : this.getId().equals(osv.getId());
            return idEqual;
        }

        public int hashCode() {
            int result = 17;
            if (this.getId() != null) {
                result = 31 * result + this.getId().hashCode();
            }
            return result;
        }
    }
}

