/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.keystoreski;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.keystoreski.SKIDefinition;
import com.ibm.security.keystoreski.SKIDefinitionException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;

public final class SKIDefinitionFactory {
    private static final String SUBJECT_KEY_IDENTIFIER_OID = "2.5.29.14";

    private SKIDefinitionFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static SKIDefinition newSHA1PublicKeySKIDefinition() {
        return new SHA1PublicKeySKIDefinition();
    }

    public static SKIDefinition newSHA1PublicKeyTruncatedSKIDefinition() {
        return new SHA1PublicKeyTruncatedSKIDefinition();
    }

    public static SKIDefinition newX509ExtensionSKIDefinition() {
        return new X509ExtensionSKIDefinition();
    }

    public static SKIDefinition newCompositeSKIDefinition(SKIDefinition ... sKIDefinitionArray) {
        return new CompositeSKIDefinition(sKIDefinitionArray);
    }

    private static final class CompositeSKIDefinition
    implements SKIDefinition {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();
        private final SKIDefinition[] definitions;

        CompositeSKIDefinition(SKIDefinition ... sKIDefinitionArray) {
            this.definitions = sKIDefinitionArray;
        }

        @Override
        public String getSubjectKeyIdentifier(X509Certificate x509Certificate) throws NullPointerException {
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "entering method");
            }
            if (x509Certificate == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            for (SKIDefinition sKIDefinition : this.definitions) {
                String string;
                if (sKIDefinition == null || (string = sKIDefinition.getSubjectKeyIdentifier(x509Certificate)) == null) continue;
                if (debug != null) {
                    debug.text(1L, this.className, "getSubjectKeyIdentifier", "exiting method");
                }
                return string;
            }
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "returning null");
            }
            return null;
        }
    }

    private static final class SHA1PublicKeyTruncatedSKIDefinition
    implements SKIDefinition {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();

        SHA1PublicKeyTruncatedSKIDefinition() {
        }

        @Override
        public String getSubjectKeyIdentifier(X509Certificate x509Certificate) throws NullPointerException {
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "entering method");
            }
            if (x509Certificate == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            String string = new SHA1PublicKeySKIDefinition().getSubjectKeyIdentifier(x509Certificate);
            if (string == null) {
                if (debug != null) {
                    debug.text(1L, this.className, "getSubjectKeyIdentifier", "returning null");
                }
                return null;
            }
            try {
                byte[] byArray = new BASE64Decoder().decodeBuffer(string);
                byte[] byArray2 = new byte[8];
                System.arraycopy(byArray, byArray.length - 8, byArray2, 0, 8);
                byArray2[0] = (byte)(byArray2[0] & 0xF | 0x40);
                if (debug != null) {
                    debug.text(1L, this.className, "getSubjectKeyIdentifier", "exiting method");
                }
                return new BASE64Encoder().encode(byArray2);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)exception);
                }
                throw new SKIDefinitionException(exception.getMessage(), exception);
            }
        }
    }

    private static final class SHA1PublicKeySKIDefinition
    implements SKIDefinition {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();

        SHA1PublicKeySKIDefinition() {
        }

        @Override
        public String getSubjectKeyIdentifier(X509Certificate x509Certificate) throws NullPointerException {
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "entering method");
            }
            if (x509Certificate == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            byte[] byArray = x509Certificate.getPublicKey().getEncoded();
            try {
                DerInputStream derInputStream = new DerInputStream(byArray);
                DerValue[] derValueArray = derInputStream.getSequence(2);
                if (derValueArray == null || derValueArray.length != 2) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new InvalidKeyException("Public Key is not in X509 format."));
                    }
                    throw new InvalidKeyException("Public Key is not in X509 format.");
                }
                byte[] byArray2 = derValueArray[1].getBitString();
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                byte[] byArray3 = messageDigest.digest(byArray2);
                if (debug != null) {
                    debug.text(1L, this.className, "getSubjectKeyIdentifier", "exiting method");
                }
                return new BASE64Encoder().encode(byArray3);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)exception);
                }
                throw new SKIDefinitionException(exception.getMessage(), exception);
            }
        }
    }

    private static final class X509ExtensionSKIDefinition
    implements SKIDefinition {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();

        X509ExtensionSKIDefinition() {
        }

        @Override
        public String getSubjectKeyIdentifier(X509Certificate x509Certificate) throws NullPointerException {
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "entering method");
            }
            if (x509Certificate == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            byte[] byArray = x509Certificate.getExtensionValue(SKIDefinitionFactory.SUBJECT_KEY_IDENTIFIER_OID);
            String string = null;
            if (byArray != null) {
                try {
                    DerValue derValue = new DerValue(byArray);
                    byte[] byArray2 = derValue.getOctetString();
                    DerValue derValue2 = new DerValue(byArray2);
                    string = new BASE64Encoder().encode(derValue2.getOctetString());
                }
                catch (IOException iOException) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)iOException);
                    }
                    throw new RuntimeException(iOException);
                }
            }
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "exiting method");
            }
            return string;
        }
    }
}

