/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.tools.CertAndKeyGen;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509Key;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateCrtKeySpec;

public class genCertAndKeys {
    public static void main(String[] argv) throws Throwable {
        String prefix = null;
        String certfile = null;
        String privkeyfile = null;
        String pubkeyfile = null;
        int modlen = 1024;
        if (argv.length != 1) {
            System.out.println("Usage: genCertAndKeys <file_prefix>");
            System.exit(1);
        } else {
            prefix = argv[0];
            certfile = prefix + ".cer";
            privkeyfile = prefix + ".pri";
            pubkeyfile = prefix + ".pub";
        }
        System.out.println("Creating a key pair and certificate.");
        CertAndKeyGen certAndKey = new CertAndKeyGen("RSA", "MD5withRSA");
        certAndKey.generate(512);
        X500Name myname = new X500Name("Java User", "JavaSec", "IBM", "US");
        X509Certificate cert = certAndKey.getSelfCertificate(myname, 36000L);
        X509Key publicKey = certAndKey.getPublicKey();
        SecureRandom random = new SecureRandom();
        BigInteger p = new BigInteger(modlen / 2, 10, random);
        BigInteger q = new BigInteger(modlen / 2, 10, random);
        BigInteger n = p.multiply(q);
        BigInteger e = new BigInteger("65537");
        BigInteger phi = p.subtract(BigInteger.ONE).multiply(q.subtract(BigInteger.ONE));
        BigInteger d = e.modInverse(phi);
        RSAPrivateCrtKeySpec keyspec = new RSAPrivateCrtKeySpec(BigInteger.ZERO, BigInteger.ZERO, e, p, q, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = factory.generatePrivate(keyspec);
        System.out.println("Writing certificate to " + certfile);
        FileOutputStream fos = new FileOutputStream(certfile);
        fos.write(cert.getEncoded());
        fos.close();
        System.out.println("Writing private key to " + privkeyfile);
        fos = new FileOutputStream(privkeyfile);
        fos.write(privateKey.getEncoded());
        fos.close();
        System.out.println("Writing public key to " + pubkeyfile);
        fos = new FileOutputStream(pubkeyfile);
        fos.write(publicKey.getEncoded());
        fos.close();
    }
}

