/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.transformer.KeyIterator;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class KeyRefIterator
extends ChildTestIterator {
    static final long serialVersionUID = 3837456451659435102L;
    DTMIterator m_keysNodes;
    protected XMLString m_ref;
    protected QName m_name;
    protected Vector m_keyDeclarations;

    public KeyRefIterator(QName qName, XMLString xMLString, Vector vector, DTMIterator dTMIterator) {
        super((DTMAxisTraverser)null);
        this.m_name = qName;
        this.m_ref = xMLString;
        this.m_keyDeclarations = vector;
        this.m_keysNodes = dTMIterator;
        this.setWhatToShow(-1);
    }

    @Override
    protected int getNextNode() {
        int n;
        while (-1 != (n = this.m_keysNodes.nextNode()) && 1 != this.filterNode(n)) {
        }
        this.m_lastFetched = n;
        return n;
    }

    public short filterNode(int n) {
        boolean bl = false;
        Vector vector = this.m_keyDeclarations;
        QName qName = this.m_name;
        KeyIterator keyIterator = (KeyIterator)((XNodeSet)this.m_keysNodes).getContainedIter();
        XPathContext xPathContext = keyIterator.getXPathContext();
        if (null == xPathContext) {
            this.assertion(false, "xctxt can not be null here!");
        }
        try {
            XMLString xMLString = this.m_ref;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                int n3;
                Object object;
                KeyDeclaration keyDeclaration = (KeyDeclaration)vector.elementAt(i);
                if (!keyDeclaration.getName().equals(qName)) continue;
                bl = true;
                XObject xObject = keyDeclaration.getUse().execute(xPathContext, n, keyIterator.getPrefixResolver());
                if (xObject.getType() != 4) {
                    object = xObject.xstr();
                    if (!xMLString.equals((XMLString)object)) continue;
                    return 1;
                }
                object = ((XNodeSet)xObject).iterRaw();
                while (-1 != (n3 = object.nextNode())) {
                    DTM dTM = this.getDTM(n3);
                    XMLString xMLString2 = dTM.getStringValue(n3);
                    if (null == xMLString2 || !xMLString.equals(xMLString2)) continue;
                    return 1;
                }
            }
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
        if (!bl) {
            throw new RuntimeException(XSLMessages.createMessage("ER_NO_XSLKEY_DECLARATION", new Object[]{qName.getLocalName()}));
        }
        return 2;
    }
}

