/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.DeveloperProperties;
import com.ibm.xml.xlxp.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;

public class DataSourceFactory {
    private static final int DEFAULT_BUFFER_LENGTH = 65536;
    private DataBufferFactory fBufferFactory;
    private int fBufferLength;
    private ByteStreamDataSource fFreeByteStreamDataSource;
    private CharacterStreamDataSource fFreeCharacterStreamDataSource;

    public DataSourceFactory(DataBufferFactory dataBufferFactory) {
        this.fBufferFactory = dataBufferFactory;
        this.fBufferLength = DeveloperProperties.getInteger("com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory.bufferLength", 65536);
    }

    public void setBufferLength(int n) {
        this.fBufferLength = n;
    }

    public ByteStreamDataSource allocateByteStreamDataSource() {
        ByteStreamDataSource byteStreamDataSource = this.fFreeByteStreamDataSource;
        if (byteStreamDataSource != null) {
            this.fFreeByteStreamDataSource = byteStreamDataSource.nextFreeDataSource;
            byteStreamDataSource.nextFreeDataSource = null;
            byteStreamDataSource.bufferLength = this.fBufferLength;
        } else {
            byteStreamDataSource = new ByteStreamDataSource(this, this.fBufferFactory, this.fBufferLength);
        }
        return byteStreamDataSource;
    }

    public void releaseByteStreamDataSource(ByteStreamDataSource byteStreamDataSource) {
        byteStreamDataSource.nextFreeDataSource = this.fFreeByteStreamDataSource;
        this.fFreeByteStreamDataSource = byteStreamDataSource;
    }

    public CharacterStreamDataSource allocateCharacterStreamDataSource() {
        CharacterStreamDataSource characterStreamDataSource = this.fFreeCharacterStreamDataSource;
        if (characterStreamDataSource != null) {
            this.fFreeCharacterStreamDataSource = characterStreamDataSource.nextFreeDataSource;
            characterStreamDataSource.nextFreeDataSource = null;
        } else {
            characterStreamDataSource = new CharacterStreamDataSource(this, this.fBufferFactory, this.fBufferLength);
        }
        return characterStreamDataSource;
    }

    public void releaseCharacterStreamDataSource(CharacterStreamDataSource characterStreamDataSource) {
        characterStreamDataSource.nextFreeDataSource = this.fFreeCharacterStreamDataSource;
        this.fFreeCharacterStreamDataSource = characterStreamDataSource;
    }
}

