/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.JCAUtil;
import com.ibm.crypto.provider.MGF1;
import com.ibm.crypto.provider.RSACore;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class RSAPadding {
    public static final int PAD_BLOCKTYPE_1 = 1;
    public static final int PAD_BLOCKTYPE_2 = 2;
    public static final int PAD_NONE = 3;
    public static final int PAD_OAEP_MGF1 = 4;
    public static final int PAD_ZERO = 5;
    private final int a;
    private final int b;
    private SecureRandom c;
    private final int d;
    private MessageDigest e;
    private MGF1 f;
    private byte[] g;
    private static final Map<String, byte[]> h;
    private static final String[] z;

    public static RSAPadding getInstance(int n2, int n3) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, null, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, oAEPParameterSpec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RSAPadding(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a = n2;
        this.b = n3;
        this.c = secureRandom;
        if (n3 < 64) {
            throw new InvalidKeyException(z[1]);
        }
        switch (n2) {
            case 1: 
            case 2: {
                this.d = n3 - 11;
                return;
            }
            case 3: 
            case 5: {
                this.d = n3;
                return;
            }
            case 4: {
                String string;
                String string2 = string = z[9];
                byte[] byArray = null;
                try {
                    if (oAEPParameterSpec != null) {
                        string = oAEPParameterSpec.getDigestAlgorithm();
                        String string3 = oAEPParameterSpec.getMGFAlgorithm();
                        if (!string3.equalsIgnoreCase(z[7])) {
                            throw new InvalidAlgorithmParameterException(z[0] + string3);
                        }
                        string2 = ((MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters()).getDigestAlgorithm();
                        PSource pSource = oAEPParameterSpec.getPSource();
                        String string4 = pSource.getAlgorithm();
                        if (!string4.equalsIgnoreCase(z[5])) {
                            throw new InvalidAlgorithmParameterException(z[8] + string4);
                        }
                        byArray = ((PSource.PSpecified)pSource).getValue();
                    }
                    this.e = MessageDigest.getInstance(string);
                    this.f = new MGF1(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidKeyException(z[2], noSuchAlgorithmException);
                }
                this.g = RSAPadding.a(this.e, byArray);
                int n4 = this.g.length;
                this.d = n3 - 2 - 2 * n4;
                if (this.d > 0) return;
                throw new InvalidKeyException(z[4] + string + z[6] + this.f.a());
            }
        }
        throw new InvalidKeyException(z[3] + n2);
    }

    private static byte[] a(MessageDigest messageDigest, byte[] byArray) {
        byte[] byArray2;
        if (byArray == null || byArray.length == 0) {
            String string = messageDigest.getAlgorithm();
            byArray2 = h.get(string);
            if (byArray2 == null) {
                byArray2 = messageDigest.digest();
                h.put(string, byArray2);
            }
        } else {
            byArray2 = messageDigest.digest(byArray);
        }
        return byArray2;
    }

    public int getMaxDataSize() {
        return this.d;
    }

    public byte[] pad(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = RSACore.convert(byArray, n2, n3);
        byte[] byArray3 = this.pad(byArray2);
        if (byArray2 != byArray) {
            Arrays.fill(byArray2, (byte)0);
        }
        return byArray3;
    }

    public byte[] pad(byte[] byArray) {
        if (byArray.length > this.d) {
            return null;
        }
        switch (this.a) {
            case 3: {
                return byArray;
            }
            case 1: 
            case 2: {
                return this.a(byArray);
            }
            case 4: {
                return this.e(byArray);
            }
            case 5: {
                return this.b(byArray);
            }
        }
        throw new AssertionError();
    }

    public byte[] unpad(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = RSACore.convert(byArray, n2, n3);
        byte[] byArray3 = this.unpad(byArray2);
        if (byArray2 != byArray) {
            Arrays.fill(byArray2, (byte)0);
        }
        return byArray3;
    }

    public byte[] unpad(byte[] byArray) {
        if (byArray.length == this.b) {
            switch (this.a) {
                case 3: {
                    return byArray;
                }
                case 1: 
                case 2: {
                    return this.c(byArray);
                }
                case 4: {
                    return this.f(byArray);
                }
                case 5: {
                    return this.d(byArray);
                }
            }
            throw new AssertionError();
        }
        return null;
    }

    private byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[this.b];
        System.arraycopy(byArray, 0, byArray2, this.b - byArray.length, byArray.length);
        int n2 = this.b - 3 - byArray.length;
        int n3 = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = (byte)this.a;
        if (this.a == 1) {
            while (n2-- > 0) {
                byArray2[n3++] = -1;
            }
        } else {
            if (this.c == null) {
                this.c = JCAUtil.getSecureRandom();
            }
            byte[] byArray3 = new byte[64];
            int n4 = -1;
            while (n2-- > 0) {
                int n5;
                do {
                    if (n4 >= 0) continue;
                    this.c.nextBytes(byArray3);
                    n4 = byArray3.length - 1;
                } while ((n5 = byArray3[n4--] & 0xFF) == 0);
                byArray2[n3++] = (byte)n5;
            }
        }
        return byArray2;
    }

    private byte[] b(byte[] byArray) {
        byte[] byArray2 = new byte[this.b];
        byte[] byArray3 = new byte[this.b - byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, this.b - byArray.length, byArray.length);
        return byArray2;
    }

    private byte[] c(byte[] byArray) {
        int n2;
        int n3 = byArray.length;
        if (n3 < 2) {
            return null;
        }
        byte by = byArray[0];
        byte by2 = byArray[1];
        int n4 = (-(by & 0xFF) | (by2 - this.a | this.a - by2)) >>> 31;
        int n5 = 0;
        int n6 = 2;
        while (n6 < n3) {
            n2 = byArray[n6++] & 0xFF;
            n5 += n6 * (1 - (-(n2 | n5) >>> 31));
            if (n6 == n3) {
                n4 |= 1 - (-n5 >>> 31);
            }
            n4 |= 1 - (-(this.a - 1 & 0xFF | n5 | 1 - (n2 - 255 >>> 31)) >>> 31);
        }
        n2 = n3 - n5;
        n4 |= this.d - n2 >>> 31;
        byte[] byArray2 = new byte[n5 + 2];
        for (int i2 = 0; i2 < n5; ++i2) {
            byArray2[i2] = byArray[i2];
        }
        byte[] byArray3 = new byte[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            byArray3[i3] = byArray[n5 + i3];
        }
        if ((n4 | byArray2[n4]) != 0) {
            return null;
        }
        return byArray3;
    }

    public byte[] unpadForTls(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = byArray.length;
        int n6 = (byArray[0] | byArray[1] - 2) & 0xFFF;
        int n7 = 2;
        while (n7 < n5 - 49) {
            n4 = byArray[n7++] & 0xFF;
            n6 |= 1 - (-n4 >>> 31);
        }
        n6 |= byArray[n7++] & 0xFF;
        n4 = (byArray[n7] & 0xFF) << 8 | byArray[n7 + 1] & 0xFF;
        int n8 = n2 - n4;
        n8 |= -n8;
        int n9 = n3 - n4;
        n9 |= -n9;
        int n10 = 769 - n2;
        n6 |= (n8 & (n10 | n9)) >>> 28;
        byte[] byArray2 = Arrays.copyOfRange(byArray, n5 - 48, n5);
        if (this.c == null) {
            this.c = JCAUtil.getSecureRandom();
        }
        byte[] byArray3 = new byte[48];
        this.c.nextBytes(byArray3);
        n6 = -n6 >> 24;
        for (int i2 = 0; i2 < 48; ++i2) {
            byArray2[i2] = (byte)(~n6 & byArray2[i2] | n6 & byArray3[i2]);
        }
        return byArray2;
    }

    private byte[] d(byte[] byArray) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n4 = byArray[n2] & 0xFF;
            if (n4 == 0 || n3 != -1) continue;
            n3 = n2;
        }
        if (n3 == -1) {
            n3 = byArray.length > 0 ? byArray.length - 1 : 0;
        }
        n2 = byArray.length - n3;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n3, byArray3, 0, n2);
        return byArray3;
    }

    private byte[] e(byte[] byArray) {
        if (this.c == null) {
            this.c = JCAUtil.getSecureRandom();
        }
        int n2 = this.g.length;
        byte[] byArray2 = new byte[n2];
        this.c.nextBytes(byArray2);
        byte[] byArray3 = new byte[this.b];
        int n3 = 1;
        int n4 = n2;
        System.arraycopy(byArray2, 0, byArray3, n3, n4);
        int n5 = n2 + 1;
        int n6 = byArray3.length - n5;
        int n7 = this.b - byArray.length;
        System.arraycopy(this.g, 0, byArray3, n5, n2);
        byArray3[n7 - 1] = 1;
        System.arraycopy(byArray, 0, byArray3, n7, byArray.length);
        this.f.a(byArray3, n3, n4, n6, byArray3, n5);
        this.f.a(byArray3, n5, n6, n4, byArray3, n3);
        return byArray3;
    }

    private byte[] f(byte[] byArray) {
        int n2;
        int n3;
        byte[] byArray2 = byArray;
        boolean bl2 = false;
        int n4 = this.g.length;
        if (byArray2[0] != 0) {
            bl2 = true;
        }
        int n5 = 1;
        int n6 = n4;
        int n7 = n4 + 1;
        int n8 = byArray2.length - n7;
        this.f.a(byArray2, n7, n8, n6, byArray2, n5);
        this.f.a(byArray2, n5, n6, n8, byArray2, n7);
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.g[n3] == byArray2[n7 + n3]) continue;
            bl2 = true;
        }
        n3 = n7 + n4;
        int n9 = -1;
        for (n2 = n3; n2 < byArray2.length; ++n2) {
            byte by = byArray2[n2];
            if (n9 != -1 || by == 0) continue;
            if (by == 1) {
                n9 = n2;
                continue;
            }
            bl2 = true;
        }
        if (n9 == -1) {
            bl2 = true;
            n9 = byArray2.length - 1;
        }
        n2 = n9 + 1;
        byte[] byArray3 = new byte[n2 - n3];
        System.arraycopy(byArray2, n3, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[byArray2.length - n2];
        System.arraycopy(byArray2, n2, byArray4, 0, byArray4.length);
        return bl2 ? null : byArray4;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\b\u0014M\u001a\u0010-\u0015L\u001b\u00059Zs(&}\u001bR\b\u000fgZ";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                block20: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block20;
                    n5 = n5;
                    if (n5 <= n4) break block21;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 93;
                            break;
                        }
                        case 1: {
                            n6 = 122;
                            break;
                        }
                        case 2: {
                            n6 = 62;
                            break;
                        }
                        case 3: {
                            n6 = 111;
                            break;
                        }
                        default: {
                            n6 = 96;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\r\u001bZ\u000b\u00059ZM\u0006\u001a8ZS\u001a\u0013)Z\\\n@<\u000e\u001e\u0003\u0005<\tJOVi";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0019\u0013Y\n\u0013)ZP\u0000\u0014}\u001bH\u000e\t1\u001b\\\u0003\u0005";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0014\u0014H\u000e\f4\u001e\u001e\u001f\u00019\u001eW\u0001\u0007gZ";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0016\u001fGO\t.ZJ\u0000\u000f}\tV\u0000\u0012)ZX\u0000\u0012}\u001fP\f\u0012$\nJ\u0006\u000f3ZK\u001c\t3\u001d\u001e !\u0018*n\u000e\u00049\u0013P\b@*\u0013J\u0007@";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\r)N\n\u00034\u001cW\n\u0004";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "}\u001bP\u000b@\u0010=x^";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0010=x^";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\b\u0014M\u001a\u0010-\u0015L\u001b\u00059ZN<\u000f(\b]\n@<\u0016Y\u0000Z}";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u000e2\u007fBQ";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        h = Collections.synchronizedMap(new HashMap());
    }
}

