/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.JCAUtil;
import com.ibm.crypto.provider.PSSParameters;
import com.ibm.crypto.provider.RSACore;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPadding;
import com.ibm.misc.Debug;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;

public class RSAPSSSignature
extends SignatureSpi {
    private static Debug a;
    protected SecureRandom b;
    private static final Hashtable<String, Integer> c;
    double d = 0.0;
    private int e;
    private double f;
    private MessageDigest g;
    private MessageDigest h;
    private boolean i = true;
    private RSAPadding j;
    private RSAPrivateKey k;
    private RSAPublicKey l;
    PSSParameterSpec m = null;
    private static final String[] z;

    RSAPSSSignature(PSSParameterSpec pSSParameterSpec) {
        try {
            this.engineSetParameter(pSSParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public RSAPSSSignature() {
        this(new PSSParameterSpec(z[61], z[60], MGF1ParameterSpec.SHA1, 20, 1));
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.k = null;
        this.b(rSAPublicKey);
        this.l = rSAPublicKey;
        this.b = JCAUtil.getSecureRandom();
        this.d = rSAPublicKey.getModulus().bitLength();
        this.f = this.d - 1.0;
        this.e = (int)Math.ceil(this.f / 8.0);
        this.a(rSAPublicKey, this.b);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.b = JCAUtil.getSecureRandom();
        this.engineInitSign(privateKey, this.b);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.d = rSAPrivateKey.getModulus().bitLength();
        this.f = this.d - 1.0;
        this.e = (int)Math.ceil(this.f / 8.0);
        this.b(rSAPrivateKey);
        this.k = rSAPrivateKey;
        this.l = null;
        this.a(rSAPrivateKey, this.b);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.b = secureRandom == null ? JCAUtil.getSecureRandom() : secureRandom;
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            this.j = RSAPadding.getInstance(5, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        this.a();
    }

    private void a() {
        if (!this.i) {
            this.g.reset();
            this.i = true;
        }
    }

    private byte[] b() {
        this.i = true;
        return this.g.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.d();
        this.g.update(by);
        this.i = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.d();
        this.g.update(byArray, n2, n3);
        this.i = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        try {
            this.d();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException.getMessage());
        }
        this.g.update(byteBuffer);
        this.i = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = this.encodeSignature(byArray);
            byte[] byArray3 = RSACore.rsa(byArray2, this.k);
            int n2 = ((int)this.d + 7) / 8;
            return byArray3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(z[0], generalSecurityException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (byArray.length != RSACore.getByteLength(this.l)) {
            throw new SignatureException(z[53] + byArray.length + z[49] + RSACore.getByteLength(this.l));
        }
        int n2 = ((int)this.d + 7) / 8;
        if (byArray.length != n2) {
            throw new SignatureException(z[51] + byArray.length + z[52] + RSACore.getByteLength(this.l));
        }
        byte[] byArray2 = this.b();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.l);
            byte[] byArray4 = this.j.unpad(byArray3);
            if (byArray4.length > this.e) {
                return false;
            }
            if (byArray4.length < this.e) {
                byte[] byArray5 = new byte[this.e];
                System.arraycopy(byArray4, 0, byArray5, this.e - byArray4.length, byArray4.length);
                byArray4 = byArray5;
            }
            boolean bl2 = this.decodeSignature(byArray4, byArray2);
            return bl2;
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return false;
        }
        catch (IOException iOException) {
            throw new SignatureException(z[50], iOException);
        }
    }

    public byte[] encodeSignature(byte[] byArray) throws InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        if (this.e < byArray.length + this.m.getSaltLength() + 2) {
            throw new SecurityException(z[72]);
        }
        byte[] byArray2 = new byte[this.m.getSaltLength()];
        this.b.nextBytes(byArray2);
        byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray4 = new byte[8 + byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length + byArray.length, byArray2.length);
        this.i = false;
        this.g.reset();
        this.g.update(byArray4);
        byte[] byArray5 = this.g.digest();
        this.i = true;
        int n3 = this.e - byArray5.length - byArray2.length - 2;
        byte[] byArray6 = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray6[n2] = 0;
        }
        byte[] byArray7 = new byte[this.e - byArray5.length - 1];
        if (n3 > 0) {
            System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
        }
        byArray7[n2++] = 1;
        System.arraycopy(byArray2, 0, byArray7, n2, byArray2.length);
        byte[] byArray8 = new byte[n3 + 1 + byArray2.length];
        byArray8 = this.a(byArray5, byArray8.length);
        byte[] byArray9 = new byte[n3 + 1 + byArray2.length];
        int n4 = 0;
        for (byte by : byArray8) {
            byArray9[n4] = (byte)(by ^ byArray7[n4++]);
        }
        int n5 = 8 * this.e - (int)this.f;
        if (n5 > 0) {
            int n6 = (byte)(255 >>> n5);
            byArray9[0] = (byte)(byArray9[0] & n6);
        }
        byte[] byArray10 = new byte[this.e];
        System.arraycopy(byArray9, 0, byArray10, 0, byArray9.length);
        System.arraycopy(byArray5, 0, byArray10, byArray9.length, byArray5.length);
        byArray10[byArray9.length + byArray5.length] = -68;
        return byArray10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decodeSignature(byte[] byArray, byte[] byArray2) throws IOException, SignatureException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        byte by2;
        if (this.e < byArray2.length + 2 + this.m.getSaltLength()) {
            return false;
        }
        byte by = byArray[this.e - 1];
        if ((by ^ 0xBC) == 0) {
            return false;
        }
        byte[] byArray5 = Arrays.copyOfRange(byArray, 0, this.e - byArray2.length - 1);
        byte[] byArray4 = Arrays.copyOfRange(byArray, byArray5.length, this.e - 1);
        int n3 = 8 * this.e - (int)this.f;
        int n4 = 8 - n3;
        if (n4 > 0 && (byArray5[0] & (by2 = (byte)(255 << n4))) != 0) {
            return false;
        }
        byte[] byArray6 = new byte[this.e - byArray4.length - 1];
        byArray6 = this.a(byArray4, byArray6.length);
        byte[] byArray3 = new byte[byArray6.length];
        int n5 = 0;
        byte[] byArray7 = byArray6;
        int n6 = byArray7.length;
        for (int i2 = 0; i2 < n6; ++n5, ++i2) {
            byte by3 = byArray7[i2];
            byArray3[n5] = (byte)(by3 ^ byArray5[n5]);
        }
        n3 = 8 * this.e - (int)this.f;
        if (n3 > 0) {
            byte by4 = (byte)(255 >>> n3);
            byArray3[0] = (byte)(byArray3[0] & by4);
        }
        if ((n2 = this.e - byArray4.length - this.m.getSaltLength() - 2) > 0) {
            for (n6 = 0; n6 < n2; ++n6) {
                if (byArray3[n6] == 0) continue;
                return false;
            }
        }
        if (byArray3[n2] != 1) {
            return false;
        }
        byte[] byArray72 = Arrays.copyOfRange(byArray3, n2 + 1, byArray3.length);
        byte[] byArray8 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray9 = new byte[8 + byArray2.length + byArray72.length];
        System.arraycopy(byArray8, 0, byArray9, 0, byArray8.length);
        System.arraycopy(byArray2, 0, byArray9, byArray8.length, byArray2.length);
        System.arraycopy(byArray72, 0, byArray9, byArray8.length + byArray2.length, byArray72.length);
        this.i = false;
        this.g.reset();
        this.g.update(byArray9);
        byte[] byArray10 = this.g.digest();
        this.i = true;
        return MessageDigest.isEqual(byArray4, byArray10);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[64]);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[62]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        block71: {
            boolean bl2;
            block75: {
                block89: {
                    String string;
                    String string2;
                    block87: {
                        block88: {
                            block85: {
                                block86: {
                                    block84: {
                                        block82: {
                                            block83: {
                                                block81: {
                                                    block79: {
                                                        block80: {
                                                            block78: {
                                                                block76: {
                                                                    block77: {
                                                                        block73: {
                                                                            block74: {
                                                                                block72: {
                                                                                    this.m = this.a(algorithmParameterSpec);
                                                                                    if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
                                                                                        throw new InvalidAlgorithmParameterException();
                                                                                    }
                                                                                    if (!this.i) {
                                                                                        throw new ProviderException(z[24]);
                                                                                    }
                                                                                    this.m = (PSSParameterSpec)algorithmParameterSpec;
                                                                                    string2 = this.m.getDigestAlgorithm();
                                                                                    AlgorithmParameterSpec algorithmParameterSpec2 = this.m.getMGFParameters();
                                                                                    if (string2 == null || algorithmParameterSpec2 == null) break block71;
                                                                                    if (!(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) break block71;
                                                                                    string = ((MGF1ParameterSpec)algorithmParameterSpec2).getDigestAlgorithm();
                                                                                    if (string == null) break block71;
                                                                                    bl2 = true;
                                                                                    if (string2.equalsIgnoreCase(z[14]) || string2.equalsIgnoreCase(z[32])) break block72;
                                                                                    if (!string2.equalsIgnoreCase(z[28])) break block73;
                                                                                }
                                                                                if (string.equalsIgnoreCase(z[36])) break block74;
                                                                                if (string.equalsIgnoreCase(z[39])) break block74;
                                                                                if (!string.equalsIgnoreCase(z[27])) break block75;
                                                                            }
                                                                            bl2 = false;
                                                                            break block75;
                                                                        }
                                                                        if (!string2.equalsIgnoreCase(z[11]) && !string2.equalsIgnoreCase(z[31])) break block76;
                                                                        if (string.equalsIgnoreCase(z[10])) break block77;
                                                                        if (!string.equalsIgnoreCase(z[43])) break block75;
                                                                    }
                                                                    bl2 = false;
                                                                    break block75;
                                                                }
                                                                if (string2.equalsIgnoreCase(z[8]) || string2.equalsIgnoreCase(z[21])) break block78;
                                                                if (!string2.equalsIgnoreCase(z[23])) break block79;
                                                            }
                                                            if (string.equalsIgnoreCase(z[33])) break block80;
                                                            if (string.equalsIgnoreCase(z[12])) break block80;
                                                            if (!string.equalsIgnoreCase(z[15])) break block75;
                                                        }
                                                        bl2 = false;
                                                        break block75;
                                                    }
                                                    if (string2.equalsIgnoreCase(z[40]) || string2.equalsIgnoreCase(z[44])) break block81;
                                                    if (!string2.equalsIgnoreCase(z[7])) break block82;
                                                }
                                                if (string.equalsIgnoreCase(z[9])) break block83;
                                                if (string.equalsIgnoreCase(z[42])) break block83;
                                                if (!string.equalsIgnoreCase(z[17])) break block75;
                                            }
                                            bl2 = false;
                                            break block75;
                                        }
                                        if (string2.equalsIgnoreCase(z[41]) || string2.equalsIgnoreCase(z[13])) break block84;
                                        if (!string2.equalsIgnoreCase(z[16])) break block85;
                                    }
                                    if (string.equalsIgnoreCase(z[22])) break block86;
                                    if (string.equalsIgnoreCase(z[29])) break block86;
                                    if (!string.equalsIgnoreCase(z[26])) break block75;
                                }
                                bl2 = false;
                                break block75;
                            }
                            if (!string2.equalsIgnoreCase(z[25]) && !string2.equalsIgnoreCase(z[19])) break block87;
                            if (string.equalsIgnoreCase(z[20])) break block88;
                            if (!string.equalsIgnoreCase(z[38])) break block75;
                        }
                        bl2 = false;
                        break block75;
                    }
                    if (!string2.equalsIgnoreCase(z[30]) && !string2.equalsIgnoreCase(z[34])) break block75;
                    if (string.equalsIgnoreCase(z[35])) break block89;
                    if (!string.equalsIgnoreCase(z[37])) break block75;
                }
                bl2 = false;
            }
            if (bl2) {
                InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException(z[18]);
                throw invalidAlgorithmParameterException;
            }
        }
        try {
            this.g = MessageDigest.getInstance(this.m.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidAlgorithmParameterException(noSuchAlgorithmException);
        }
        this.i = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray, int n2) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException {
        String string = this.m.getDigestAlgorithm();
        String string2 = this.m.getMGFAlgorithm();
        if (!string2.equalsIgnoreCase(z[4])) {
            throw new InvalidAlgorithmParameterException(z[3] + string2);
        }
        String string3 = null;
        string3 = this.m.getMGFParameters() == null ? string : ((MGF1ParameterSpec)this.m.getMGFParameters()).getDigestAlgorithm();
        try {
            this.h = MessageDigest.getInstance(string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(z[2] + string + z[1], noSuchAlgorithmException);
        }
        byte[] byArray2 = new byte[n2];
        int n3 = this.h.getDigestLength();
        int n4 = n2 / n3;
        if (n2 % n3 > 0) {
            ++n4;
        }
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[n3];
        int n5 = 0;
        while (n5 < n4) {
            byArray3[0] = (byte)(n5 >>> 24);
            byArray3[1] = (byte)(n5 >>> 16);
            byArray3[2] = (byte)(n5 >>> 8);
            byArray3[3] = (byte)n5;
            this.h.update(byArray, 0, byArray.length);
            this.h.update(byArray3);
            try {
                this.h.digest(byArray4, 0, byArray4.length);
            }
            catch (DigestException digestException) {
                throw new BadPaddingException(digestException.toString());
            }
            for (int i2 = 0; i2 < byArray4.length && n5 * n3 + i2 < n2; ++i2) {
                byArray2[n5 * n3 + i2] = byArray4[i2];
            }
            ++n5;
        }
        return byArray2;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() throws InvalidParameterException {
        AlgorithmParameters algorithmParameters = null;
        if (this.m != null) {
            try {
                algorithmParameters = AlgorithmParameters.getInstance(z[47], z[46]);
                algorithmParameters.init(this.m);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException(z[48]);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException(generalSecurityException.getMessage());
            }
        }
        if (this.m == null) {
            return null;
        }
        return algorithmParameters;
    }

    String a(byte[] byArray) {
        String string = z[45];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            stringBuffer.append(string.charAt(n2 >> 4));
            stringBuffer.append(string.charAt(n2 & 0xF));
        }
        return stringBuffer.toString();
    }

    private static void a(RSAKey rSAKey, int n2, int n3) throws SignatureException {
        if (rSAKey != null) {
            int n4 = RSAPSSSignature.a(rSAKey) >> 3;
            int n5 = Math.addExact(Math.addExact(n2, n3), 2);
            if (n4 < n5) {
                throw new SignatureException(z[63] + n5);
            }
        }
    }

    private static int a(RSAKey rSAKey) {
        if (rSAKey != null) {
            return rSAKey.getModulus().bitLength();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(String string, String string2) {
        if (string == null) return false;
        if (string2 == null) {
            return false;
        }
        if (string2.indexOf("-") != -1) {
            return string.equalsIgnoreCase(string2);
        }
        if (!string.equals(z[69])) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (!string2.regionMatches(true, 0, z[65], 0, 3)) throw new ProviderException(z[68] + string2);
            string2 = stringBuilder.insert(3, "-").toString();
            return string.equalsIgnoreCase(string2);
        }
        if (string2.equalsIgnoreCase(z[67])) return true;
        if (string2.equalsIgnoreCase(z[66])) return true;
        return false;
    }

    private static boolean a(AlgorithmParameterSpec algorithmParameterSpec, PSSParameterSpec pSSParameterSpec) {
        if (algorithmParameterSpec == null) {
            return true;
        }
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            return false;
        }
        if (pSSParameterSpec == null) {
            return true;
        }
        PSSParameterSpec pSSParameterSpec2 = (PSSParameterSpec)algorithmParameterSpec;
        if (pSSParameterSpec2.getSaltLength() > pSSParameterSpec.getSaltLength()) {
            return false;
        }
        PSSParameterSpec pSSParameterSpec3 = new PSSParameterSpec(pSSParameterSpec2.getDigestAlgorithm(), pSSParameterSpec2.getMGFAlgorithm(), pSSParameterSpec2.getMGFParameters(), pSSParameterSpec.getSaltLength(), pSSParameterSpec2.getTrailerField());
        PSSParameters pSSParameters = new PSSParameters();
        try {
            pSSParameters.engineInit(pSSParameterSpec3);
            byte[] byArray = pSSParameters.engineGetEncoded();
            pSSParameters.engineInit(pSSParameterSpec);
            byte[] byArray2 = pSSParameters.engineGetEncoded();
            return Arrays.equals(byArray, byArray2);
        }
        catch (Exception exception) {
            if (a != null) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    private void b(RSAKey rSAKey) throws InvalidKeyException {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = rSAKey.getParams();
            if (!RSAPSSSignature.a(rSAKey.getParams(), this.m)) {
                throw new InvalidKeyException(z[70]);
            }
            if (this.m != null) {
                Integer n2 = c.get(this.m.getDigestAlgorithm());
                if (n2 == null) {
                    throw new ProviderException(z[71] + this.m.getDigestAlgorithm());
                }
                RSAPSSSignature.a(rSAKey, n2, this.m.getSaltLength());
            }
            return;
        }
        catch (SignatureException signatureException) {
            throw new InvalidKeyException(signatureException);
        }
    }

    private PSSParameterSpec a(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        Key key;
        PSSParameterSpec pSSParameterSpec;
        block24: {
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException(z[58]);
            }
            if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
                throw new InvalidAlgorithmParameterException(z[59]);
            }
            pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            if (pSSParameterSpec == this.m) {
                return pSSParameterSpec;
            }
            Key key2 = this.k == null ? this.l : this.k;
            key = key2;
            if (key == null || RSAPSSSignature.a(key.getParams(), pSSParameterSpec)) break block24;
            throw new InvalidAlgorithmParameterException(z[55]);
        }
        if (!pSSParameterSpec.getMGFAlgorithm().equalsIgnoreCase(z[56])) {
            throw new InvalidAlgorithmParameterException(z[57]);
        }
        if (pSSParameterSpec.getTrailerField() != 1) {
            throw new InvalidAlgorithmParameterException(z[54]);
        }
        String string = pSSParameterSpec.getDigestAlgorithm();
        if (key != null) {
            try {
                int n2 = c.get(string);
                RSAPSSSignature.a((RSAKey)((Object)key), n2, pSSParameterSpec.getSaltLength());
            }
            catch (SignatureException signatureException) {
                throw new InvalidAlgorithmParameterException(signatureException);
            }
        }
        return pSSParameterSpec;
    }

    private void d() throws SignatureException {
        Key key = this.k == null ? this.l : this.k;
        Key key2 = key;
        if (key2 == null) {
            throw new SignatureException(z[5]);
        }
        if (this.m == null) {
            throw new SignatureException(z[6]);
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block187: {
            block186: {
                v0 = new String[73];
                v1 = v0;
                v2 = v0;
                v3 = 0;
                v4 = ">+5\u0019C]*/\u0001\u0007\u000e-'\u001b\u0007\u0019%4\u0014";
                v5 = -1;
                break block186;
lbl8:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 1;
                    v4 = "]*/\u0001\u0007\u001c2!\u001cK\u001c&,\u0010";
                    v5 = 0;
                    break block186;
                    break;
                }
lbl16:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 2;
                    v4 = "9-'\u0010T\td";
                    v5 = 1;
                    break block186;
                    break;
                }
lbl24:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 3;
                    v4 = "(*3\u0000W\r+2\u0001B\u0019d\r2a]%,\u0012HGd";
                    v5 = 2;
                    break block186;
                    break;
                }
lbl32:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 4;
                    v4 = "0\u0003\u0006D";
                    v5 = 3;
                    break block186;
                    break;
                }
lbl40:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 5;
                    v4 = "0-3\u0006N\u0013#`\u001eB\u0004";
                    v5 = 4;
                    break block186;
                    break;
                }
lbl48:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 6;
                    v4 = "-%2\u0014J\u00180%\u0007T]6%\u0004R\u00146%\u0011\u0007\u001b+2Uu.\u0005\u0013&fP\u0014\u0013&\u0007\u000e-'\u001bF\t12\u0010T";
                    v5 = 5;
                    break block186;
                    break;
                }
lbl56:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 7;
                    v4 = ".\f\u0001F";
                    v5 = 6;
                    break block186;
                    break;
                }
lbl64:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 8;
                    v4 = ".\f\u0001G\u0012K";
                    v5 = 7;
                    break block186;
                    break;
                }
lbl72:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 9;
                    v4 = ".\f\u0001F\u001fI";
                    v5 = 8;
                    break block186;
                    break;
                }
lbl80:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 10;
                    v4 = ".\f\u0001G\u0015I";
                    v5 = 9;
                    break block186;
                    break;
                }
lbl88:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 11;
                    v4 = ".\f\u0001G\u0015I";
                    v5 = 10;
                    break block186;
                    break;
                }
lbl96:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 12;
                    v4 = ".\f\u0001X\u0015Hr";
                    v5 = 11;
                    break block186;
                    break;
                }
lbl104:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 13;
                    v4 = ".\f\u0001X\u0012Lv";
                    v5 = 12;
                    break block186;
                    break;
                }
lbl112:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 14;
                    v4 = ".\f\u0001D";
                    v5 = 13;
                    break block186;
                    break;
                }
lbl120:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 15;
                    v4 = ".\f\u0001G";
                    v5 = 14;
                    break block186;
                    break;
                }
lbl128:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 16;
                    v4 = ".\f\u0001@";
                    v5 = 15;
                    break block186;
                    break;
                }
lbl136:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 17;
                    v4 = ".\f\u0001F";
                    v5 = 16;
                    break block186;
                    break;
                }
lbl144:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 18;
                    v4 = "),%UJ\u001873\u0014@\u0018d$\u001c@\u001874UP\u00140(\u001cI]0(\u0010\u0007-\u0017\u0013%F\u000f%-\u0010S\u00186\u0013\u0005B\u001ed$\u001aB\u000ed.\u001aS])!\u0001D\u0015d4\u001dB]\t\u00073\u0007\u0010!3\u0006F\u001a!`\u0011N\u001a!3\u0001\t";
                    v5 = 17;
                    break block186;
                    break;
                }
lbl152:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 19;
                    v4 = ".\f\u0001X\u0012LvoG\u0015I";
                    v5 = 18;
                    break block186;
                    break;
                }
lbl160:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 20;
                    v4 = ".\f\u0001@\u0016OkrG\u0013";
                    v5 = 19;
                    break block186;
                    break;
                }
lbl168:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 21;
                    v4 = ".\f\u0001X\u0015Hr";
                    v5 = 20;
                    break block186;
                    break;
                }
lbl176:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 22;
                    v4 = ".\f\u0001@\u0016O";
                    v5 = 21;
                    break block186;
                    break;
                }
lbl184:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 23;
                    v4 = ".\f\u0001G";
                    v5 = 22;
                    break block186;
                    break;
                }
lbl192:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 24;
                    v4 = ">%.\u001bH\td3\u0010S]4!\u0007F\u0010!4\u0010U\u000ed$\u0000U\u0014*'UH\r!2\u0014S\u0014+.\u0006";
                    v5 = 23;
                    break block186;
                    break;
                }
lbl200:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 25;
                    v4 = ".\f\u0001@\u0016OkrG\u0013";
                    v5 = 24;
                    break block186;
                    break;
                }
lbl208:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 26;
                    v4 = ".\f\u0001@";
                    v5 = 25;
                    break block186;
                    break;
                }
lbl216:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 27;
                    v4 = ".\f\u0001";
                    v5 = 26;
                    break block186;
                    break;
                }
lbl224:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 28;
                    v4 = ".\f\u0001";
                    v5 = 27;
                    break block186;
                    break;
                }
lbl232:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 29;
                    v4 = ".\f\u0001X\u0012Lv";
                    v5 = 28;
                    break block186;
                    break;
                }
lbl240:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 30;
                    v4 = ".\f\u0001@\u0016Okr@\u0011";
                    v5 = 29;
                    break block186;
                    break;
                }
lbl248:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 31;
                    v4 = ".\f\u0001X\u0015Op";
                    v5 = 30;
                    break block186;
                    break;
                }
lbl256:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 32;
                    v4 = ".\f\u0001X\u0016";
                    v5 = 31;
                    break block186;
                    break;
                }
lbl264:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 33;
                    v4 = ".\f\u0001G\u0012K";
                    v5 = 32;
                    break block186;
                    break;
                }
lbl272:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 34;
                    v4 = ".\f\u0001X\u0012LvoG\u0012K";
                    v5 = 33;
                    break block186;
                    break;
                }
lbl280:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 35;
                    v4 = ".\f\u0001@\u0016Okr@\u0011";
                    v5 = 34;
                    break block186;
                    break;
                }
lbl288:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 36;
                    v4 = ".\f\u0001D";
                    v5 = 35;
                    break block186;
                    break;
                }
lbl296:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 37;
                    v4 = ".\f\u0001X\u0012LvoG\u0012K";
                    v5 = 36;
                    break block186;
                    break;
                }
lbl304:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 38;
                    v4 = ".\f\u0001X\u0012LvoG\u0015I";
                    v5 = 37;
                    break block186;
                    break;
                }
lbl312:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 39;
                    v4 = ".\f\u0001X\u0016";
                    v5 = 38;
                    break block186;
                    break;
                }
lbl320:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 40;
                    v4 = ".\f\u0001F\u001fI";
                    v5 = 39;
                    break block186;
                    break;
                }
lbl328:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 41;
                    v4 = ".\f\u0001@\u0016O";
                    v5 = 40;
                    break block186;
                    break;
                }
lbl336:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 42;
                    v4 = ".\f\u0001X\u0014Ep";
                    v5 = 41;
                    break block186;
                    break;
                }
lbl344:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 43;
                    v4 = ".\f\u0001X\u0015Op";
                    v5 = 42;
                    break block186;
                    break;
                }
lbl352:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 44;
                    v4 = ".\f\u0001X\u0014Ep";
                    v5 = 43;
                    break block186;
                    break;
                }
lbl360:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 45;
                    v4 = "MurF\u0013HrwM\u001e\u001c&#\u0011B\u001b";
                    v5 = 44;
                    break block186;
                    break;
                }
lbl368:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 46;
                    v4 = "4\u0006\r?d8";
                    v5 = 45;
                    break block186;
                    break;
                }
lbl376:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 47;
                    v4 = "/\u0017\u0001%t.";
                    v5 = 46;
                    break block186;
                    break;
                }
lbl384:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 48;
                    v4 = "4\u0006\r?d8d#\u0014K\u0011!$Y\u0007\u001f14UI\u00120`\u0016H\u0013\")\u0012R\u000f!$";
                    v5 = 47;
                    break block186;
                    break;
                }
lbl392:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 49;
                    v4 = "]&5\u0001\u0007\n%3UB\u00054%\u0016S\u0014*'U";
                    v5 = 48;
                    break block186;
                    break;
                }
lbl400:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 50;
                    v4 = ".-'\u001bF\t12\u0010\u0007\u0018*#\u001aC\u0014*'UB\u000f6/\u0007";
                    v5 = 49;
                    break block186;
                    break;
                }
lbl408:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 51;
                    v4 = "]\u0017)\u0012I\u001c05\u0007B](%\u001b@\t,`\u001bH\td#\u001aU\u000f!#\u0001\u001d]#/\u0001\u0007";
                    v5 = 50;
                    break block186;
                    break;
                }
lbl416:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 52;
                    v4 = "]&5\u0001\u0007\n%3UB\u00054%\u0016S\u0014*'U";
                    v5 = 51;
                    break block186;
                    break;
                }
lbl424:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 53;
                    v4 = "]\u0017)\u0012I\u001c05\u0007B](%\u001b@\t,`\u001bH\td#\u001aU\u000f!#\u0001\u001d]#/\u0001\u0007";
                    v5 = 52;
                    break block186;
                    break;
                }
lbl432:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 54;
                    v4 = "2*,\f\u0007\u000e10\u0005H\u000f03Us\u000f%)\u0019B\u000f\u0002)\u0010K\u0019\u0006\u0003]\u0016T";
                    v5 = 53;
                    break block186;
                    break;
                }
lbl440:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 55;
                    v4 = ".-'\u001bF\t12\u0010\u0007\r%2\u0014J\u00180%\u0007T] /\u0010T]*/\u0001\u0007\u0010%4\u0016O]/%\f\u0007\r%2\u0014J\u00180%\u0007T";
                    v5 = 54;
                    break block186;
                    break;
                }
lbl448:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 56;
                    v4 = "0\u0003\u0006D";
                    v5 = 55;
                    break block186;
                    break;
                }
lbl456:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 57;
                    v4 = "2*,\f\u0007\u000e10\u0005H\u000f03Uj:\u0002q";
                    v5 = 56;
                    break block186;
                    break;
                }
lbl464:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 58;
                    v4 = "-%2\u0014J\u00180%\u0007T]'!\u001bI\u00120`\u0017B]*5\u0019K";
                    v5 = 57;
                    break block186;
                    break;
                }
lbl472:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 59;
                    v4 = "\r%2\u0014J\u00180%\u0007T])5\u0006S]&%US\u00044%Uw.\u0017\u0010\u0014U\u001c)%\u0001B\u000f\u00170\u0010D";
                    v5 = 58;
                    break block186;
                    break;
                }
lbl480:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 60;
                    v4 = "0\u0003\u0006D";
                    v5 = 59;
                    break block186;
                    break;
                }
lbl488:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 61;
                    v4 = ".\f\u0001X\u0016";
                    v5 = 60;
                    break block186;
                    break;
                }
lbl496:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 62;
                    v4 = "\u001a!4%F\u000f%-\u0010S\u00186h\\\u0007\u0013+4UT\b40\u001aU\t!$";
                    v5 = 61;
                    break block186;
                    break;
                }
lbl504:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 63;
                    v4 = "6!9UN\u000ed4\u001aH]7(\u001aU\th`\u001bB\u0018 `\u0018N\u0013d";
                    v5 = 62;
                    break block186;
                    break;
                }
lbl512:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 64;
                    v4 = "\u000e!4%F\u000f%-\u0010S\u00186h\\\u0007\u0013+4UT\b40\u001aU\t!$";
                    v5 = 63;
                    break block186;
                    break;
                }
lbl520:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 65;
                    v4 = ".\f\u0001";
                    v5 = 64;
                    break block186;
                    break;
                }
lbl528:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 66;
                    v4 = ".\f\u0001D";
                    v5 = 65;
                    break block186;
                    break;
                }
lbl536:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 67;
                    v4 = ".\f\u0001";
                    v5 = 66;
                    break block186;
                    break;
                }
lbl544:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 68;
                    v4 = "(*3\u0000W\r+2\u0001B\u0019d$\u001c@\u001874UF\u0011#/\u0007N\t,-U";
                    v5 = 67;
                    break block186;
                    break;
                }
lbl552:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 69;
                    v4 = ".\f\u0001X\u0016";
                    v5 = 68;
                    break block186;
                    break;
                }
lbl560:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 70;
                    v4 = "6!9UD\u0012*4\u0014N\u00137`\u001cI\u001e+-\u0005F\t-\"\u0019B]\u0014\u0013&\u0007\r%2\u0014J\u00180%\u0007\u0007\u000b%,\u0000B\u000e";
                    v5 = 69;
                    break block186;
                    break;
                }
lbl568:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 71;
                    v4 = "(*3\u0000W\r+2\u0001B\u0019d$\u001c@\u001874UF\u0011#/O\u0007";
                    v5 = 70;
                    break block186;
                    break;
                }
lbl576:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 72;
                    v4 = "\u0018*#\u001aC\u0014*'UB\u000f6/\u0007";
                    v5 = 71;
                    break block186;
                    break;
                }
lbl584:
                // 1 sources

                while (true) {
                    continue;
                    break;
                }
            }
            v7 = v4.toCharArray();
            v8 = v7;
            v9 = v7.length;
            var0 = 0;
            if (true) ** GOTO lbl613
            do {
                v8 = v8;
                v10 = var0;
                v11 = v8[v10];
                switch (var0 % 5) {
                    case 0: {
                        v12 = 125;
                        break;
                    }
                    case 1: {
                        v12 = 68;
                        break;
                    }
                    case 2: {
                        v12 = 64;
                        break;
                    }
                    case 3: {
                        v12 = 117;
                        break;
                    }
                    default: {
                        v12 = 39;
                    }
                }
                v8[v10] = (char)(v11 ^ v12);
                ++var0;
lbl613:
                // 2 sources

                v9 = v9;
            } while (v9 > var0);
            v6 = new String(v8);
            switch (v5) {
                default: {
                    ** continue;
                }
                case 0: {
                    ** continue;
                }
                case 1: {
                    ** continue;
                }
                case 2: {
                    ** continue;
                }
                case 3: {
                    ** continue;
                }
                case 4: {
                    ** continue;
                }
                case 5: {
                    ** continue;
                }
                case 6: {
                    ** continue;
                }
                case 7: {
                    ** continue;
                }
                case 8: {
                    ** continue;
                }
                case 9: {
                    ** continue;
                }
                case 10: {
                    ** continue;
                }
                case 11: {
                    ** continue;
                }
                case 12: {
                    ** continue;
                }
                case 13: {
                    ** continue;
                }
                case 14: {
                    ** continue;
                }
                case 15: {
                    ** continue;
                }
                case 16: {
                    ** continue;
                }
                case 17: {
                    ** continue;
                }
                case 18: {
                    ** continue;
                }
                case 19: {
                    ** continue;
                }
                case 20: {
                    ** continue;
                }
                case 21: {
                    ** continue;
                }
                case 22: {
                    ** continue;
                }
                case 23: {
                    ** continue;
                }
                case 24: {
                    ** continue;
                }
                case 25: {
                    ** continue;
                }
                case 26: {
                    ** continue;
                }
                case 27: {
                    ** continue;
                }
                case 28: {
                    ** continue;
                }
                case 29: {
                    ** continue;
                }
                case 30: {
                    ** continue;
                }
                case 31: {
                    ** continue;
                }
                case 32: {
                    ** continue;
                }
                case 33: {
                    ** continue;
                }
                case 34: {
                    ** continue;
                }
                case 35: {
                    ** continue;
                }
                case 36: {
                    ** continue;
                }
                case 37: {
                    ** continue;
                }
                case 38: {
                    ** continue;
                }
                case 39: {
                    ** continue;
                }
                case 40: {
                    ** continue;
                }
                case 41: {
                    ** continue;
                }
                case 42: {
                    ** continue;
                }
                case 43: {
                    ** continue;
                }
                case 44: {
                    ** continue;
                }
                case 45: {
                    ** continue;
                }
                case 46: {
                    ** continue;
                }
                case 47: {
                    ** continue;
                }
                case 48: {
                    ** continue;
                }
                case 49: {
                    ** continue;
                }
                case 50: {
                    ** continue;
                }
                case 51: {
                    ** continue;
                }
                case 52: {
                    ** continue;
                }
                case 53: {
                    ** continue;
                }
                case 54: {
                    ** continue;
                }
                case 55: {
                    ** continue;
                }
                case 56: {
                    ** continue;
                }
                case 57: {
                    ** continue;
                }
                case 58: {
                    ** continue;
                }
                case 59: {
                    ** continue;
                }
                case 60: {
                    ** continue;
                }
                case 61: {
                    ** continue;
                }
                case 62: {
                    ** continue;
                }
                case 63: {
                    ** continue;
                }
                case 64: {
                    ** continue;
                }
                case 65: {
                    ** continue;
                }
                case 66: {
                    ** continue;
                }
                case 67: {
                    ** continue;
                }
                case 68: {
                    ** continue;
                }
                case 69: {
                    ** continue;
                }
                case 70: {
                    ** continue;
                }
                ** case 71:
lbl763:
                // 1 sources

                ** continue;
            }
lbl764:
            // 16 sources

            while (true) {
                v13 = v14.toCharArray();
                v15 = v13;
                v16 = v13.length;
                var0 = 0;
                if (true) ** GOTO lbl791
                do {
                    v15 = v15;
                    v17 = var0;
                    v18 = v15[v17];
                    switch (var0 % 5) {
                        case 0: {
                            v19 = 125;
                            break;
                        }
                        case 1: {
                            v19 = 68;
                            break;
                        }
                        case 2: {
                            v19 = 64;
                            break;
                        }
                        case 3: {
                            v19 = 117;
                            break;
                        }
                        default: {
                            v19 = 39;
                        }
                    }
                    v15[v17] = (char)(v18 ^ v19);
                    ++var0;
lbl791:
                    // 2 sources

                    v16 = v16;
                } while (v16 > var0);
                break block187;
                break;
            }
            v1[v3] = v6.intern();
            RSAPSSSignature.z = v2;
            v20 = "\u0014&-\u001fD\u0018".toCharArray();
            v21 = v20;
            v22 = v20.length;
            var0 = 0;
            if (true) ** GOTO lbl822
            do {
                v21 = v21;
                v23 = var0;
                v24 = v21[v23];
                switch (var0 % 5) {
                    case 0: {
                        v25 = 125;
                        break;
                    }
                    case 1: {
                        v25 = 68;
                        break;
                    }
                    case 2: {
                        v25 = 64;
                        break;
                    }
                    case 3: {
                        v25 = 117;
                        break;
                    }
                    default: {
                        v25 = 39;
                    }
                }
                v21[v23] = (char)(v24 ^ v25);
                ++var0;
lbl822:
                // 2 sources

                v22 = v22;
            } while (v22 > var0);
            RSAPSSSignature.a = Debug.getInstance((String)new String(v21).intern());
            v26 = RSAPSSSignature.c = new Hashtable<K, V>();
            v14 = ".\f\u0001X\u0016";
            v27 = -1;
            ** GOTO lbl764
        }
        v28 = new String(v15).intern();
        switch (v27) {
            default: {
                v26.put(v28, 20);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001";
                v27 = 0;
                ** GOTO lbl764
            }
            case 0: {
                v26.put(v28, 20);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001D";
                v27 = 1;
                ** GOTO lbl764
            }
            case 1: {
                v26.put(v28, 20);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001X\u0015Op";
                v27 = 2;
                ** GOTO lbl764
            }
            case 2: {
                v26.put(v28, 28);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001G\u0015I";
                v27 = 3;
                ** GOTO lbl764
            }
            case 3: {
                v26.put(v28, 28);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001X\u0015Hr";
                v27 = 4;
                ** GOTO lbl764
            }
            case 4: {
                v26.put(v28, 32);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001G\u0012K";
                v27 = 5;
                ** GOTO lbl764
            }
            case 5: {
                v26.put(v28, 32);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001X\u0014Ep";
                v27 = 6;
                ** GOTO lbl764
            }
            case 6: {
                v26.put(v28, 48);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001F\u001fI";
                v27 = 7;
                ** GOTO lbl764
            }
            case 7: {
                v26.put(v28, 48);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001X\u0012Lv";
                v27 = 8;
                ** GOTO lbl764
            }
            case 8: {
                v26.put(v28, 64);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001@\u0016O";
                v27 = 9;
                ** GOTO lbl764
            }
            case 9: {
                v26.put(v28, 64);
                v26 = RSAPSSSignature.c;
                v14 = "0\u0000u";
                v27 = 10;
                ** GOTO lbl764
            }
            case 10: {
                v26.put(v28, 16);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001X\u0012LvoG\u0015I";
                v27 = 11;
                ** GOTO lbl764
            }
            case 11: {
                v26.put(v28, 28);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001@\u0016OkrG\u0013";
                v27 = 12;
                ** GOTO lbl764
            }
            case 12: {
                v26.put(v28, 28);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001X\u0012LvoG\u0012K";
                v27 = 13;
                ** GOTO lbl764
            }
            case 13: {
                v26.put(v28, 32);
                v26 = RSAPSSSignature.c;
                v14 = ".\f\u0001@\u0016Okr@\u0011";
                v27 = 14;
                ** continue;
            }
            case 14: 
        }
        v26.put(v28, 32);
    }
}

