/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.IBMJCE;
import com.ibm.crypto.provider.PBKDF2KeyImpl$1;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

final class PBKDF2KeyImpl
implements PBEKey {
    private static final long serialVersionUID = -2234868909660948157L;
    private char[] passwd;
    private final byte[] salt;
    private final int iterCount;
    private byte[] key;
    private final Mac prf;
    private static final String[] z;

    private static byte[] a(char[] cArray) {
        Charset charset = Charset.forName(z[3]);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        int n2 = byteBuffer.limit();
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray, 0, n2);
        return byArray;
    }

    PBKDF2KeyImpl(PBEKeySpec pBEKeySpec, String string) throws InvalidKeySpecException {
        char[] cArray = pBEKeySpec.getPassword();
        this.passwd = cArray == null ? new char[0] : (char[])cArray.clone();
        byte[] byArray = PBKDF2KeyImpl.a(this.passwd);
        this.salt = pBEKeySpec.getSalt();
        if (this.salt == null) {
            throw new InvalidKeySpecException(z[10]);
        }
        this.iterCount = pBEKeySpec.getIterationCount();
        if (this.iterCount == 0) {
            throw new InvalidKeySpecException(z[7]);
        }
        if (this.iterCount < 0) {
            throw new InvalidKeySpecException(z[9]);
        }
        int n2 = pBEKeySpec.getKeyLength();
        if (n2 == 0) {
            throw new InvalidKeySpecException(z[6]);
        }
        if (n2 < 0) {
            throw new InvalidKeySpecException(z[8]);
        }
        try {
            this.prf = Mac.getInstance(string, IBMJCE.getInstance());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(noSuchAlgorithmException);
            throw invalidKeySpecException;
        }
        this.key = PBKDF2KeyImpl.a(this.prf, byArray, this.salt, this.iterCount, n2);
    }

    private static byte[] a(Mac mac, byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = n3 / 8;
        byte[] byArray3 = new byte[n4];
        try {
            int n5 = mac.getMacLength();
            int n6 = (n4 + n5 - 1) / n5;
            int n7 = n4 - (n6 - 1) * n5;
            byte[] byArray4 = new byte[n5];
            byte[] byArray5 = new byte[n5];
            String string = mac.getAlgorithm();
            PBKDF2KeyImpl$1 pBKDF2KeyImpl$1 = new PBKDF2KeyImpl$1(string, byArray);
            mac.init(pBKDF2KeyImpl$1);
            byte[] byArray6 = new byte[4];
            for (int i2 = 1; i2 <= n6; ++i2) {
                mac.update(byArray2);
                byArray6[3] = (byte)i2;
                byArray6[2] = (byte)(i2 >> 8 & 0xFF);
                byArray6[1] = (byte)(i2 >> 16 & 0xFF);
                byArray6[0] = (byte)(i2 >> 24 & 0xFF);
                mac.update(byArray6);
                mac.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
                for (int i3 = 2; i3 <= n2; ++i3) {
                    mac.update(byArray4);
                    mac.doFinal(byArray4, 0);
                    for (int i4 = 0; i4 < byArray4.length; ++i4) {
                        int n8 = i4;
                        byArray5[n8] = (byte)(byArray5[n8] ^ byArray4[i4]);
                    }
                    continue;
                }
                if (i2 == n6) {
                    System.arraycopy(byArray5, 0, byArray3, (i2 - 1) * n5, n7);
                    continue;
                }
                System.arraycopy(byArray5, 0, byArray3, (i2 - 1) * n5, n5);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(z[2]);
        }
        return byArray3;
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return z[0] + this.prf.getAlgorithm();
    }

    @Override
    public int getIterationCount() {
        return this.iterCount;
    }

    @Override
    public synchronized char[] getPassword() {
        return (char[])this.passwd.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public String getFormat() {
        return z[1];
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return n2 ^= this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().equalsIgnoreCase(this.getAlgorithm())) {
            return false;
        }
        if (!secretKey.getFormat().equalsIgnoreCase(z[5])) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl2 = MessageDigest.isEqual(this.key, secretKey.getEncoded());
        Arrays.fill(byArray, (byte)0);
        return bl2;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException(z[4]);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.passwd != null) {
                Arrays.fill(this.passwd, '0');
                this.passwd = null;
            }
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[11];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "S\u00106rj1\u0005\u0014BD";
        int n3 = -1;
        block18: while (true) {
            char[] cArray;
            block22: {
                int n4;
                int n5;
                block21: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block21;
                    n5 = n5;
                    if (n5 <= n4) break block22;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 3;
                            break;
                        }
                        case 1: {
                            n6 = 82;
                            break;
                        }
                        case 2: {
                            n6 = 125;
                            break;
                        }
                        case 3: {
                            n6 = 54;
                            break;
                        }
                        default: {
                            n6 = 44;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Q\u0013*";
                    n3 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "F \u000fY^#6\u0018DEu;\u0013Q\fS\u00106rj1r\u0016SUp";
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "V\u0006;\u001b\u0014";
                    n3 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "S\u00106rj1\u0019\u0018Oen\"\u0011\u0016Gf+\u000e\u0016Mq7]XCwr\u0019_^f1\tZU#6\u0018EIq;\u001cZEy3\u001fZI";
                    n3 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "Q\u0013*";
                    n3 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "H7\u0004\u0016@f<\u001aBD#<\u0012B\fe=\bXH";
                    n3 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "J&\u0018DMw;\u0012X\f`=\bXX#<\u0012B\fe=\bXH";
                    n3 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "H7\u0004\u0016@f<\u001aBD#;\u000e\u0016Bf5\u001cBEu7";
                    n3 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "J&\u0018DMw;\u0012X\f`=\bXX#;\u000e\u0016Bf5\u001cBEu7";
                    n3 = 8;
                    continue block18;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "P3\u0011B\fm=\t\u0016Jl'\u0013R";
                    n3 = 9;
                    continue block18;
                }
                case 9: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

