/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.Sides;
import sun.awt.CharsetString;
import sun.awt.FontConfiguration;
import sun.awt.PlatformFont;
import sun.awt.SunToolkit;
import sun.font.FontUtilities;
import sun.print.CustomMediaTray;
import sun.print.PSPathGraphics;
import sun.print.PSStreamPrintService;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;

public class PSPrinterJob
extends RasterPrinterJob {
    protected static final int FILL_EVEN_ODD = 1;
    protected static final int FILL_WINDING = 2;
    private static final int MAX_PSSTR = 65535;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int LOWNIBBLE_MASK = 15;
    private static final int HINIBBLE_MASK = 240;
    private static final int HINIBBLE_SHIFT = 4;
    private static final byte[] hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int PS_XRES = 300;
    private static final int PS_YRES = 300;
    private static final String ADOBE_PS_STR = "%!PS-Adobe-3.0";
    private static final String EOF_COMMENT = "%%EOF";
    private static final String PAGE_COMMENT = "%%Page: ";
    private static final String READIMAGEPROC = "/imStr 0 def /imageSrc {currentfile /ASCII85Decode filter /RunLengthDecode filter  imStr readstring pop } def";
    private static final String COPIES = "/#copies exch def";
    private static final String PAGE_SAVE = "/pgSave save def";
    private static final String PAGE_RESTORE = "pgSave restore";
    private static final String SHOWPAGE = "showpage";
    private static final String IMAGE_SAVE = "/imSave save def";
    private static final String IMAGE_STR = " string /imStr exch def";
    private static final String IMAGE_RESTORE = "imSave restore";
    private static final String COORD_PREP = " 0 exch translate 1 -1 scale[72 300 div 0 0 72 300 div 0 0]concat";
    private static final String SetFontName = "F";
    private static final String DrawStringName = "S";
    private static final String EVEN_ODD_FILL_STR = "EF";
    private static final String WINDING_FILL_STR = "WF";
    private static final String EVEN_ODD_CLIP_STR = "EC";
    private static final String WINDING_CLIP_STR = "WC";
    private static final String MOVETO_STR = " M";
    private static final String LINETO_STR = " L";
    private static final String CURVETO_STR = " C";
    private static final String GRESTORE_STR = "R";
    private static final String GSAVE_STR = "G";
    private static final String NEWPATH_STR = "N";
    private static final String CLOSEPATH_STR = "P";
    private static final String SETRGBCOLOR_STR = " SC";
    private static final String SETGRAY_STR = " SG";
    private int mDestType;
    private String mDestination = "lp";
    private boolean mNoJobSheet = false;
    private String mOptions;
    private Font mLastFont;
    private Color mLastColor;
    private Shape mLastClip;
    private AffineTransform mLastTransform;
    private EPSPrinter epsPrinter = null;
    FontMetrics mCurMetrics;
    PrintStream mPSStream;
    File spoolFile;
    private String mFillOpStr = "WF";
    private String mClipOpStr = "WC";
    ArrayList mGStateStack = new ArrayList();
    private float mPenX;
    private float mPenY;
    private float mStartPathX;
    private float mStartPathY;
    private static Properties mFontProps = null;
    private static boolean isMac;

    private static Properties initProps() {
        String string = System.getProperty("java.home");
        if (string != null) {
            String string2 = SunToolkit.getStartupLocale().getLanguage();
            try {
                File file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties." + string2);
                if (!(file.canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties." + string2)).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties")).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties")).canRead())) {
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                Properties properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return properties;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        this.attributes.add(new Copies(this.getCopies()));
        this.attributes.add(new JobName(this.getJobName(), null));
        boolean bl = false;
        DialogTypeSelection dialogTypeSelection = (DialogTypeSelection)this.attributes.get(DialogTypeSelection.class);
        if (dialogTypeSelection == DialogTypeSelection.NATIVE) {
            this.attributes.remove(DialogTypeSelection.class);
            bl = this.printDialog(this.attributes);
            this.attributes.add(DialogTypeSelection.NATIVE);
        } else {
            bl = this.printDialog(this.attributes);
        }
        if (bl) {
            Destination destination;
            Copies copies;
            JobName jobName = (JobName)this.attributes.get(JobName.class);
            if (jobName != null) {
                this.setJobName(jobName.getValue());
            }
            if ((copies = (Copies)this.attributes.get(Copies.class)) != null) {
                this.setCopies(copies.getValue());
            }
            if ((destination = (Destination)this.attributes.get(Destination.class)) != null) {
                try {
                    this.mDestType = 1;
                    this.mDestination = new File(destination.getURI()).getPath();
                }
                catch (Exception exception) {
                    this.mDestination = "out.ps";
                }
            } else {
                this.mDestType = 0;
                PrintService printService = this.getPrintService();
                if (printService != null) {
                    PrintServiceAttributeSet printServiceAttributeSet;
                    this.mDestination = printService.getName();
                    if (isMac && (printServiceAttributeSet = printService.getAttributes()) != null) {
                        this.mDestination = printServiceAttributeSet.get(PrinterName.class).toString();
                    }
                }
            }
        }
        return bl;
    }

    @Override
    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        CustomMediaTray customMediaTray;
        String string;
        super.setAttributes(printRequestAttributeSet);
        if (printRequestAttributeSet == null) {
            return;
        }
        Attribute attribute = printRequestAttributeSet.get(Media.class);
        if (attribute instanceof CustomMediaTray && (string = (customMediaTray = (CustomMediaTray)attribute).getChoiceName()) != null) {
            this.mOptions = " InputSlot=" + string;
        }
    }

    @Override
    protected void startDoc() throws PrinterException {
        if (this.epsPrinter == null) {
            OutputStream outputStream;
            Object object;
            if (this.getPrintService() instanceof PSStreamPrintService) {
                object = (StreamPrintService)this.getPrintService();
                this.mDestType = 2;
                if (((StreamPrintService)object).isDisposed()) {
                    throw new PrinterException("service is disposed");
                }
                outputStream = ((StreamPrintService)object).getOutputStream();
                if (outputStream == null) {
                    throw new PrinterException("Null output stream");
                }
            } else {
                this.mNoJobSheet = this.noJobSheet;
                if (this.destinationAttr != null) {
                    this.mDestType = 1;
                    this.mDestination = this.destinationAttr;
                }
                if (this.mDestType == 1) {
                    try {
                        this.spoolFile = new File(this.mDestination);
                        outputStream = new FileOutputStream(this.spoolFile);
                    }
                    catch (IOException iOException) {
                        throw new PrinterIOException(iOException);
                    }
                } else {
                    object = new PrinterOpener();
                    AccessController.doPrivileged(object);
                    if (((PrinterOpener)object).pex != null) {
                        throw ((PrinterOpener)object).pex;
                    }
                    outputStream = ((PrinterOpener)object).result;
                }
            }
            this.mPSStream = new PrintStream(new BufferedOutputStream(outputStream));
            this.mPSStream.println(ADOBE_PS_STR);
        }
        this.mPSStream.println("%%BeginProlog");
        this.mPSStream.println(READIMAGEPROC);
        this.mPSStream.println("/BD {bind def} bind def");
        this.mPSStream.println("/D {def} BD");
        this.mPSStream.println("/C {curveto} BD");
        this.mPSStream.println("/L {lineto} BD");
        this.mPSStream.println("/M {moveto} BD");
        this.mPSStream.println("/R {grestore} BD");
        this.mPSStream.println("/G {gsave} BD");
        this.mPSStream.println("/N {newpath} BD");
        this.mPSStream.println("/P {closepath} BD");
        this.mPSStream.println("/EC {eoclip} BD");
        this.mPSStream.println("/WC {clip} BD");
        this.mPSStream.println("/EF {eofill} BD");
        this.mPSStream.println("/WF {fill} BD");
        this.mPSStream.println("/SG {setgray} BD");
        this.mPSStream.println("/SC {setrgbcolor} BD");
        this.mPSStream.println("/ISOF {");
        this.mPSStream.println("     dup findfont dup length 1 add dict begin {");
        this.mPSStream.println("             1 index /FID eq {pop pop} {D} ifelse");
        this.mPSStream.println("     } forall /Encoding ISOLatin1Encoding D");
        this.mPSStream.println("     currentdict end definefont");
        this.mPSStream.println("} BD");
        this.mPSStream.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.mPSStream.println("/S {");
        this.mPSStream.println("     moveto 1 index stringwidth pop NZ sub");
        this.mPSStream.println("     1 index length 1 sub NZ div 0");
        this.mPSStream.println("     3 2 roll ashow newpath} BD");
        this.mPSStream.println("/FL [");
        if (mFontProps == null) {
            this.mPSStream.println(" /Helvetica ISOF");
            this.mPSStream.println(" /Helvetica-Bold ISOF");
            this.mPSStream.println(" /Helvetica-Oblique ISOF");
            this.mPSStream.println(" /Helvetica-BoldOblique ISOF");
            this.mPSStream.println(" /Times-Roman ISOF");
            this.mPSStream.println(" /Times-Bold ISOF");
            this.mPSStream.println(" /Times-Italic ISOF");
            this.mPSStream.println(" /Times-BoldItalic ISOF");
            this.mPSStream.println(" /Courier ISOF");
            this.mPSStream.println(" /Courier-Bold ISOF");
            this.mPSStream.println(" /Courier-Oblique ISOF");
            this.mPSStream.println(" /Courier-BoldOblique ISOF");
        } else {
            int n = Integer.parseInt(mFontProps.getProperty("font.num", "9"));
            for (int i = 0; i < n; ++i) {
                this.mPSStream.println("    /" + mFontProps.getProperty("font." + String.valueOf(i), "Courier ISOF"));
            }
        }
        this.mPSStream.println("] D");
        this.mPSStream.println("/F {");
        this.mPSStream.println("     FL exch get exch scalefont");
        this.mPSStream.println("     [1 0 0 -1 0 0] makefont setfont} BD");
        this.mPSStream.println("%%EndProlog");
        this.mPSStream.println("%%BeginSetup");
        if (this.epsPrinter == null) {
            PageFormat pageFormat = this.getPageable().getPageFormat(0);
            double d = pageFormat.getPaper().getHeight();
            double d2 = pageFormat.getPaper().getWidth();
            this.mPSStream.print("<< /PageSize [" + d2 + " " + d + "]");
            final PrintService printService = this.getPrintService();
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> clazz = Class.forName("sun.print.IPPPrintService");
                        if (clazz.isInstance(printService)) {
                            Method method = clazz.getMethod("isPostscript", null);
                            return (Boolean)method.invoke(printService, null);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return Boolean.TRUE;
                }
            });
            if (bl.booleanValue()) {
                this.mPSStream.print(" /DeferredMediaSelection true");
            }
            this.mPSStream.print(" /ImagingBBox null /ManualFeed false");
            this.mPSStream.print(this.isCollated() ? " /Collate true" : "");
            this.mPSStream.print(" /NumCopies " + this.getCopiesInt());
            if (this.sidesAttr != Sides.ONE_SIDED) {
                if (this.sidesAttr == Sides.TWO_SIDED_LONG_EDGE) {
                    this.mPSStream.print(" /Duplex true ");
                } else if (this.sidesAttr == Sides.TWO_SIDED_SHORT_EDGE) {
                    this.mPSStream.print(" /Duplex true /Tumble true ");
                }
            }
            this.mPSStream.println(" >> setpagedevice ");
        }
        this.mPSStream.println("%%EndSetup");
    }

    @Override
    protected void abortDoc() {
        if (this.mPSStream != null && this.mDestType != 2) {
            this.mPSStream.close();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (PSPrinterJob.this.spoolFile != null && PSPrinterJob.this.spoolFile.exists()) {
                    PSPrinterJob.this.spoolFile.delete();
                }
                return null;
            }
        });
    }

    @Override
    protected void endDoc() throws PrinterException {
        if (this.mPSStream != null) {
            this.mPSStream.println(EOF_COMMENT);
            this.mPSStream.flush();
            if (this.mDestType != 2) {
                this.mPSStream.close();
            }
        }
        if (this.mDestType == 0) {
            Object object;
            PrintService printService = this.getPrintService();
            if (printService != null) {
                this.mDestination = printService.getName();
                if (isMac && (object = printService.getAttributes()) != null) {
                    this.mDestination = object.get(PrinterName.class).toString();
                }
            }
            object = new PrinterSpooler();
            AccessController.doPrivileged(object);
            if (((PrinterSpooler)object).pex != null) {
                throw ((PrinterSpooler)object).pex;
            }
        }
    }

    @Override
    protected void startPage(PageFormat pageFormat, Printable printable, int n, boolean bl) throws PrinterException {
        double d = pageFormat.getPaper().getHeight();
        double d2 = pageFormat.getPaper().getWidth();
        int n2 = n + 1;
        this.mGStateStack = new ArrayList();
        this.mGStateStack.add(new GState());
        this.mPSStream.println(PAGE_COMMENT + n2 + " " + n2);
        if (n > 0 && bl) {
            this.mPSStream.print("<< /PageSize [" + d2 + " " + d + "]");
            final PrintService printService = this.getPrintService();
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> clazz = Class.forName("sun.print.IPPPrintService");
                        if (clazz.isInstance(printService)) {
                            Method method = clazz.getMethod("isPostscript", null);
                            return (Boolean)method.invoke(printService, null);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return Boolean.TRUE;
                }
            });
            if (bl2.booleanValue()) {
                this.mPSStream.print(" /DeferredMediaSelection true");
            }
            this.mPSStream.println(" >> setpagedevice");
        }
        this.mPSStream.println(PAGE_SAVE);
        this.mPSStream.println(d + COORD_PREP);
    }

    @Override
    protected void endPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        this.mPSStream.println(PAGE_RESTORE);
        this.mPSStream.println(SHOWPAGE);
    }

    protected void drawImageBGR(byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2) {
        int n3;
        this.setTransform(new AffineTransform());
        this.prepDrawing();
        int n4 = (int)f7;
        int n5 = (int)f8;
        this.mPSStream.println(IMAGE_SAVE);
        for (n3 = 3 * n4; n3 > 65535; n3 /= 2) {
        }
        this.mPSStream.println(n3 + IMAGE_STR);
        this.mPSStream.println("[" + f3 + " 0 0 " + f4 + " " + f + " " + f2 + "]concat");
        this.mPSStream.println(n4 + " " + n5 + " " + 8 + "[" + n4 + " 0 0 " + n5 + " 0 " + 0 + "]/imageSrc load false 3 colorimage");
        int n6 = 0;
        byte[] byArray2 = new byte[n4 * 3];
        try {
            n6 = (int)f6 * n;
            for (int i = 0; i < n5; ++i) {
                n6 += (int)f5;
                n6 = PSPrinterJob.swapBGRtoRGB(byArray, n6, byArray2);
                byte[] byArray3 = this.rlEncode(byArray2);
                byte[] byArray4 = this.ascii85Encode(byArray3);
                this.mPSStream.write(byArray4);
                this.mPSStream.println("");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    @Override
    protected void printBand(byte[] byArray, int n, int n2, int n3, int n4) throws PrinterException {
        int n5;
        this.mPSStream.println(IMAGE_SAVE);
        for (n5 = 3 * n3; n5 > 65535; n5 /= 2) {
        }
        this.mPSStream.println(n5 + IMAGE_STR);
        this.mPSStream.println("[" + n3 + " 0 0 " + n4 + " " + n + " " + n2 + "]concat");
        this.mPSStream.println(n3 + " " + n4 + " " + 8 + "[" + n3 + " 0 0 " + -n4 + " 0 " + n4 + "]/imageSrc load false 3 colorimage");
        int n6 = 0;
        byte[] byArray2 = new byte[n3 * 3];
        try {
            for (int i = 0; i < n4; ++i) {
                n6 = PSPrinterJob.swapBGRtoRGB(byArray, n6, byArray2);
                byte[] byArray3 = this.rlEncode(byArray2);
                byte[] byArray4 = this.ascii85Encode(byArray3);
                this.mPSStream.write(byArray4);
                this.mPSStream.println("");
            }
        }
        catch (IOException iOException) {
            throw new PrinterIOException(iOException);
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    @Override
    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        PSPathGraphics pSPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing())) {
            pSPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            boolean bl = !peekGraphics.getAWTDrawingOnly();
            pSPathGraphics = new PSPathGraphics(graphics2D, printerJob, printable, pageFormat, n, bl);
        }
        return pSPathGraphics;
    }

    protected void selectClipPath() {
        this.mPSStream.println(this.mClipOpStr);
    }

    protected void setClip(Shape shape) {
        this.mLastClip = shape;
    }

    protected void setTransform(AffineTransform affineTransform) {
        this.mLastTransform = affineTransform;
    }

    protected boolean setFont(Font font) {
        this.mLastFont = font;
        return true;
    }

    private int[] getPSFontIndexArray(Font font, CharsetString[] charsetStringArray) {
        int[] nArray = null;
        if (mFontProps != null) {
            nArray = new int[charsetStringArray.length];
        }
        for (int i = 0; i < charsetStringArray.length && nArray != null; ++i) {
            CharsetString charsetString = charsetStringArray[i];
            CharsetEncoder charsetEncoder = charsetString.fontDescriptor.encoder;
            String string = charsetString.fontDescriptor.getFontCharsetName();
            string = "Symbol".equals(string) ? "symbol" : ("WingDings".equals(string) || "X11Dingbats".equals(string) ? "dingbats" : this.makeCharsetName(string, charsetString.charsetChars));
            int n = font.getStyle() | FontUtilities.getFont2D(font).getStyle();
            String string2 = FontConfiguration.getStyleString(n);
            String string3 = font.getFamily().toLowerCase(Locale.ENGLISH);
            String string4 = mFontProps.getProperty(string3 = string3.replace(' ', '_'), "");
            String string5 = mFontProps.getProperty(string4 + "." + string + "." + string2, null);
            if (string5 != null) {
                try {
                    nArray[i] = Integer.parseInt(mFontProps.getProperty(string5));
                }
                catch (NumberFormatException numberFormatException) {
                    nArray = null;
                }
                continue;
            }
            nArray = null;
        }
        return nArray;
    }

    private static String escapeParens(String string) {
        if (string.indexOf(40) == -1 && string.indexOf(41) == -1) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(40, n2)) != -1) {
            ++n;
            ++n2;
        }
        n2 = 0;
        while ((n2 = string.indexOf(41, n2)) != -1) {
            ++n;
            ++n2;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length + n];
        n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '(' || cArray[i] == ')') {
                cArray2[n2++] = 92;
            }
            cArray2[n2++] = cArray[i];
        }
        return new String(cArray2);
    }

    protected int platformFontCount(Font font, String string) {
        if (mFontProps == null) {
            return 0;
        }
        CharsetString[] charsetStringArray = ((PlatformFont)font.getPeer()).makeMultiCharsetString(string, false);
        if (charsetStringArray == null) {
            return 0;
        }
        int[] nArray = this.getPSFontIndexArray(font, charsetStringArray);
        return nArray == null ? 0 : nArray.length;
    }

    protected boolean textOut(Graphics graphics, String string, float f, float f2, Font font, FontRenderContext fontRenderContext, float f3) {
        boolean bl = true;
        if (mFontProps == null) {
            return false;
        }
        this.prepDrawing();
        string = this.removeControlChars(string);
        if (string.length() == 0) {
            return true;
        }
        CharsetString[] charsetStringArray = ((PlatformFont)font.getPeer()).makeMultiCharsetString(string, false);
        if (charsetStringArray == null) {
            return false;
        }
        int[] nArray = this.getPSFontIndexArray(font, charsetStringArray);
        if (nArray != null) {
            for (int i = 0; i < charsetStringArray.length; ++i) {
                float f4;
                CharsetString charsetString = charsetStringArray[i];
                CharsetEncoder charsetEncoder = charsetString.fontDescriptor.encoder;
                StringBuffer stringBuffer = new StringBuffer();
                byte[] byArray = new byte[charsetString.length * 2];
                int n = 0;
                try {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                    charsetEncoder.encode(CharBuffer.wrap(charsetString.charsetChars, charsetString.offset, charsetString.length), byteBuffer, true);
                    byteBuffer.flip();
                    n = byteBuffer.limit();
                }
                catch (IllegalStateException illegalStateException) {
                    continue;
                }
                catch (CoderMalfunctionError coderMalfunctionError) {
                    continue;
                }
                if (charsetStringArray.length == 1 && f3 != 0.0f) {
                    f4 = f3;
                } else {
                    Rectangle2D rectangle2D = font.getStringBounds(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, fontRenderContext);
                    f4 = (float)rectangle2D.getWidth();
                }
                if (f4 == 0.0f) {
                    return bl;
                }
                stringBuffer.append('<');
                for (int j = 0; j < n; ++j) {
                    byte by = byArray[j];
                    String string2 = Integer.toHexString(by);
                    int n2 = string2.length();
                    if (n2 > 2) {
                        string2 = string2.substring(n2 - 2, n2);
                    } else if (n2 == 1) {
                        string2 = "0" + string2;
                    } else if (n2 == 0) {
                        string2 = "00";
                    }
                    stringBuffer.append(string2);
                }
                stringBuffer.append('>');
                this.getGState().emitPSFont(nArray[i], font.getSize2D());
                this.mPSStream.println(stringBuffer.toString() + " " + f4 + " " + f + " " + f2 + " " + DrawStringName);
                f += f4;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected void setFillMode(int n) {
        switch (n) {
            case 1: {
                this.mFillOpStr = EVEN_ODD_FILL_STR;
                this.mClipOpStr = EVEN_ODD_CLIP_STR;
                break;
            }
            case 2: {
                this.mFillOpStr = WINDING_FILL_STR;
                this.mClipOpStr = WINDING_CLIP_STR;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected void setColor(Color color) {
        this.mLastColor = color;
    }

    protected void fillPath() {
        this.mPSStream.println(this.mFillOpStr);
    }

    protected void beginPath() {
        this.prepDrawing();
        this.mPSStream.println(NEWPATH_STR);
        this.mPenX = 0.0f;
        this.mPenY = 0.0f;
    }

    protected void closeSubpath() {
        this.mPSStream.println(CLOSEPATH_STR);
        this.mPenX = this.mStartPathX;
        this.mPenY = this.mStartPathY;
    }

    protected void moveTo(float f, float f2) {
        this.mPSStream.println(this.trunc(f) + " " + this.trunc(f2) + MOVETO_STR);
        this.mStartPathX = f;
        this.mStartPathY = f2;
        this.mPenX = f;
        this.mPenY = f2;
    }

    protected void lineTo(float f, float f2) {
        this.mPSStream.println(this.trunc(f) + " " + this.trunc(f2) + LINETO_STR);
        this.mPenX = f;
        this.mPenY = f2;
    }

    protected void bezierTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mPSStream.println(this.trunc(f) + " " + this.trunc(f2) + " " + this.trunc(f3) + " " + this.trunc(f4) + " " + this.trunc(f5) + " " + this.trunc(f6) + CURVETO_STR);
        this.mPenX = f5;
        this.mPenY = f6;
    }

    String trunc(float f) {
        float f2 = Math.abs(f);
        if (f2 >= 1.0f && f2 <= 1000.0f) {
            f = (float)Math.round(f * 1000.0f) / 1000.0f;
        }
        return Float.toString(f);
    }

    protected float getPenX() {
        return this.mPenX;
    }

    protected float getPenY() {
        return this.mPenY;
    }

    @Override
    protected double getXRes() {
        return 300.0;
    }

    @Override
    protected double getYRes() {
        return 300.0;
    }

    @Override
    protected double getPhysicalPrintableX(Paper paper) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableY(Paper paper) {
        return 0.0;
    }

    @Override
    protected double getPhysicalPrintableWidth(Paper paper) {
        return paper.getImageableWidth();
    }

    @Override
    protected double getPhysicalPrintableHeight(Paper paper) {
        return paper.getImageableHeight();
    }

    @Override
    protected double getPhysicalPageWidth(Paper paper) {
        return paper.getWidth();
    }

    @Override
    protected double getPhysicalPageHeight(Paper paper) {
        return paper.getHeight();
    }

    @Override
    protected int getNoncollatedCopies() {
        return 1;
    }

    @Override
    protected int getCollatedCopies() {
        return 1;
    }

    private String[] printExecCmd(String string, String string2, boolean bl, String string3, int n, String string4) {
        String[] stringArray;
        String string5;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 16;
        int n7 = 0;
        int n8 = 2;
        int n9 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n7 |= n2;
            ++n8;
        }
        if (string2 != null && !string2.equals("")) {
            n7 |= n3;
            ++n8;
        }
        if (string3 != null && !string3.equals("")) {
            n7 |= n4;
            ++n8;
        }
        if (n > 1) {
            n7 |= n5;
            ++n8;
        }
        if (bl) {
            n7 |= n6;
            ++n8;
        }
        if ((string5 = System.getProperty("os.name")).equals("Linux") || string5.contains("OS X") || System.getProperty("os.name").equals("AIX")) {
            stringArray = new String[n8];
            stringArray[n9++] = "/usr/bin/lpr";
            if ((n7 & n2) != 0) {
                stringArray[n9++] = "-P" + string;
            }
            if ((n7 & n4) != 0) {
                stringArray[n9++] = "-J" + string3;
            }
            if ((n7 & n5) != 0) {
                stringArray[n9++] = "-#" + n;
            }
            if ((n7 & n6) != 0) {
                stringArray[n9++] = "-h";
            }
            if ((n7 & n3) != 0) {
                stringArray[n9++] = "-o" + string2;
            }
        } else {
            stringArray = new String[++n8];
            stringArray[n9++] = System.getProperty("os.name").equals("z/OS") ? "/usr/lpp/Printsrv/bin/lp" : "/usr/bin/lp";
            stringArray[n9++] = "-c";
            if ((n7 & n2) != 0) {
                stringArray[n9++] = "-d" + string;
            }
            if ((n7 & n4) != 0) {
                stringArray[n9++] = "-t" + string3;
            }
            if ((n7 & n5) != 0) {
                stringArray[n9++] = "-n" + n;
            }
            if ((n7 & n6) != 0) {
                stringArray[n9++] = "-o nobanner";
            }
            if ((n7 & n3) != 0) {
                stringArray[n9++] = "-o" + string2;
            }
        }
        stringArray[n9++] = string4;
        return stringArray;
    }

    private static int swapBGRtoRGB(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        while (n < byArray.length - 2 && n2 < byArray2.length - 2) {
            byArray2[n2++] = byArray[n + 2];
            byArray2[n2++] = byArray[n + 1];
            byArray2[n2++] = byArray[n + 0];
            n += 3;
        }
        return n;
    }

    private String makeCharsetName(String string, char[] cArray) {
        if (string.equals("Cp1252") || string.equals("ISO8859_1")) {
            return "latin1";
        }
        if (string.equals("UTF8")) {
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] <= '\u00ff') continue;
                return string.toLowerCase();
            }
            return "latin1";
        }
        if (string.startsWith("ISO8859")) {
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] <= '\u007f') continue;
                return string.toLowerCase();
            }
            return "latin1";
        }
        return string.toLowerCase();
    }

    private void prepDrawing() {
        while (!(this.isOuterGState() || this.getGState().canSetClip(this.mLastClip) && this.getGState().mTransform.equals(this.mLastTransform))) {
            this.grestore();
        }
        this.getGState().emitPSColor(this.mLastColor);
        if (this.isOuterGState()) {
            this.gsave();
            this.getGState().emitTransform(this.mLastTransform);
            this.getGState().emitPSClip(this.mLastClip);
        }
    }

    private GState getGState() {
        int n = this.mGStateStack.size();
        return (GState)this.mGStateStack.get(n - 1);
    }

    private void gsave() {
        GState gState = this.getGState();
        this.mGStateStack.add(new GState(gState));
        this.mPSStream.println(GSAVE_STR);
    }

    private void grestore() {
        int n = this.mGStateStack.size();
        this.mGStateStack.remove(n - 1);
        this.mPSStream.println(GRESTORE_STR);
    }

    private boolean isOuterGState() {
        return this.mGStateStack.size() == 1;
    }

    void convertToPSPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
        this.beginPath();
        this.setFillMode(n);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    this.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    float f = this.getPenX();
                    float f2 = this.getPenY();
                    float f3 = f + (fArray[0] - f) * 2.0f / 3.0f;
                    float f4 = f2 + (fArray[1] - f2) * 2.0f / 3.0f;
                    float f5 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f6 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    this.bezierTo(f3, f4, f5, f6, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.bezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    this.closeSubpath();
                }
            }
            pathIterator.next();
        }
    }

    protected void deviceFill(PathIterator pathIterator, Color color, AffineTransform affineTransform, Shape shape) {
        this.setTransform(affineTransform);
        this.setClip(shape);
        this.setColor(color);
        this.convertToPSPath(pathIterator);
        this.mPSStream.println(GSAVE_STR);
        this.selectClipPath();
        this.fillPath();
        this.mPSStream.println("R N");
    }

    private byte[] rlEncode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray2 = new byte[byArray.length * 2 + 2];
        while (n < byArray.length) {
            if (n4 == 0) {
                n3 = n++;
                n4 = 1;
            }
            while (n4 < 128 && n < byArray.length && byArray[n] == byArray[n3]) {
                ++n4;
                ++n;
            }
            if (n4 > 1) {
                byArray2[n2++] = (byte)(257 - n4);
                byArray2[n2++] = byArray[n3];
                n4 = 0;
                continue;
            }
            while (n4 < 128 && n < byArray.length && byArray[n] != byArray[n - 1]) {
                ++n4;
                ++n;
            }
            byArray2[n2++] = (byte)(n4 - 1);
            for (int i = n3; i < n3 + n4; ++i) {
                byArray2[n2++] = byArray[i];
            }
            n4 = 0;
        }
        byArray2[n2++] = -128;
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    private byte[] ascii85Encode(byte[] byArray) {
        long l;
        long l2;
        byte[] byArray2 = new byte[(byArray.length + 4) * 5 / 4 + 2];
        long l3 = 85L;
        long l4 = l3 * l3;
        long l5 = l3 * l4;
        long l6 = l3 * l5;
        int n = 33;
        int n2 = 0;
        int n3 = 0;
        while (n2 + 3 < byArray.length) {
            if ((l2 = ((long)(byArray[n2++] & 0xFF) << 24) + ((long)(byArray[n2++] & 0xFF) << 16) + ((long)(byArray[n2++] & 0xFF) << 8) + (long)(byArray[n2++] & 0xFF)) == 0L) {
                byArray2[n3++] = 122;
                continue;
            }
            l = l2;
            byArray2[n3++] = (byte)(l / l6 + (long)n);
            byArray2[n3++] = (byte)((l %= l6) / l5 + (long)n);
            byArray2[n3++] = (byte)((l %= l5) / l4 + (long)n);
            byArray2[n3++] = (byte)((l %= l4) / l3 + (long)n);
            byArray2[n3++] = (byte)((l %= l3) + (long)n);
        }
        if (n2 < byArray.length) {
            int n4 = byArray.length - n2;
            l2 = 0L;
            while (n2 < byArray.length) {
                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
            }
            int n5 = 4 - n4;
            while (n5-- > 0) {
                l2 <<= 8;
            }
            byte[] byArray3 = new byte[5];
            l = l2;
            byArray3[0] = (byte)(l / l6 + (long)n);
            byArray3[1] = (byte)((l %= l6) / l5 + (long)n);
            byArray3[2] = (byte)((l %= l5) / l4 + (long)n);
            byArray3[3] = (byte)((l %= l4) / l3 + (long)n);
            byArray3[4] = (byte)((l %= l3) + (long)n);
            for (int i = 0; i < n4 + 1; ++i) {
                byArray2[n3++] = byArray3[i];
            }
        }
        byArray2[n3++] = 126;
        byArray2[n3++] = 62;
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray4, 0, n3);
        return byArray4;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                mFontProps = PSPrinterJob.initProps();
                String string = System.getProperty("os.name");
                isMac = string.startsWith("Mac");
                return null;
            }
        });
    }

    public static class EPSPrinter
    implements Pageable {
        private PageFormat pf;
        private PSPrinterJob job;
        private int llx;
        private int lly;
        private int urx;
        private int ury;
        private Printable printable;
        private PrintStream stream;
        private String epsTitle;

        public EPSPrinter(Printable printable, String string, PrintStream printStream, int n, int n2, int n3, int n4) {
            this.printable = printable;
            this.epsTitle = string;
            this.stream = printStream;
            this.llx = n;
            this.lly = n2;
            this.urx = this.llx + n3;
            this.ury = this.lly + n4;
            Paper paper = new Paper();
            paper.setSize(n3, n4);
            paper.setImageableArea(0.0, 0.0, n3, n4);
            this.pf = new PageFormat();
            this.pf.setPaper(paper);
        }

        public void print() throws PrinterException {
            this.stream.println("%!PS-Adobe-3.0 EPSF-3.0");
            this.stream.println("%%BoundingBox: " + this.llx + " " + this.lly + " " + this.urx + " " + this.ury);
            this.stream.println("%%Title: " + this.epsTitle);
            this.stream.println("%%Creator: Java Printing");
            this.stream.println("%%CreationDate: " + new Date());
            this.stream.println("%%EndComments");
            this.stream.println("/pluginSave save def");
            this.stream.println("mark");
            this.job = new PSPrinterJob();
            this.job.epsPrinter = this;
            this.job.mPSStream = this.stream;
            this.job.mDestType = 2;
            this.job.startDoc();
            try {
                this.job.printPage(this, 0);
            }
            catch (Throwable throwable) {
                if (throwable instanceof PrinterException) {
                    throw (PrinterException)throwable;
                }
                throw new PrinterException(throwable.toString());
            }
            finally {
                this.stream.println("cleartomark");
                this.stream.println("pluginSave restore");
                this.job.endDoc();
            }
            this.stream.flush();
        }

        @Override
        public int getNumberOfPages() {
            return 1;
        }

        @Override
        public PageFormat getPageFormat(int n) {
            if (n > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.pf;
        }

        @Override
        public Printable getPrintable(int n) {
            if (n > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.printable;
        }
    }

    public static class PluginPrinter
    implements Printable {
        private EPSPrinter epsPrinter;
        private Component applet;
        private PrintStream stream;
        private String epsTitle;
        private int bx;
        private int by;
        private int bw;
        private int bh;
        private int width;
        private int height;

        public PluginPrinter(Component component, PrintStream printStream, int n, int n2, int n3, int n4) {
            this.applet = component;
            this.epsTitle = "Java Plugin Applet";
            this.stream = printStream;
            this.bx = n;
            this.by = n2;
            this.bw = n3;
            this.bh = n4;
            this.width = component.size().width;
            this.height = component.size().height;
            this.epsPrinter = new EPSPrinter(this, this.epsTitle, printStream, 0, 0, this.width, this.height);
        }

        public void printPluginPSHeader() {
            this.stream.println("%%BeginDocument: JavaPluginApplet");
        }

        public void printPluginApplet() {
            try {
                this.epsPrinter.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }

        public void printPluginPSTrailer() {
            this.stream.println("%%EndDocument: JavaPluginApplet");
            this.stream.flush();
        }

        public void printAll() {
            this.printPluginPSHeader();
            this.printPluginApplet();
            this.printPluginPSTrailer();
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n > 0) {
                return 1;
            }
            this.applet.printAll(graphics);
            return 0;
        }
    }

    private class GState {
        Color mColor;
        Shape mClip;
        Font mFont;
        AffineTransform mTransform;

        GState() {
            this.mColor = Color.black;
            this.mClip = null;
            this.mFont = null;
            this.mTransform = new AffineTransform();
        }

        GState(GState gState) {
            this.mColor = gState.mColor;
            this.mClip = gState.mClip;
            this.mFont = gState.mFont;
            this.mTransform = gState.mTransform;
        }

        boolean canSetClip(Shape shape) {
            return this.mClip == null || this.mClip.equals(shape);
        }

        void emitPSClip(Shape shape) {
            if (!(shape == null || this.mClip != null && this.mClip.equals(shape))) {
                String string = PSPrinterJob.this.mFillOpStr;
                String string2 = PSPrinterJob.this.mClipOpStr;
                PSPrinterJob.this.convertToPSPath(shape.getPathIterator(new AffineTransform()));
                PSPrinterJob.this.selectClipPath();
                this.mClip = shape;
                PSPrinterJob.this.mClipOpStr = string;
                PSPrinterJob.this.mFillOpStr = string;
            }
        }

        void emitTransform(AffineTransform affineTransform) {
            if (affineTransform != null && !affineTransform.equals(this.mTransform)) {
                double[] dArray = new double[6];
                affineTransform.getMatrix(dArray);
                PSPrinterJob.this.mPSStream.println("[" + (float)dArray[0] + " " + (float)dArray[1] + " " + (float)dArray[2] + " " + (float)dArray[3] + " " + (float)dArray[4] + " " + (float)dArray[5] + "] concat");
                this.mTransform = affineTransform;
            }
        }

        void emitPSColor(Color color) {
            if (color != null && !color.equals(this.mColor)) {
                float[] fArray = color.getRGBColorComponents(null);
                if (fArray[0] == fArray[1] && fArray[1] == fArray[2]) {
                    PSPrinterJob.this.mPSStream.println(fArray[0] + PSPrinterJob.SETGRAY_STR);
                } else {
                    PSPrinterJob.this.mPSStream.println(fArray[0] + " " + fArray[1] + " " + fArray[2] + " " + PSPrinterJob.SETRGBCOLOR_STR);
                }
                this.mColor = color;
            }
        }

        void emitPSFont(int n, float f) {
            PSPrinterJob.this.mPSStream.println(f + " " + n + " " + PSPrinterJob.SetFontName);
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction {
        PrinterException pex;

        private PrinterSpooler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleProcessFailure(Process process, String[] stringArray, int n) throws IOException {
            StringWriter stringWriter = new StringWriter();
            Throwable throwable = null;
            try {
                try {
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    Throwable throwable2 = null;
                    try {
                        try {
                            printWriter.append("error=").append(Integer.toString(n));
                            printWriter.append(" running:");
                            for (String object : stringArray) {
                                printWriter.append(" '").append(object).append("'");
                            }
                            try {
                                block53: {
                                    InputStream inputStream;
                                    block54: {
                                        inputStream = process.getErrorStream();
                                        Throwable throwable3 = null;
                                        try {
                                            Throwable throwable4 = null;
                                            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                                                 BufferedReader throwable42 = new BufferedReader(inputStreamReader);){
                                                while (throwable42.ready()) {
                                                    printWriter.println();
                                                    printWriter.append("\t\t").append(throwable42.readLine());
                                                }
                                            }
                                            catch (Throwable throwable5) {
                                                Throwable throwable6 = throwable5;
                                                throw throwable5;
                                            }
                                            if (inputStream == null) break block53;
                                            if (throwable3 == null) break block54;
                                        }
                                        catch (Throwable throwable7) {
                                            try {
                                                throwable3 = throwable7;
                                                throw throwable7;
                                            }
                                            catch (Throwable throwable8) {
                                                if (inputStream == null) throw throwable8;
                                                if (throwable3 == null) {
                                                    inputStream.close();
                                                    throw throwable8;
                                                }
                                                try {
                                                    inputStream.close();
                                                    throw throwable8;
                                                }
                                                catch (Throwable throwable9) {
                                                    throwable3.addSuppressed(throwable9);
                                                    throw throwable8;
                                                }
                                            }
                                        }
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable3.addSuppressed(throwable6);
                                        }
                                    }
                                    inputStream.close();
                                }
                            }
                            finally {
                                printWriter.flush();
                                throw new IOException(stringWriter.toString());
                            }
                        }
                        catch (Throwable throwable10) {
                            throwable2 = throwable10;
                            throw throwable10;
                        }
                    }
                    catch (Throwable throwable10) {
                        if (printWriter == null) throw throwable10;
                        if (throwable2 == null) {
                            printWriter.close();
                            throw throwable10;
                        }
                        try {
                            printWriter.close();
                            throw throwable10;
                        }
                        catch (Throwable throwable11) {
                            throwable2.addSuppressed(throwable11);
                            throw throwable10;
                        }
                    }
                }
                catch (Throwable throwable13) {
                    throwable = throwable13;
                    throw throwable13;
                }
            }
            catch (Throwable throwable12) {
                if (stringWriter == null) throw throwable12;
                if (throwable == null) {
                    stringWriter.close();
                    throw throwable12;
                }
                try {
                    stringWriter.close();
                    throw throwable12;
                }
                catch (Throwable throwable13) {
                    throwable.addSuppressed(throwable13);
                    throw throwable12;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            if (PSPrinterJob.this.spoolFile == null || !PSPrinterJob.this.spoolFile.exists()) {
                this.pex = new PrinterException("No spool file");
                return null;
            }
            try {
                String string = PSPrinterJob.this.spoolFile.getAbsolutePath();
                String[] stringArray = PSPrinterJob.this.printExecCmd(PSPrinterJob.this.mDestination, PSPrinterJob.this.mOptions, PSPrinterJob.this.mNoJobSheet, PSPrinterJob.this.getJobNameInt(), 1, string);
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
                int n = process.exitValue();
                if (0 != n) {
                    this.handleProcessFailure(process, stringArray, n);
                }
            }
            catch (IOException iOException) {
                this.pex = new PrinterIOException(iOException);
            }
            catch (InterruptedException interruptedException) {
                this.pex = new PrinterException(interruptedException.toString());
            }
            finally {
                PSPrinterJob.this.spoolFile.delete();
            }
            return null;
        }
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrinterException pex;
        OutputStream result;

        private PrinterOpener() {
        }

        public Object run() {
            try {
                PSPrinterJob.this.spoolFile = Files.createTempFile("javaprint", ".ps", new FileAttribute[0]).toFile();
                PSPrinterJob.this.spoolFile.deleteOnExit();
                this.result = new FileOutputStream(PSPrinterJob.this.spoolFile);
                return this.result;
            }
            catch (IOException iOException) {
                this.pex = new PrinterIOException(iOException);
                return null;
            }
        }
    }
}

