/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import sun.net.NetworkProvider;
import sun.net.SocketAction;
import sun.security.action.GetBooleanAction;

public abstract class AbstractNetworkSelector {
    protected static void addRule(LinkedList<Rule> linkedList, LinkedList<Rule> linkedList2, LinkedList<Rule> linkedList3, Rule rule) {
        switch (rule.getAction()) {
            case BIND: {
                linkedList.addLast(rule);
                break;
            }
            case ACCEPT: {
                linkedList2.addLast(rule);
                linkedList.addLast(new HostPortRule(SocketAction.BIND, rule.getPrimaryHost(), rule.getPortRange(), rule.getSecondaryHost(), rule.getNetworkProvider()));
                break;
            }
            case CONNECT: {
                linkedList3.addLast(rule);
                break;
            }
        }
    }

    protected static void fail(String string, Object ... objectArray) {
        Formatter formatter = new Formatter();
        formatter.format(string, objectArray);
        throw new RuntimeException(formatter.out().toString());
    }

    protected static Rule findFirstMatchingRule(List<Rule> list, SocketAction socketAction, InetAddress inetAddress, int n, InetAddress inetAddress2) {
        for (Rule rule : list) {
            if (!rule.match(socketAction, inetAddress, n, inetAddress2)) continue;
            return rule;
        }
        return null;
    }

    protected static NetworkProvider getNetworkProvider(List<Rule> list, List<Rule> list2, List<Rule> list3, SocketAction socketAction, InetAddress inetAddress, int n, InetAddress inetAddress2) {
        Rule rule = null;
        switch (socketAction) {
            case BIND: {
                rule = AbstractNetworkSelector.findFirstMatchingRule(list, socketAction, inetAddress, n, inetAddress2);
                break;
            }
            case ACCEPT: {
                if (inetAddress2 == null) {
                    return null;
                }
                rule = AbstractNetworkSelector.findFirstMatchingRule(list2, socketAction, inetAddress, n, inetAddress2);
                break;
            }
            case CONNECT: {
                if (inetAddress == null) {
                    return null;
                }
                rule = AbstractNetworkSelector.findFirstMatchingRule(list3, socketAction, inetAddress, n, inetAddress2);
                break;
            }
        }
        if (rule != null) {
            return rule.getNetworkProvider();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String printRules(List<Rule> list, List<Rule> list2, List<Rule> list3, InetAddress inetAddress) {
        String string = null;
        try (StringWriter stringWriter = new StringWriter();){
            try (PrintWriter printWriter = new PrintWriter(stringWriter);){
                printWriter.println("<Rules>");
                for (Rule rule : list) {
                    printWriter.println(rule);
                }
                for (Rule rule : list3) {
                    printWriter.println(rule);
                }
                for (Rule rule : list2) {
                    printWriter.println(rule);
                }
                printWriter.println();
                printWriter.println("<Host Addresses>");
                printWriter.println("InfiniBand: " + Host.ibAddresses);
                printWriter.println("Ethernet: " + Host.ethAddresses);
                printWriter.println("Other: " + Host.othAddresses);
                printWriter.println();
                printWriter.print("Preferred Address: ");
                if (inetAddress != null) {
                    printWriter.println(inetAddress);
                } else {
                    printWriter.println("null");
                }
            }
            finally {
                string = stringWriter.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    protected static class HostPortRule
    implements Rule {
        private final SocketAction action;
        private final PortRange range;
        private final Host host;
        private final Host remote;
        private final NetworkProvider provider;

        public HostPortRule(SocketAction socketAction, Host host, PortRange portRange, Host host2, NetworkProvider networkProvider) {
            this.action = socketAction;
            this.host = host;
            this.range = portRange;
            this.remote = host2;
            this.provider = networkProvider;
        }

        @Override
        public boolean match(SocketAction socketAction, InetAddress inetAddress, int n, InetAddress inetAddress2) {
            if (!this.host.match(socketAction, inetAddress, false) && (socketAction != SocketAction.ACCEPT && socketAction != SocketAction.BIND || this.provider.getPreferredAddress() == null || !inetAddress.equals(this.provider.getPreferredAddress()))) {
                return false;
            }
            if (!this.range.match(n)) {
                return false;
            }
            if (!(socketAction != SocketAction.BIND && socketAction != SocketAction.CONNECT || inetAddress2 != null && this.remote != null)) {
                return true;
            }
            return this.remote.match(socketAction, inetAddress2, true);
        }

        @Override
        public SocketAction getAction() {
            return this.action;
        }

        @Override
        public PortRange getPortRange() {
            return this.range;
        }

        @Override
        public Host getPrimaryHost() {
            return this.host;
        }

        @Override
        public Host getSecondaryHost() {
            return this.remote;
        }

        @Override
        public NetworkProvider getNetworkProvider() {
            return this.provider;
        }

        public String toString() {
            return new String("action: " + SocketAction.toString(this.action) + " host: " + this.host + " port: " + this.range + " remote: " + this.remote);
        }
    }

    protected static interface Rule {
        public boolean match(SocketAction var1, InetAddress var2, int var3, InetAddress var4);

        public SocketAction getAction();

        public PortRange getPortRange();

        public Host getPrimaryHost();

        public Host getSecondaryHost();

        public NetworkProvider getNetworkProvider();
    }

    protected static class Host {
        private final boolean anyHost;
        private final byte[] addressAsBytes;
        private final int prefixByteCount;
        private final byte mask;
        private final boolean loopbackOrLocal;
        private final boolean ibLocal;
        private static List<String> ibAddresses = new LinkedList<String>();
        private static List<String> ethAddresses = new LinkedList<String>();
        private static List<String> othAddresses = new LinkedList<String>();
        static final Host[] allHosts = new Host[]{new Host(){

            @Override
            public boolean match(SocketAction socketAction, InetAddress inetAddress, boolean bl) {
                return true;
            }
        }};

        private Host() {
            this.anyHost = true;
            this.addressAsBytes = null;
            this.prefixByteCount = 0;
            this.mask = 0;
            this.loopbackOrLocal = false;
            this.ibLocal = false;
        }

        public static boolean isLoopbackOrLocal(InetAddress inetAddress) {
            if (inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress()) {
                return true;
            }
            for (String string : ibAddresses) {
                if (!string.equals(inetAddress.getHostAddress())) continue;
                return true;
            }
            for (String string : ethAddresses) {
                if (!string.equals(inetAddress.getHostAddress())) continue;
                return true;
            }
            for (String string : othAddresses) {
                if (!string.equals(inetAddress.getHostAddress())) continue;
                return true;
            }
            return false;
        }

        public static boolean isIBLocal(InetAddress inetAddress) {
            for (String string : ibAddresses) {
                if (!string.equals(inetAddress.getHostAddress())) continue;
                return true;
            }
            return false;
        }

        private Host(InetAddress inetAddress, int n) {
            this.anyHost = false;
            this.addressAsBytes = inetAddress.getAddress();
            this.prefixByteCount = n >> 3;
            this.mask = (byte)(255 << 8 - n % 8);
            this.loopbackOrLocal = Host.isLoopbackOrLocal(inetAddress);
            this.ibLocal = Host.isIBLocal(inetAddress);
        }

        boolean match(SocketAction socketAction, InetAddress inetAddress, boolean bl) {
            if (socketAction == SocketAction.ACCEPT && bl && this.anyHost) {
                return true;
            }
            byte[] byArray = inetAddress.getAddress();
            if (byArray.length != this.addressAsBytes.length) {
                return false;
            }
            for (int i = 0; i < this.prefixByteCount; ++i) {
                if (byArray[i] == this.addressAsBytes[i]) continue;
                return false;
            }
            return this.prefixByteCount >= this.addressAsBytes.length || (byArray[this.prefixByteCount] & this.mask) == (this.addressAsBytes[this.prefixByteCount] & this.mask);
        }

        public static Host[] parse(SocketAction socketAction, String string, boolean bl) {
            LinkedList<Host> linkedList;
            block12: {
                if (socketAction == SocketAction.ACCEPT && bl && (string.equals("*") || string.equals("any") || string.equals("all"))) {
                    return allHosts;
                }
                linkedList = new LinkedList<Host>();
                int n = string.indexOf(47);
                try {
                    if (n < 0) {
                        InetAddress[] inetAddressArray;
                        for (InetAddress inetAddress : inetAddressArray = InetAddress.getAllByName(string)) {
                            int n2 = inetAddress instanceof Inet4Address ? 32 : 128;
                            linkedList.addLast(new Host(inetAddress, n2));
                        }
                        break block12;
                    }
                    InetAddress inetAddress = InetAddress.getByName(string.substring(0, n));
                    int n3 = -1;
                    try {
                        n3 = Integer.parseInt(string.substring(n + 1));
                        if (inetAddress instanceof Inet4Address) {
                            if (n3 < 0 || n3 > 32) {
                                n3 = -1;
                            }
                        } else if (n3 < 0 || n3 > 128) {
                            n3 = -1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n3 > 0) {
                        linkedList.addLast(new Host(inetAddress, n3));
                        break block12;
                    }
                    AbstractNetworkSelector.fail("Malformed prefix '%s'", string);
                    return null;
                }
                catch (UnknownHostException unknownHostException) {
                    AbstractNetworkSelector.fail("Unknown host or malformed IP address '%s'", string);
                    return null;
                }
            }
            return linkedList.toArray(new Host[linkedList.size()]);
        }

        public boolean getIsLoopBackOrLocal() {
            return this.loopbackOrLocal;
        }

        public boolean getIsIBLocal() {
            return this.ibLocal;
        }

        public static List<String> getIBAddressList() {
            return ibAddresses;
        }

        public static List<String> getEthAddressList() {
            return ethAddresses;
        }

        public String toString() {
            String string = null;
            try {
                string = this.anyHost ? new String("*") : new String("" + InetAddress.getByAddress(this.addressAsBytes).toString() + "/" + (this.prefixByteCount << 3));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        static {
            try {
                boolean bl = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv4Stack"));
                boolean bl2 = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses"));
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        NetworkInterface networkInterface = enumeration.nextElement();
                        if (networkInterface == null || !networkInterface.isUp()) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (networkInterface.getName().startsWith("ib")) {
                            bl3 = true;
                        } else if (networkInterface.getName().startsWith("eth")) {
                            bl4 = true;
                        }
                        Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            String string = enumeration2.nextElement().getHostAddress();
                            if (bl2 && !bl && string.indexOf(":") < 0 || !bl2 && string.indexOf(":") >= 0) continue;
                            if (bl3) {
                                ibAddresses.add(string);
                                continue;
                            }
                            if (bl4) {
                                ethAddresses.add(string);
                                continue;
                            }
                            othAddresses.add(string);
                        }
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    protected static class PortRange {
        private final int portStart;
        private final int portEnd;
        private static final int MAX_PORT = 65535;
        private static final int MIN_PORT = 0;

        public PortRange(String string) throws NumberFormatException {
            int n = 0;
            int n2 = 65535;
            int n3 = string.indexOf(45);
            if (n3 < 0) {
                boolean bl = string.equals("*");
                if (!bl) {
                    int n4 = Integer.parseInt(string);
                    if (n4 < 0) {
                        n4 = 0;
                    } else if (n4 > 65535) {
                        n4 = 65535;
                    }
                    n2 = n = n4;
                }
            } else {
                String string2;
                String string3 = string.substring(0, n3);
                if (string3.length() != 0) {
                    int n5 = Integer.parseInt(string3);
                    if (n5 < 0) {
                        n5 = 0;
                    } else if (n5 > 65535) {
                        n5 = 65535;
                    }
                    n = n5;
                }
                if ((string2 = string.substring(n3 + 1)).length() != 0) {
                    int n6 = Integer.parseInt(string2);
                    if (n6 < 0) {
                        n6 = 0;
                    } else if (n6 > 65535) {
                        n6 = 65535;
                    }
                    n2 = n6;
                }
                if (n2 < n) {
                    n2 = n;
                }
            }
            this.portStart = n;
            this.portEnd = n2;
        }

        public boolean match(int n) {
            return n >= this.portStart && n <= this.portEnd;
        }

        public String toString() {
            if (this.portStart == this.portEnd) {
                return new String("" + this.portStart);
            }
            return new String("" + this.portStart + "-" + this.portEnd);
        }
    }
}

