/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.AuthorizationData;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.TicketFlags;
import com.ibm.security.krb5.internal.TransitedEncoding;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class EncTicketPart {
    public TicketFlags flags;
    public EncryptionKey key;
    public PrincipalName cname;
    public TransitedEncoding transited;
    public KerberosTime authtime;
    public KerberosTime starttime;
    public KerberosTime endtime;
    public KerberosTime renewTill;
    public HostAddresses caddr;
    public AuthorizationData authorizationData;

    public EncTicketPart(TicketFlags ticketFlags, EncryptionKey encryptionKey, PrincipalName principalName, TransitedEncoding transitedEncoding, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses, AuthorizationData authorizationData) {
        this.flags = ticketFlags;
        this.key = encryptionKey;
        this.cname = principalName;
        this.transited = transitedEncoding;
        this.authtime = kerberosTime;
        this.starttime = kerberosTime2;
        this.endtime = kerberosTime3;
        this.renewTill = kerberosTime4;
        this.caddr = hostAddresses;
        this.authorizationData = authorizationData;
    }

    public EncTicketPart(byte[] byArray) throws Asn1Exception, KrbException, IOException {
        this.a(new DerValue(byArray));
    }

    public EncTicketPart(DerValue derValue) throws Asn1Exception, KrbException, IOException {
        this.a(derValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(DerValue derValue) throws Asn1Exception, IOException, RealmException {
        this.renewTill = null;
        this.caddr = null;
        this.authorizationData = null;
        if ((derValue.getTag() & 0x1F) != 3 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.flags = TicketFlags.parse(derValue2.getData(), (byte)0, false);
        this.key = EncryptionKey.parse(derValue2.getData(), (byte)1, false);
        Realm realm = Realm.parse(derValue2.getData(), (byte)2, false);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)3, false, realm);
        this.transited = TransitedEncoding.parse(derValue2.getData(), (byte)4, false);
        this.authtime = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        this.starttime = KerberosTime.parse(derValue2.getData(), (byte)6, true);
        this.endtime = KerberosTime.parse(derValue2.getData(), (byte)7, false);
        if (derValue2.getData().available() > 0) {
            this.renewTill = KerberosTime.parse(derValue2.getData(), (byte)8, true);
        }
        if (derValue2.getData().available() > 0) {
            this.caddr = HostAddresses.parse(derValue2.getData(), (byte)9, true);
        }
        if (derValue2.getData().available() > 0) {
            this.authorizationData = AuthorizationData.parse(derValue2.getData(), (byte)10, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.flags.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.key.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.cname.getRealm().asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.cname.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.transited.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.authtime.asn1Encode());
        if (this.starttime != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.starttime.asn1Encode());
        }
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)7), this.endtime.asn1Encode());
        if (this.renewTill != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.renewTill.asn1Encode());
        }
        if (this.caddr != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.caddr.asn1Encode());
        }
        if (this.authorizationData != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.authorizationData.asn1Encode());
        }
        derOutputStream2.write((byte)48, derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)64, (boolean)true, (byte)3), derOutputStream2);
        return derOutputStream.toByteArray();
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public EncryptionKey getEncryptionKey() {
        return this.key;
    }

    public PrincipalName getClient() {
        return this.cname;
    }

    public Realm getClientRealm() {
        return null;
    }

    public TransitedEncoding getTransitedEncoding() {
        return this.transited;
    }

    public KerberosTime getAuthTime() {
        return this.authtime;
    }

    public KerberosTime getStartTime() {
        return this.starttime;
    }

    public KerberosTime getEndTime() {
        return this.endtime;
    }

    public KerberosTime getRenewableTillTime() {
        return this.renewTill;
    }

    public HostAddresses getClientAddresses() {
        return this.caddr;
    }

    public AuthorizationData getAuthzData() {
        return this.authorizationData;
    }
}

