/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.utils.IStringModifier;
import com.ibm.jvm.dtfjview.tools.utils.OutputStreamModifier;
import java.io.PrintStream;

public class CharsToTool
extends Tool
implements IPipe {
    private static final String COMMAND = "charsTo";
    private static final String ARGUMENT_DESCRIPTION = "[options] <pattern>";
    private static final String HELP_DESCRIPTION = "To be used after a pipeline to keep the characters from a line until a specific pattern is found.";
    private static final String USAGE = "charsTo\t[options] <pattern>\tTo be used after a pipeline to keep the characters from a line until a specific pattern is found.\n     Options :\n          -include : to include the matched pattern in the resulting line. If this option is not used, the matched pattern will be excluded from the resulting line.\n          -keep : to keep the lines which does not match the pattern. If this option is not used, the line without a match will be excluded.\n          -i, -ignoreCase : to treat the pattern case-insensitive.";

    @Override
    public boolean accept(String command, String[] args) {
        return command.equalsIgnoreCase(COMMAND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String command, String[] args, PrintStream out) throws CommandException {
        Arguments arguments = CharsToTool.processArguments(args);
        if (arguments == null) {
            out.println(USAGE);
            return;
        }
        StringModifier sm = new StringModifier(arguments);
        try (PrintStream newOut = null;){
            newOut = new PrintStream(new OutputStreamModifier(out, sm));
            ToolsRegistry.process(arguments.nextCommand, arguments.nextCommandArgs, newOut);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private static Arguments processArguments(String[] args) {
        int x;
        boolean includeToken = false;
        boolean keepMismatchedLines = false;
        boolean ignoreCase = false;
        for (x = 0; x < args.length; ++x) {
            if (args[x].equalsIgnoreCase("-include")) {
                includeToken = true;
                continue;
            }
            if (args[x].equalsIgnoreCase("-i")) {
                ignoreCase = true;
                continue;
            }
            if (!args[x].equalsIgnoreCase("-keep")) break;
            keepMismatchedLines = true;
        }
        if (x >= args.length) {
            return null;
        }
        String searchToken = args[x];
        if (++x >= args.length) {
            return null;
        }
        String command = args[x];
        String[] commandArgs = new String[args.length - ++x];
        System.arraycopy(args, x, commandArgs, 0, args.length - x);
        return new Arguments(searchToken, includeToken, keepMismatchedLines, ignoreCase, command, commandArgs);
    }

    private static final class StringModifier
    implements IStringModifier {
        private final Arguments attr;

        StringModifier(Arguments attr) {
            this.attr = attr;
        }

        @Override
        public String modify(String s) {
            int index = -1;
            index = this.attr.ignoreCase ? s.toLowerCase().indexOf(this.attr.searchToken) : s.indexOf(this.attr.searchToken);
            if (index < 0) {
                if (this.attr.keepMismatchedLines) {
                    return s;
                }
                return "";
            }
            if (this.attr.includeToken) {
                return s.substring(0, index + this.attr.searchToken.length()) + "\n";
            }
            return s.substring(0, index) + "\n";
        }
    }

    private static final class Arguments {
        final String searchToken;
        final boolean includeToken;
        final boolean keepMismatchedLines;
        final boolean ignoreCase;
        final String nextCommand;
        final String[] nextCommandArgs;

        Arguments(String searchToken, boolean includeToken, boolean keepMismatchedLines, boolean ignoreCase, String command, String[] commandArgs) {
            this.searchToken = ignoreCase ? searchToken.toLowerCase() : searchToken;
            this.includeToken = includeToken;
            this.keepMismatchedLines = keepMismatchedLines;
            this.ignoreCase = ignoreCase;
            this.nextCommand = command;
            this.nextCommandArgs = commandArgs;
        }
    }
}

