/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.vm.VM;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import openj9.internal.management.ClassLoaderInfoBaseImpl;
import openj9.internal.tools.attach.target.Attachment;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.IPC;
import openj9.management.internal.IDCacheInitializer;
import openj9.management.internal.InvalidDumpOptionExceptionBase;
import openj9.management.internal.LockInfoBase;
import openj9.management.internal.ThreadInfoBase;

public class DiagnosticUtils {
    private static final String FORMAT_PREFIX = " Format: ";
    private static final String SYNTAX_PREFIX = "Syntax : ";
    private static final String HEAP_DUMP_OPTION_HELP = " [request=<options>] [opts=<options>] [<file path>]%n Set optional request= and opts= -Xdump options. The order of the parameters does not matter.%n";
    private static final String OTHER_DUMP_OPTION_HELP = " [request=<options>] [<file path>]%n Set optional request= -Xdump options. The order of the parameters does not matter.%n";
    private static final String HEAPSYSTEM_DUMP_OPTION_HELP = " system and heap dumps default to request=exclusive+prepwalk rather than the -Xdump:<type>:defaults setting.%n";
    private static final String GENERIC_DUMP_OPTION_HELP = " <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%n";
    private static final String DIAGNOSTICS_HELP = "help";
    private static final String DIAGNOSTICS_THREAD_PRINT = "Thread.print";
    private static final String DIAGNOSTICS_GC_RUN = "GC.run";
    private static final String DIAGNOSTICS_GC_CLASS_HISTOGRAM = "GC.class_histogram";
    private static final String DIAGNOSTICS_DUMP_HEAP = "Dump.heap";
    private static final String DIAGNOSTICS_GC_HEAP_DUMP = "GC.heap_dump";
    private static final String DIAGNOSTICS_DUMP_JAVA = "Dump.java";
    private static final String DIAGNOSTICS_DUMP_SNAP = "Dump.snap";
    private static final String DIAGNOSTICS_DUMP_SYSTEM = "Dump.system";
    private static final String DIAGNOSTICS_STAT_CLASS = "jstat.class";
    private static final String DIAGNOSTICS_LOAD_JVMTI_AGENT = "JVMTI.agent_load";
    public static final String COMMAND_STRING = "command_string";
    public static final String DIAGNOSTICS_OPTION_SEPARATOR = ",";
    private static final String ALL_OPTION = "all";
    private static final String LIVE_OPTION = "live";
    private static final String THREAD_LOCKED_SYNCHRONIZERS_OPTION = "-l";
    private static final Map<String, Function<String, DiagnosticProperties>> commandTable;
    private static final Map<String, String> helpTable;
    private static final String DIAGNOSTICS_HELP_HELP = "Show help for a command%n Format:  help <command>%n If no command is supplied, print the list of available commands on the target JVM.%n";
    private static final String DIAGNOSTICS_GC_CLASS_HISTOGRAM_HELP = "Obtain heap information about a Java process%n Format: GC.class_histogram [options]%n Options:%n          all : include all objects, including dead objects (this is the default option)%n         live : include all objects after a global GC collection%nNOTE: this utility might significantly affect the performance of the target VM.%n";
    private static final String DIAGNOSTICS_GC_RUN_HELP = "Run the garbage collector.%n Format: GC.run%nNOTE: this utility might significantly affect the performance of the target VM.%n";
    private static final String DIAGNOSTICS_THREAD_PRINT_HELP = "List thread information.%n Format: Thread.print [options]%n Options: -l : print information about ownable synchronizers%n";
    private static final String DIAGNOSTICS_DUMP_HEAP_HELP = "Create a heap dump.%n Format: Dump.heap [request=<options>] [opts=<options>] [<file path>]%n Set optional request= and opts= -Xdump options. The order of the parameters does not matter.%n system and heap dumps default to request=exclusive+prepwalk rather than the -Xdump:<type>:defaults setting.%n <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%nGC.heap_dump is an alias for Dump.heap%n";
    private static final String DIAGNOSTICS_DUMP_JAVA_HELP = "Create a javacore file.%n Format: Dump.java [request=<options>] [<file path>]%n Set optional request= -Xdump options. The order of the parameters does not matter.%n <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%n";
    private static final String DIAGNOSTICS_DUMP_SNAP_HELP = "Dump the snap trace buffer.%n Format: Dump.snap [request=<options>] [<file path>]%n Set optional request= -Xdump options. The order of the parameters does not matter.%n <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%n";
    private static final String DIAGNOSTICS_DUMP_SYSTEM_HELP = "Create a native core file.%n Format: Dump.system [request=<options>] [<file path>]%n Set optional request= -Xdump options. The order of the parameters does not matter.%n system and heap dumps default to request=exclusive+prepwalk rather than the -Xdump:<type>:defaults setting.%n <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%n";
    private static final String DIAGNOSTICS_JSTAT_CLASS_HELP = "Show JVM classloader statistics.%n Format: jstat.class%nNOTE: this utility might significantly affect the performance of the target VM.%n";
    private static final String DIAGNOSTICS_LOAD_JVMTI_AGENT_HELP = "Load JVMTI agent.%n Format: JVMTI.agent_load <agentLibrary> [<agent option>]%n          agentLibrary: the absolute path of the agent%n          agent option: (Optional) the agent option string%n";

    public static String makeHeapHistoCommand(boolean liveObjects) {
        String cmd = DIAGNOSTICS_GC_CLASS_HISTOGRAM;
        if (liveObjects) {
            cmd = "GC.class_histogram,live";
        }
        return cmd;
    }

    public static String makeThreadPrintCommand(boolean lockedSynchronizers) {
        String cmd = lockedSynchronizers ? "Thread.print,-l" : DIAGNOSTICS_THREAD_PRINT;
        return cmd;
    }

    public static String makeJcmdCommand(String[] options, int skip) {
        String cmd = String.join((CharSequence)DIAGNOSTICS_OPTION_SEPARATOR, Arrays.asList(options).subList(skip, options.length));
        return cmd;
    }

    private static native String getHeapClassStatisticsImpl();

    private static native String triggerDumpsImpl(String var0, String var1) throws InvalidDumpOptionExceptionBase;

    static DiagnosticProperties executeDiagnosticCommand(String diagnosticCommand) {
        DiagnosticProperties result;
        IPC.logMessage("executeDiagnosticCommand: ", diagnosticCommand);
        String[] commandRoot = diagnosticCommand.split(DIAGNOSTICS_OPTION_SEPARATOR);
        Function<String, DiagnosticProperties> cmd = commandTable.get(commandRoot[0]);
        if (null == cmd) {
            result = DiagnosticProperties.makeStatusProperties(true, "Command " + diagnosticCommand + " not recognized");
        } else {
            result = cmd.apply(diagnosticCommand);
            result.put(COMMAND_STRING, diagnosticCommand);
        }
        return result;
    }

    private static DiagnosticProperties getHeapStatistics(String diagnosticCommand) {
        DiagnosticProperties result = null;
        boolean invalidArg = false;
        boolean doLive = false;
        String[] parts = diagnosticCommand.split(DIAGNOSTICS_OPTION_SEPARATOR);
        if (parts.length > 2) {
            invalidArg = true;
        } else if (parts.length == 2) {
            if (LIVE_OPTION.equalsIgnoreCase(parts[1])) {
                doLive = true;
            } else if (!ALL_OPTION.equalsIgnoreCase(parts[1])) {
                invalidArg = true;
            }
        }
        if (invalidArg) {
            result = DiagnosticProperties.makeErrorProperties("Command not recognized: " + diagnosticCommand);
        } else {
            if (doLive) {
                DiagnosticUtils.runGC();
            }
            String hcsi = DiagnosticUtils.getHeapClassStatisticsImpl();
            String lineSeparator = System.lineSeparator();
            String unixLineSeparator = "\n";
            if (!"\n".equals(lineSeparator)) {
                hcsi = hcsi.replace("\n", lineSeparator);
            }
            result = DiagnosticProperties.makeStringResult(hcsi);
        }
        return result;
    }

    private static DiagnosticProperties getThreadInfo(String diagnosticCommand) {
        DiagnosticProperties result = null;
        boolean okay = true;
        boolean addSynchronizers = false;
        String[] parts = diagnosticCommand.split(DIAGNOSTICS_OPTION_SEPARATOR);
        if (parts.length > 2) {
            okay = false;
        } else if (parts.length == 2) {
            String option = parts[1];
            if (option.startsWith(THREAD_LOCKED_SYNCHRONIZERS_OPTION)) {
                if (THREAD_LOCKED_SYNCHRONIZERS_OPTION.length() == option.length() || option.toLowerCase().equals("-l=true")) {
                    addSynchronizers = true;
                }
            } else {
                okay = false;
            }
        }
        if (!okay) {
            result = DiagnosticProperties.makeErrorProperties("Command not recognized: " + diagnosticCommand);
        } else {
            ThreadInfoBase[] threadInfoBases;
            StringWriter buffer = new StringWriter(2000);
            PrintWriter bufferPrinter = new PrintWriter(buffer);
            bufferPrinter.println(System.getProperty("java.vm.info"));
            bufferPrinter.println();
            for (ThreadInfoBase currentThreadInfoBase : threadInfoBases = DiagnosticUtils.dumpAllThreadsImpl(true, addSynchronizers, Integer.MAX_VALUE)) {
                bufferPrinter.print(currentThreadInfoBase.toString());
                if (addSynchronizers) {
                    LockInfoBase[] lockedSynchronizers = currentThreadInfoBase.getLockedSynchronizers();
                    bufferPrinter.printf("%n\tLocked ownable synchronizers: %d%n", lockedSynchronizers.length);
                    for (LockInfoBase currentLockedSynchronizer : lockedSynchronizers) {
                        bufferPrinter.printf("\t- %s%n", currentLockedSynchronizer.toString());
                    }
                }
                bufferPrinter.println();
            }
            bufferPrinter.flush();
            result = DiagnosticProperties.makeStringResult(buffer.toString());
        }
        return result;
    }

    private static DiagnosticProperties doDump(String diagnosticCommand) {
        DiagnosticProperties result = null;
        String[] parts = diagnosticCommand.split(DIAGNOSTICS_OPTION_SEPARATOR);
        IPC.logMessage("doDump: ", diagnosticCommand);
        if (parts.length == 0 || parts.length > 4) {
            result = DiagnosticProperties.makeErrorProperties("Error: wrong number of arguments");
        } else {
            String dumpType = "";
            if (DIAGNOSTICS_GC_HEAP_DUMP.equals(parts[0])) {
                dumpType = "heap";
            } else {
                String[] dumpCommandAndType = parts[0].split("\\.");
                if (dumpCommandAndType.length != 2) {
                    result = DiagnosticProperties.makeErrorProperties(String.format("Error: invalid command %s", parts[0]));
                } else {
                    dumpType = dumpCommandAndType[1];
                }
            }
            if (!dumpType.isEmpty()) {
                StringBuilder request = new StringBuilder();
                request.append(dumpType);
                String filePath = null;
                boolean foundRequest = false;
                boolean heapDump = "heap".equals(dumpType);
                boolean systemDump = "system".equals(dumpType);
                String separator = ":";
                for (int i = 1; i < parts.length; ++i) {
                    String option = parts[i];
                    boolean isRequest = option.startsWith("request=");
                    boolean isOpts = option.startsWith("opts=");
                    if (isRequest || isOpts) {
                        if (!heapDump && isOpts) continue;
                        request.append(separator).append(option);
                        if (isRequest) {
                            foundRequest = true;
                        }
                    } else {
                        if (filePath != null) {
                            result = DiagnosticProperties.makeErrorProperties("Error: second <file path> found, \"" + option + "\" after \"" + filePath + "\"");
                            break;
                        }
                        String fileDirective = systemDump && IPC.isZOS ? "dsn=" : "file=";
                        request.append(separator).append(fileDirective).append(option);
                        filePath = option;
                    }
                    separator = DIAGNOSTICS_OPTION_SEPARATOR;
                }
                if (result == null) {
                    if (!foundRequest && (systemDump || heapDump)) {
                        request.append(separator).append("request=exclusive+prepwalk");
                    }
                    try {
                        String actualDumpFile = DiagnosticUtils.triggerDumpsImpl(request.toString(), dumpType + "DumpToFile");
                        result = DiagnosticProperties.makeStringResult("Dump written to " + actualDumpFile);
                    }
                    catch (InvalidDumpOptionExceptionBase e) {
                        IPC.logMessage("doDump exception: ", e.getMessage());
                        result = DiagnosticProperties.makeExceptionProperties(e);
                    }
                }
            }
        }
        return result;
    }

    private static native ThreadInfoBase[] dumpAllThreadsImpl(boolean var0, boolean var1, int var2);

    private static DiagnosticProperties runGC() {
        VM.globalGC();
        return DiagnosticProperties.makeCommandSucceeded();
    }

    private static DiagnosticProperties getJstatClass(String diagnosticCommand) {
        IPC.logMessage("jstat command : ", diagnosticCommand);
        StringWriter buffer = new StringWriter(100);
        PrintWriter bufferPrinter = new PrintWriter(buffer);
        bufferPrinter.println("Class Loaded    Class Unloaded");
        bufferPrinter.printf("%12d    %14d%n", ClassLoaderInfoBaseImpl.getLoadedClassCountImpl(), ClassLoaderInfoBaseImpl.getUnloadedClassCountImpl());
        bufferPrinter.flush();
        return DiagnosticProperties.makeStringResult(buffer.toString());
    }

    private static DiagnosticProperties loadJVMTIAgent(String diagnosticCommand) {
        DiagnosticProperties result;
        String[] parts = diagnosticCommand.split(DIAGNOSTICS_OPTION_SEPARATOR);
        if (parts.length < 2) {
            result = DiagnosticProperties.makeErrorProperties("Too few arguments, the absolute path of the agent is required: " + diagnosticCommand);
        } else if (parts.length > 3) {
            result = DiagnosticProperties.makeErrorProperties("Command not recognized due to more than 3 arguments: " + diagnosticCommand);
        } else {
            String attachError = Attachment.loadAgentLibrary(parts[1], parts.length == 3 ? parts[2] : "", false);
            result = attachError == null ? DiagnosticProperties.makeStringResult("JVMTI.agent_load succeeded") : DiagnosticProperties.makeStatusProperties(true, attachError);
        }
        return result;
    }

    private static DiagnosticProperties doHelp(String diagnosticCommand) {
        String[] parts = diagnosticCommand.split(DIAGNOSTICS_OPTION_SEPARATOR);
        StringWriter buffer = new StringWriter(500);
        PrintWriter bufferPrinter = new PrintWriter(buffer);
        if (DIAGNOSTICS_HELP.equals(parts[0])) {
            if (parts.length == 1) {
                commandTable.keySet().stream().sorted().forEach(s -> bufferPrinter.println((String)s));
            } else if (parts.length == 2) {
                String helpText = helpTable.getOrDefault(parts[1], "No help available");
                bufferPrinter.printf("%s: ", parts[1]);
                bufferPrinter.printf(helpText, new Object[0]);
            }
        } else {
            bufferPrinter.print("Invalid command: " + diagnosticCommand);
        }
        return DiagnosticProperties.makeStringResult(buffer.toString());
    }

    static {
        IDCacheInitializer.init();
        commandTable = new HashMap<String, Function<String, DiagnosticProperties>>();
        helpTable = new HashMap<String, String>();
        commandTable.put(DIAGNOSTICS_HELP, DiagnosticUtils::doHelp);
        helpTable.put(DIAGNOSTICS_HELP, DIAGNOSTICS_HELP_HELP);
        commandTable.put(DIAGNOSTICS_GC_CLASS_HISTOGRAM, DiagnosticUtils::getHeapStatistics);
        helpTable.put(DIAGNOSTICS_GC_CLASS_HISTOGRAM, DIAGNOSTICS_GC_CLASS_HISTOGRAM_HELP);
        commandTable.put(DIAGNOSTICS_GC_RUN, s -> DiagnosticUtils.runGC());
        helpTable.put(DIAGNOSTICS_GC_RUN, DIAGNOSTICS_GC_RUN_HELP);
        commandTable.put(DIAGNOSTICS_THREAD_PRINT, DiagnosticUtils::getThreadInfo);
        helpTable.put(DIAGNOSTICS_THREAD_PRINT, DIAGNOSTICS_THREAD_PRINT_HELP);
        commandTable.put(DIAGNOSTICS_DUMP_HEAP, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_DUMP_HEAP, DIAGNOSTICS_DUMP_HEAP_HELP);
        commandTable.put(DIAGNOSTICS_GC_HEAP_DUMP, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_GC_HEAP_DUMP, DIAGNOSTICS_DUMP_HEAP_HELP);
        commandTable.put(DIAGNOSTICS_DUMP_JAVA, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_DUMP_JAVA, DIAGNOSTICS_DUMP_JAVA_HELP);
        commandTable.put(DIAGNOSTICS_DUMP_SNAP, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_DUMP_SNAP, DIAGNOSTICS_DUMP_SNAP_HELP);
        commandTable.put(DIAGNOSTICS_DUMP_SYSTEM, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_DUMP_SYSTEM, DIAGNOSTICS_DUMP_SYSTEM_HELP);
        commandTable.put(DIAGNOSTICS_STAT_CLASS, DiagnosticUtils::getJstatClass);
        helpTable.put(DIAGNOSTICS_STAT_CLASS, DIAGNOSTICS_JSTAT_CLASS_HELP);
        commandTable.put(DIAGNOSTICS_LOAD_JVMTI_AGENT, DiagnosticUtils::loadJVMTIAgent);
        helpTable.put(DIAGNOSTICS_LOAD_JVMTI_AGENT, DIAGNOSTICS_LOAD_JVMTI_AGENT_HELP);
    }
}

