/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.util.ArrayList;
import java.util.Arrays;

public class VersionID
implements Comparable {
    private final String[] _tuple;
    private final boolean _usePrefixMatch;
    private final boolean _useGreaterThan;
    private final boolean _isCompound;
    private final VersionID _rest;

    public VersionID(String string) {
        if (string == null || string.length() == 0) {
            this._tuple = new String[0];
            this._useGreaterThan = false;
            this._usePrefixMatch = false;
            this._isCompound = false;
            this._rest = null;
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = string.indexOf("&");
        if (n >= 0) {
            this._isCompound = true;
            VersionID versionID = new VersionID(string.substring(0, n));
            this._rest = new VersionID(string.substring(n + 1));
            this._tuple = versionID._tuple;
            this._usePrefixMatch = versionID._usePrefixMatch;
            this._useGreaterThan = versionID._useGreaterThan;
        } else {
            this._isCompound = false;
            this._rest = null;
            if (string.endsWith("+")) {
                this._useGreaterThan = true;
                this._usePrefixMatch = false;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("*")) {
                this._useGreaterThan = false;
                this._usePrefixMatch = true;
                string = string.substring(0, string.length() - 1);
            } else {
                this._useGreaterThan = false;
                this._usePrefixMatch = false;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (".-_".indexOf(string.charAt(i)) == -1) continue;
                if (n2 < i) {
                    String string2 = string.substring(n2, i);
                    arrayList.add(string2);
                }
                n2 = i + 1;
            }
            if (n2 < string.length()) {
                arrayList.add(string.substring(n2, string.length()));
            }
            this._tuple = arrayList.toArray(new String[0]);
        }
        Trace.println("Created version ID: " + this, TraceLevel.NETWORK);
    }

    public boolean isSimpleVersion() {
        return !this._useGreaterThan && !this._usePrefixMatch && !this._isCompound;
    }

    public boolean match(VersionID versionID) {
        if (this._isCompound && !this._rest.match(versionID)) {
            return false;
        }
        return this._usePrefixMatch ? this.isPrefixMatchTuple(versionID) : (this._useGreaterThan ? versionID.isGreaterThanOrEqualTuple(this) : this.matchTuple(versionID));
    }

    public boolean equals(Object object) {
        if (this.matchTuple(object)) {
            VersionID versionID = (VersionID)object;
            if ((this._rest == null || this._rest.equals(versionID._rest)) && this._useGreaterThan == versionID._useGreaterThan && this._usePrefixMatch == versionID._usePrefixMatch) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < this._tuple.length; ++i) {
            if (bl) {
                bl = false;
                n = this._tuple[i].hashCode();
                continue;
            }
            n ^= this._tuple[i].hashCode();
        }
        return n;
    }

    private boolean matchTuple(Object object) {
        if (object == null || !(object instanceof VersionID)) {
            return false;
        }
        VersionID versionID = (VersionID)object;
        String[] stringArray = this.normalize(this._tuple, versionID._tuple.length);
        String[] stringArray2 = this.normalize(versionID._tuple, this._tuple.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object2;
            Object object3 = this.getValueAsObject(stringArray[i]);
            if (object3.equals(object2 = this.getValueAsObject(stringArray2[i]))) continue;
            return false;
        }
        return true;
    }

    private Object getValueAsObject(String string) {
        if (string.length() > 0 && string.charAt(0) != '-') {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string;
    }

    public boolean isGreaterThan(VersionID versionID) {
        if (versionID == null) {
            return false;
        }
        return this.isGreaterThanOrEqualHelper(versionID, false, true);
    }

    public boolean isGreaterThanOrEqual(VersionID versionID) {
        if (versionID == null) {
            return false;
        }
        return this.isGreaterThanOrEqualHelper(versionID, true, true);
    }

    boolean isGreaterThanOrEqualTuple(VersionID versionID) {
        return this.isGreaterThanOrEqualHelper(versionID, true, false);
    }

    private boolean isGreaterThanOrEqualHelper(VersionID versionID, boolean bl, boolean bl2) {
        if (bl2 && this._isCompound && !this._rest.isGreaterThanOrEqualHelper(versionID, bl, true)) {
            return false;
        }
        boolean bl3 = false;
        String[] stringArray = this.normalize(this._tuple, versionID._tuple.length);
        String[] stringArray2 = this.normalize(versionID._tuple, this._tuple.length);
        char c = stringArray2[0].charAt(0);
        if (c == '7' || c == '8' || c == '9') {
            bl3 = true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            Object object;
            Object object2 = this.getValueAsObject(stringArray[i]);
            if (object2.equals(object = this.getValueAsObject(stringArray2[i]))) continue;
            if (object2 instanceof Integer && object instanceof Integer) {
                if (!bl3 && i > 2) {
                    return (Integer)object2 <= (Integer)object;
                }
                return (Integer)object2 > (Integer)object;
            }
            String string2 = stringArray[i].toString();
            return string2.compareTo(string = stringArray2[i].toString()) > 0;
        }
        return bl;
    }

    private boolean isPrefixMatchTuple(VersionID versionID) {
        String[] stringArray = this.normalize(versionID._tuple, this._tuple.length);
        for (int i = 0; i < this._tuple.length; ++i) {
            String string = this._tuple[i];
            String string2 = stringArray[i];
            if (string.equals(string2)) continue;
            return false;
        }
        return true;
    }

    private String[] normalize(String[] stringArray, int n) {
        if (stringArray.length < n) {
            Object[] objectArray = new String[n];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            Arrays.fill(objectArray, stringArray.length, objectArray.length, "0");
            return objectArray;
        }
        return stringArray;
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof VersionID)) {
            return -1;
        }
        VersionID versionID = (VersionID)object;
        return this.equals(versionID) ? 0 : (this.isGreaterThanOrEqual(versionID) ? 1 : -1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._tuple.length - 1; ++i) {
            stringBuffer.append(this._tuple[i]);
            stringBuffer.append('.');
        }
        if (this._tuple.length > 0) {
            stringBuffer.append(this._tuple[this._tuple.length - 1]);
        }
        if (this._useGreaterThan) {
            stringBuffer.append('+');
        }
        if (this._usePrefixMatch) {
            stringBuffer.append('*');
        }
        if (this._isCompound) {
            stringBuffer.append("&");
            stringBuffer.append(this._rest);
        }
        return stringBuffer.toString();
    }

    public VersionID getFamilyVersionID() {
        if (this._tuple.length < 3) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            stringBuffer.append(this._tuple[i]);
            stringBuffer.append('.');
        }
        stringBuffer.append('*');
        return new VersionID(stringBuffer.toString());
    }
}

