/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.panel.JreTableModel;
import com.sun.deploy.resources.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PathEditor
extends DefaultCellEditor
implements DocumentListener {
    private int row;
    private Border badBorder = new LineBorder(Color.red);
    private Border goodBorder = new LineBorder(Color.black);
    private Border currentBorder = this.badBorder;
    private JTable table;

    PathEditor() {
        super(new JTextField());
        ((JTextField)this.editorComponent).getDocument().addDocumentListener(this);
        this.editorComponent.getAccessibleContext().setAccessibleName(ResourceManager.getMessage("deploy.advanced.editor"));
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        jTable.getTableHeader().setResizingAllowed(false);
        this.row = n;
        this.table = jTable;
        super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        this.currentBorder = ((JreTableModel)jTable.getModel()).isPathValid(n) ? this.goodBorder : this.badBorder;
        this.editorComponent.setBorder(this.currentBorder);
        return this.editorComponent;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateBorderFromEditor();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateBorderFromEditor();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void updateBorderFromEditor() {
        Object object = this.getCellEditorValue();
        boolean bl = object instanceof String && this.table.getModel() instanceof JreTableModel ? JREInfo.isValidJREPath((String)object) : false;
        if (bl) {
            this.editorComponent.setBorder(this.goodBorder);
        } else {
            this.editorComponent.setBorder(this.badBorder);
        }
    }

    public boolean stopCellEditing() {
        this.table.getTableHeader().setResizingAllowed(true);
        return super.stopCellEditing();
    }
}

