/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.Division;
import java.math.Elementary;
import java.util.Arrays;
import java.util.Random;

class Primality {
    private static final int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021};
    private static final BigInteger[] BIprimes = new BigInteger[primes.length];
    private static final int[] BITS = new int[]{0, 0, 1854, 1233, 927, 747, 627, 543, 480, 431, 393, 361, 335, 314, 295, 279, 265, 253, 242, 232, 223, 216, 181, 169, 158, 150, 145, 140, 136, 132, 127, 123, 119, 114, 110, 105, 101, 96, 92, 87, 83, 78, 73, 69, 64, 59, 54, 49, 44, 38, 32, 26, 1};
    private static final int[][] offsetPrimes = new int[][]{null, null, {0, 2}, {2, 2}, {4, 2}, {6, 5}, {11, 7}, {18, 13}, {31, 23}, {54, 43}, {97, 75}};

    private Primality() {
    }

    static BigInteger nextProbablePrime(BigInteger bigInteger) {
        int n;
        int n2 = 1024;
        int[] nArray = new int[primes.length];
        boolean[] blArray = new boolean[n2];
        if (bigInteger.numberLength == 1 && bigInteger.digits[0] >= 0 && bigInteger.digits[0] < primes[primes.length - 1]) {
            int n3 = 0;
            while (bigInteger.digits[0] >= primes[n3]) {
                ++n3;
            }
            return BIprimes[n3];
        }
        BigInteger bigInteger2 = new BigInteger(1, bigInteger.numberLength, new int[bigInteger.numberLength + 1]);
        System.arraycopy(bigInteger.digits, 0, bigInteger2.digits, 0, bigInteger.numberLength);
        if (bigInteger.testBit(0)) {
            Elementary.inplaceAdd(bigInteger2, 2);
        } else {
            bigInteger2.digits[0] = bigInteger2.digits[0] | 1;
        }
        int n4 = bigInteger2.bitLength();
        int n5 = 2;
        while (n4 < BITS[n5]) {
            ++n5;
        }
        for (n = 0; n < primes.length; ++n) {
            nArray[n] = Division.remainder(bigInteger2, primes[n]) - n2;
        }
        while (true) {
            Arrays.fill(blArray, false);
            for (n = 0; n < primes.length; ++n) {
                nArray[n] = (nArray[n] + n2) % primes[n];
                int n6 = n4 = nArray[n] == 0 ? 0 : primes[n] - nArray[n];
                while (n4 < n2) {
                    blArray[n4] = true;
                    n4 += primes[n];
                }
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if (blArray[n4]) continue;
                BigInteger bigInteger3 = bigInteger2.copy();
                Elementary.inplaceAdd(bigInteger3, n4);
                if (!Primality.millerRabin(bigInteger3, n5)) continue;
                return bigInteger3;
            }
            Elementary.inplaceAdd(bigInteger2, n2);
        }
    }

    static BigInteger consBigInteger(int n, int n2, Random random) {
        if (n <= 10) {
            int[] nArray = offsetPrimes[n];
            return BIprimes[nArray[0] + random.nextInt(nArray[1])];
        }
        int n3 = -n & 0x1F;
        int n4 = n + 31 >> 5;
        BigInteger bigInteger = new BigInteger(1, n4, new int[n4]);
        --n4;
        do {
            for (int i = 0; i < bigInteger.numberLength; ++i) {
                bigInteger.digits[i] = random.nextInt();
            }
            int n5 = n4;
            bigInteger.digits[n5] = bigInteger.digits[n5] | Integer.MIN_VALUE;
            int n6 = n4;
            bigInteger.digits[n6] = bigInteger.digits[n6] >>> n3;
            bigInteger.digits[0] = bigInteger.digits[0] | 1;
        } while (!Primality.isProbablePrime(bigInteger, n2));
        return bigInteger;
    }

    static boolean isProbablePrime(BigInteger bigInteger, int n) {
        int n2;
        if (n <= 0 || bigInteger.numberLength == 1 && bigInteger.digits[0] == 2) {
            return true;
        }
        if (!bigInteger.testBit(0)) {
            return false;
        }
        if (bigInteger.numberLength == 1 && (bigInteger.digits[0] & 0xFFFFFC00) == 0) {
            return Arrays.binarySearch(primes, bigInteger.digits[0]) >= 0;
        }
        for (n2 = 1; n2 < primes.length; ++n2) {
            if (Division.remainderArrayByInt(bigInteger.digits, bigInteger.numberLength, primes[n2]) != 0) continue;
            return false;
        }
        int n3 = bigInteger.bitLength();
        n2 = 2;
        while (n3 < BITS[n2]) {
            ++n2;
        }
        n = Math.min(n2, 1 + (n - 1 >> 1));
        return Primality.millerRabin(bigInteger, n);
    }

    private static boolean millerRabin(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = bigInteger.subtract(BigInteger.ONE);
        int n2 = bigInteger2.bitLength();
        int n3 = bigInteger2.getLowestSetBit();
        BigInteger bigInteger3 = bigInteger2.shiftRight(n3);
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            BigInteger bigInteger4;
            if (i < primes.length) {
                bigInteger4 = BIprimes[i];
            } else {
                while ((bigInteger4 = new BigInteger(n2, random)).compareTo(bigInteger) >= 0 || bigInteger4.sign == 0 || bigInteger4.isOne()) {
                }
            }
            BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
            if (bigInteger5.isOne() || bigInteger5.equals(bigInteger2)) continue;
            for (int j = 1; j < n3; ++j) {
                if (bigInteger5.equals(bigInteger2) || !(bigInteger5 = bigInteger5.multiply(bigInteger5).mod(bigInteger)).isOne()) continue;
                return false;
            }
            if (bigInteger5.equals(bigInteger2)) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < primes.length; ++i) {
            Primality.BIprimes[i] = BigInteger.valueOf(primes[i]);
        }
    }
}

